/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.context.RulesRuntimeContextFactory;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.ForeignKeyColumnDescriptor;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITableModel;
import org.openl.rules.table.OpenLCloner;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.DynamicObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDescription {
    private final Logger log = LoggerFactory.getLogger(TestDescription.class);
    private final ParameterWithValueDeclaration[] executionParams;
    private final IOpenMethod testedMethod;
    private final DynamicObject testObject;
    private int index;
    private List<IOpenField> fields = new ArrayList<IOpenField>();
    private List<IOpenField> errorFields = new ArrayList<IOpenField>();

    public TestDescription(IOpenMethod testedMethod, DynamicObject testObject, List<IOpenField> fields, List<IOpenField> errorFields, ITableModel dataModel, IDataBase db) {
        this.testedMethod = testedMethod;
        this.testObject = testObject;
        this.fields = fields;
        this.errorFields = errorFields;
        this.executionParams = TestDescription.initExecutionParams(testedMethod, testObject, db, dataModel);
    }

    public TestDescription(IOpenMethod testedMethod, IRulesRuntimeContext context, Object[] arguments, IDataBase db) {
        this.testedMethod = testedMethod;
        this.testObject = TestDescription.createTestObject(testedMethod, context, arguments);
        this.executionParams = TestDescription.initExecutionParams(testedMethod, this.testObject, db, null);
    }

    private static DynamicObject createTestObject(IOpenMethod testedMethod, IRulesRuntimeContext context, Object[] arguments) {
        DynamicObject testObj = new DynamicObject();
        if (context != null) {
            testObj.setFieldValue("_context_", (Object)context);
        }
        IMethodSignature signature = testedMethod.getSignature();
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            String paramName = signature.getParameterName(i);
            testObj.setFieldValue(paramName, arguments[i]);
        }
        return testObj;
    }

    public IOpenMethod getTestedMethod() {
        return this.testedMethod;
    }

    public DynamicObject getTestObject() {
        return this.testObject;
    }

    public ParameterWithValueDeclaration[] getExecutionParams() {
        return this.executionParams;
    }

    public String[] getParametersNames() {
        String[] names = new String[this.executionParams.length];
        for (int i = 0; i < this.executionParams.length; ++i) {
            names[i] = this.executionParams[i].getName();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getArguments(OpenLCloner cloner) {
        Object[] args = new Object[this.executionParams.length];
        for (int i = 0; i < args.length; ++i) {
            Object value = this.executionParams[i].getValue();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (value != null) {
                    Thread.currentThread().setContextClassLoader(value.getClass().getClassLoader());
                }
                try {
                    args[i] = cloner.deepClone(value);
                }
                catch (RuntimeException e) {
                    this.log.error("Failed to clone an argument '{}'. Original argument will be used.", (Object)this.executionParams[i].getName());
                    args[i] = value;
                }
                continue;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return args;
    }

    private static ParameterWithValueDeclaration[] initExecutionParams(IOpenMethod testedMethod, DynamicObject testObject, IDataBase db, ITableModel dataModel) {
        ParameterWithValueDeclaration[] executionParams = new ParameterWithValueDeclaration[testedMethod.getSignature().getNumberOfParameters()];
        for (int i = 0; i < executionParams.length; ++i) {
            String paramName = testedMethod.getSignature().getParameterName(i);
            Object paramValue = testObject.getFieldValue(paramName);
            IOpenClass paramType = testedMethod.getSignature().getParameterType(i);
            IOpenField keyField = TestDescription.getKeyField(paramName, paramType, paramValue, db, dataModel);
            executionParams[i] = new ParameterWithValueDeclaration(paramName, paramValue, paramType, keyField);
        }
        return executionParams;
    }

    private Object getArgumentValue(String paramName) {
        return this.testObject.getFieldValue(paramName);
    }

    public boolean hasDescription() {
        return this.testObject.containsField("_description_");
    }

    public String getDescription() {
        return (String)this.getArgumentValue("_description_");
    }

    public boolean isExpectedResultDefined() {
        return this.testObject.containsField("_res_") || this.testObject.getType() != null && this.testObject.getType().getField("_res_") != null;
    }

    public Object getExpectedResult() {
        return this.getArgumentValue("_res_");
    }

    public boolean isExpectedErrorDefined() {
        return this.testObject.containsField("_error_");
    }

    public Object getExpectedError() {
        return this.getArgumentValue("_error_");
    }

    public boolean isRuntimeContextDefined() {
        return this.testObject.containsField("_context_");
    }

    public IRulesRuntimeContext getRuntimeContext(OpenLCloner cloner) {
        IRulesRuntimeContext context = (IRulesRuntimeContext)this.getArgumentValue("_context_");
        if (context == null) {
            return RulesRuntimeContextFactory.buildRulesRuntimeContext();
        }
        try {
            return (IRulesRuntimeContext)cloner.deepClone(context);
        }
        catch (Exception e) {
            this.log.error("Failed to clone context. Original context will be used.");
            return context;
        }
    }

    public String getId() {
        if (this.hasId()) {
            return String.valueOf(this.getArgumentValue("_id_"));
        }
        return String.valueOf(this.index + 1);
    }

    public boolean hasId() {
        return this.testObject.containsField("_id_");
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public List<IOpenField> getFields() {
        return this.fields;
    }

    public List<IOpenField> getErrorFields() {
        return this.errorFields;
    }

    protected static IOpenField getKeyField(String paramName, IOpenClass type, Object value, IDataBase db, ITableModel dataModel) {
        if (value == null) {
            return null;
        }
        IOpenField foreignKeyField = null;
        if (dataModel != null) {
            for (int colNum = 0; colNum < dataModel.getColumnCount(); ++colNum) {
                IdentifierNode[] fieldChainTokens;
                ColumnDescriptor columnDescriptor = dataModel.getDescriptor(colNum);
                if (columnDescriptor == null || (fieldChainTokens = columnDescriptor.getFieldChainTokens()).length <= 0 || !fieldChainTokens[0].getIdentifier().equals(paramName)) continue;
                if (columnDescriptor.isReference() && columnDescriptor instanceof ForeignKeyColumnDescriptor) {
                    ForeignKeyColumnDescriptor descriptor = (ForeignKeyColumnDescriptor)columnDescriptor;
                    foreignKeyField = descriptor.getForeignKeyField(type, db);
                    break;
                }
                if (fieldChainTokens.length <= 1) break;
                IdentifierNode fieldName = fieldChainTokens[fieldChainTokens.length - 1];
                foreignKeyField = type.getField(fieldName.getIdentifier());
                break;
            }
        }
        if (foreignKeyField == null) {
            foreignKeyField = type == null ? null : type.getIndexField();
        }
        return foreignKeyField;
    }

    public boolean isEmptyOrNewStyleErrorDescription() {
        return this.errorFields.size() == 0 || this.errorFields.size() == 1 && "this".equals(this.errorFields.get(0).getName());
    }
}

