/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.openl.rules.lang.xls.TableSyntaxNodeUtils;
import org.openl.rules.table.formatters.FormattersManager;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.ProjectHelper;
import org.openl.rules.testmethod.TestStatus;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.export.ResultExport;
import org.openl.rules.testmethod.result.ComparedResult;
import org.openl.types.IOpenMethod;

public class TestResultExport
extends ResultExport {
    @Override
    protected int writeInfo(Sheet sheet, TestUnitsResults result, int rowNum) {
        TestSuite testSuite = result.getTestSuite();
        int failures = result.getNumberOfFailures();
        Row row = sheet.createRow(rowNum++);
        String testName = TableSyntaxNodeUtils.getTestName((IOpenMethod)testSuite.getTestSuiteMethod());
        this.createCell(row, 1, testName, failures > 0 ? this.styles.testNameFailure : this.styles.testNameSuccess);
        row = sheet.createRow(rowNum++);
        Object testInfo = ProjectHelper.getTestInfo(testSuite);
        if (failures > 0) {
            testInfo = (String)testInfo + " (" + failures + " failed)";
        }
        this.createCell(row, 1, testInfo, this.styles.testInfo);
        return ++rowNum;
    }

    @Override
    protected void writeResultHeader(TestUnitsResults result, Row row, int colNum) {
        for (String name : result.getTestResultColumnDisplayNames()) {
            this.createCell(row, colNum++, name, this.styles.header);
        }
    }

    @Override
    protected void writeResult(Row row, int colNum, ITestUnit testUnit) {
        for (ComparedResult parameter : testUnit.getResultParams()) {
            boolean okField = parameter.getStatus() == TestStatus.TR_OK;
            Cell cell = this.createCell(row, colNum++, parameter.getActualValue(), okField ? this.styles.resultSuccess : this.styles.resultFailure);
            if (okField) continue;
            StringBuilder expected = new StringBuilder("Expected: ");
            Object expectedValue = this.getSimpleValue(parameter.getExpectedValue());
            if (expectedValue != null) {
                expected.append(FormattersManager.format(expectedValue));
            }
            TestResultExport.setCellComment(cell, expected.toString());
        }
    }
}

