/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.LinkedHashSet;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.constraints.RegexpValueConstraint;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.rules.validation.TablesValidator;
import org.openl.rules.validation.ValidationUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.validation.ValidationResult;

public class RegexpPropertyValidator
extends TablesValidator {
    private final String propertyName;
    private final String constraintsStr;

    public RegexpPropertyValidator(String propertyName, String constraintsStr) {
        this.propertyName = propertyName;
        this.constraintsStr = RegexpValueConstraint.getRegexPattern(constraintsStr);
    }

    @Override
    public ValidationResult validateTables(TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        LinkedHashSet<OpenLMessage> messages = new LinkedHashSet<OpenLMessage>();
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            String propertyValue;
            if (!PropertiesChecker.isPropertySuitableForTableType(this.propertyName, tsn.getType()) || tsn.getTableProperties() == null || tsn.getTableProperties().getPropertyLevelDefinedOn(this.propertyName) != InheritanceLevel.TABLE || (propertyValue = (String)tsn.getTableProperties().getPropertyValue(this.propertyName)) != null && propertyValue.matches(this.constraintsStr)) continue;
            SyntaxNodeException exception = SyntaxNodeExceptionUtils.createError((String)String.format("Incorrect value '%s' for property '%s'", propertyValue, TablePropertyDefinitionUtils.getPropertyDisplayName(this.propertyName)), (ISyntaxNode)tsn);
            messages.add((OpenLMessage)new OpenLErrorMessage((OpenLException)exception));
        }
        return ValidationUtils.withMessages(messages);
    }
}

