/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.event.style;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.util.CellAddress;
import org.openl.excel.parser.TableStyles;
import org.openl.excel.parser.event.style.OpenLCellFont;
import org.openl.excel.parser.event.style.OpenLCellStyle;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsCellComment;

public class EventTableStyles
implements TableStyles {
    private final IGridRegion region;
    private final int[][] cellIndexes;
    private final List<ExtendedFormatRecord> extendedFormats;
    private final Map<Integer, FormatRecord> customFormats;
    private final PaletteRecord palette;
    private final List<FontRecord> fonts;
    private final List<HSSFComment> comments;
    private final Map<CellAddress, String> formulas;

    public EventTableStyles(IGridRegion region, int[][] cellIndexes, List<ExtendedFormatRecord> extendedFormats, Map<Integer, FormatRecord> customFormats, PaletteRecord palette, List<FontRecord> fonts, List<HSSFComment> comments, Map<CellAddress, String> formulas) {
        this.region = region;
        this.cellIndexes = cellIndexes;
        this.extendedFormats = extendedFormats;
        this.customFormats = customFormats;
        this.palette = palette;
        this.fonts = fonts;
        this.comments = comments == null ? Collections.emptyList() : comments;
        this.formulas = formulas;
    }

    @Override
    public IGridRegion getRegion() {
        return this.region;
    }

    @Override
    public ICellStyle getStyle(int row, int column) {
        int index = this.cellIndexes[row - this.region.getTop()][column - this.region.getLeft()];
        return new OpenLCellStyle(index, this.extendedFormats.get(index), this.palette, this.customFormats);
    }

    @Override
    public ICellFont getFont(int row, int column) {
        int index = this.cellIndexes[row - this.region.getTop()][column - this.region.getLeft()];
        return new OpenLCellFont(this.getFont(this.extendedFormats.get(index).getFontIndex()), this.palette);
    }

    @Override
    public ICellComment getComment(int row, int column) {
        for (HSSFComment comment : this.comments) {
            if (!comment.hasPosition() || comment.getRow() != row || comment.getColumn() != column) continue;
            return new XlsCellComment((Comment)comment);
        }
        return null;
    }

    @Override
    public String getFormula(int row, int column) {
        return this.formulas.get(new CellAddress(row, column));
    }

    public FontRecord getFont(int index) {
        if (index > 4) {
            --index;
        }
        return this.fonts.get(index);
    }
}

