/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.calc.CellsHeaderExtractor;
import org.openl.rules.calc.SpreadsheetComponentsBuilder;
import org.openl.rules.calc.SpreadsheetContext;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.element.SpreadsheetCellRefType;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.calc.element.SpreadsheetExpressionMarker;
import org.openl.rules.calc.element.SpreadsheetStructureBuilderHolder;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.MessageUtils;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;

public class SpreadsheetStructureBuilder {
    public static final String DOLLAR_SIGN = "$";
    private final SpreadsheetComponentsBuilder componentsBuilder;
    private IBindingContext spreadsheetBindingContext;
    private final IOpenMethodHeader spreadsheetHeader;
    private final XlsModuleOpenClass xlsModuleOpenClass;
    private final SpreadsheetStructureBuilderHolder spreadsheetStructureBuilderHolder = new SpreadsheetStructureBuilderHolder(this);
    public static final ThreadLocal<Stack<Set<SpreadsheetCell>>> preventCellsLoopingOnThis = new ThreadLocal();
    private final Map<Integer, IBindingContext> rowContexts = new HashMap<Integer, IBindingContext>();
    private final Map<Integer, SpreadsheetOpenClass> colComponentOpenClasses = new HashMap<Integer, SpreadsheetOpenClass>();
    private final Map<Integer, Map<Integer, SpreadsheetContext>> spreadsheetResultContexts = new HashMap<Integer, Map<Integer, SpreadsheetContext>>();
    private SpreadsheetCell[][] cells;
    private final List<SpreadsheetCell> extractedCellValues = new ArrayList<SpreadsheetCell>();
    private volatile boolean cellsExtracted = false;

    public SpreadsheetStructureBuilderHolder getSpreadsheetStructureBuilderHolder() {
        return this.spreadsheetStructureBuilderHolder;
    }

    public SpreadsheetStructureBuilder(SpreadsheetComponentsBuilder componentsBuilder, IOpenMethodHeader spreadsheetHeader, XlsModuleOpenClass xlsModuleOpenClass) {
        this.componentsBuilder = componentsBuilder;
        this.spreadsheetHeader = spreadsheetHeader;
        this.xlsModuleOpenClass = xlsModuleOpenClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpreadsheetCell[][] getCells() {
        if (!this.cellsExtracted) {
            SpreadsheetStructureBuilder spreadsheetStructureBuilder = this;
            synchronized (spreadsheetStructureBuilder) {
                if (!this.cellsExtracted) {
                    try {
                        this.extractCellValues();
                    }
                    finally {
                        this.cellsExtracted = true;
                    }
                }
            }
        }
        return this.cells;
    }

    public void addCellFields(SpreadsheetOpenClass spreadsheetType, boolean autoType) {
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        CellsHeaderExtractor cellsHeadersExtractor = this.componentsBuilder.getCellsHeadersExtractor();
        int rowsCount = cellsHeadersExtractor.getHeight();
        int columnsCount = cellsHeadersExtractor.getWidth();
        this.cells = new SpreadsheetCell[rowsCount][columnsCount];
        this.spreadsheetBindingContext = new SpreadsheetContext(generalBindingContext, spreadsheetType, this.xlsModuleOpenClass);
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                SpreadsheetCell spreadsheetCell;
                this.cells[rowIndex][columnIndex] = spreadsheetCell = this.buildCell(rowIndex, columnIndex, autoType);
                this.addSpreadsheetFields(spreadsheetType, rowIndex, columnIndex);
            }
        }
    }

    private void extractCellValues() {
        CellsHeaderExtractor cellsHeadersExtractor = this.componentsBuilder.getCellsHeadersExtractor();
        int rowsCount = cellsHeadersExtractor.getHeight();
        int columnsCount = cellsHeadersExtractor.getWidth();
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            IBindingContext rowBindingContext = this.getRowContext(rowIndex);
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                boolean found = false;
                for (SpreadsheetCell cell : this.extractedCellValues) {
                    int row = cell.getRowIndex();
                    int column = cell.getColumnIndex();
                    if (row != rowIndex || columnIndex != column) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.extractCellValue(rowBindingContext, rowIndex, columnIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOpenClass makeType(SpreadsheetCell cell) {
        block12: {
            if (cell.getType() == null) {
                Stack<Set<SpreadsheetCell>> stack = preventCellsLoopingOnThis.get();
                boolean f = stack == null;
                try {
                    Set<Object> cellInProgressSet;
                    if (f) {
                        stack = new Stack();
                        preventCellsLoopingOnThis.set(stack);
                    }
                    if (stack.isEmpty()) {
                        cellInProgressSet = new HashSet();
                        stack.push(cellInProgressSet);
                    } else {
                        cellInProgressSet = stack.peek();
                    }
                    if (!cellInProgressSet.contains(cell)) {
                        try {
                            cellInProgressSet.add(cell);
                            int rowIndex = cell.getRowIndex();
                            int columnIndex = cell.getColumnIndex();
                            IBindingContext rowContext = this.getRowContext(rowIndex);
                            this.extractCellValue(rowContext, rowIndex, columnIndex);
                            this.extractedCellValues.add(cell);
                            break block12;
                        }
                        finally {
                            cellInProgressSet.remove(cell);
                        }
                    }
                    JavaOpenClass javaOpenClass = JavaOpenClass.OBJECT;
                    return javaOpenClass;
                }
                finally {
                    if (f) {
                        preventCellsLoopingOnThis.remove();
                    }
                }
            }
        }
        return cell.getType();
    }

    private void extractCellValue(IBindingContext rowBindingContext, int rowIndex, int columnIndex) {
        Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = this.componentsBuilder.getColumnHeaders();
        Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = this.componentsBuilder.getRowHeaders();
        SpreadsheetCell spreadsheetCell = this.cells[rowIndex][columnIndex];
        if (columnHeaders.get(columnIndex) == null || rowHeaders.get(rowIndex) == null) {
            spreadsheetCell.setValue(null);
            return;
        }
        ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getColumnNamesTable().getColumn(columnIndex));
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(cell.getSource(), this.spreadsheetBindingContext);
        String code = StringUtils.trimToNull((String)source.getCode());
        String name = SpreadsheetStructureBuilder.getSpreadsheetCellFieldName(columnHeaders.get(columnIndex).getDefinitionName(), rowHeaders.get(rowIndex).getDefinitionName());
        IOpenClass type = spreadsheetCell.getType();
        if (code == null) {
            spreadsheetCell.setValue(type.nullObject());
        } else if (SpreadsheetExpressionMarker.isFormula(code)) {
            int end = 0;
            if (code.startsWith(SpreadsheetExpressionMarker.OPEN_CURLY_BRACKET.getSymbol())) {
                end = -1;
            }
            SubTextSourceCodeModule srcCode = new SubTextSourceCodeModule((IOpenSourceCodeModule)source, 1, end);
            IMethodSignature signature = this.spreadsheetHeader.getSignature();
            IOpenClass declaringClass = this.spreadsheetHeader.getDeclaringClass();
            OpenMethodHeader header = new OpenMethodHeader(name, type, signature, declaringClass);
            SpreadsheetContext columnBindingContext = this.getColumnContext(columnIndex, rowIndex, rowBindingContext);
            OpenL openl = columnBindingContext.getOpenL();
            try {
                CompositeMethod method;
                if (header.getType() == null) {
                    method = OpenLManager.makeMethodWithUnknownType((OpenL)openl, (IOpenSourceCodeModule)srcCode, (String)name, (IMethodSignature)signature, (IOpenClass)declaringClass, (IBindingContext)columnBindingContext);
                    spreadsheetCell.setType((IOpenClass)(method.getType() != null ? method.getType() : NullOpenClass.the));
                } else {
                    method = OpenLManager.makeMethod((OpenL)openl, (IOpenSourceCodeModule)srcCode, (IOpenMethodHeader)header, (IBindingContext)columnBindingContext);
                }
                spreadsheetCell.setValue(method);
            }
            catch (Exception | LinkageError e) {
                spreadsheetCell.setType((IOpenClass)NullOpenClass.the);
                String message = String.format("Cannot parse cell value '%s' to the necessary type.", code);
                this.spreadsheetBindingContext.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ILocation)LocationUtils.createTextInterval((String)source.getCode()), (IOpenSourceCodeModule)source));
            }
        } else if (spreadsheetCell.isConstantCell()) {
            try {
                IOpenField openField = rowBindingContext.findVar("org.openl.this", code, true);
                ConstantOpenField constOpenField = (ConstantOpenField)openField;
                spreadsheetCell.setValue(constOpenField.getValue());
            }
            catch (Exception e) {
                String message = "Cannot parse cell value.";
                this.spreadsheetBindingContext.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)source));
            }
        } else {
            Class instanceClass = type.getInstanceClass();
            if (instanceClass == null) {
                String message = MessageUtils.getTypeDefinedErrorMessage((String)type.getName());
                this.spreadsheetBindingContext.addError(SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source));
            }
            try {
                SpreadsheetContext bindingContext = this.getColumnContext(columnIndex, rowIndex, rowBindingContext);
                ICell theCellValue = cell.getCell(0, 0);
                Object result = null;
                if (String.class == instanceClass) {
                    result = String2DataConvertorFactory.parse(instanceClass, code, (IBindingContext)bindingContext);
                } else {
                    if (theCellValue.hasNativeType()) {
                        result = RuleRowHelper.loadNativeValue(theCellValue, type);
                    }
                    if (result == null) {
                        result = String2DataConvertorFactory.parse(instanceClass, code, (IBindingContext)bindingContext);
                    }
                }
                if (bindingContext.isExecutionMode() && result instanceof IMetaHolder) {
                    ValueMetaInfo meta = new ValueMetaInfo(name, null, (IOpenSourceCodeModule)source);
                    ((IMetaHolder)result).setMetaInfo((IMetaInfo)meta);
                }
                IOpenCast openCast = bindingContext.getCast((IOpenClass)JavaOpenClass.getOpenClass((Class)instanceClass), type);
                spreadsheetCell.setValue(openCast.convert(result));
            }
            catch (Exception t) {
                String message = String.format("Cannot parse cell value '%s' to the necessary type.", code);
                this.spreadsheetBindingContext.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)t, null, (IOpenSourceCodeModule)source));
            }
        }
    }

    private void addSpreadsheetFields(SpreadsheetOpenClass spreadsheetType, int rowIndex, int columnIndex) {
        String simplifiedFieldName;
        IOpenField field1;
        SpreadsheetHeaderDefinition columnHeaders = this.componentsBuilder.getColumnHeaders().get(columnIndex);
        SpreadsheetHeaderDefinition rowHeaders = this.componentsBuilder.getRowHeaders().get(rowIndex);
        if (columnHeaders == null || rowHeaders == null) {
            return;
        }
        boolean oneColumnSpreadsheet = this.componentsBuilder.getColumnHeaders().size() == 1;
        boolean oneRowSpreadsheet = this.componentsBuilder.getRowHeaders().size() == 1;
        SymbolicTypeDefinition columnDefinition = columnHeaders.getDefinition();
        SymbolicTypeDefinition rowDefinition = rowHeaders.getDefinition();
        String columnName = columnDefinition.getName().getIdentifier();
        String rowName = rowDefinition.getName().getIdentifier();
        String fieldName = SpreadsheetStructureBuilder.getSpreadsheetCellFieldName(columnName, rowName);
        SpreadsheetCell spreadsheetCell = this.cells[rowIndex][columnIndex];
        this.createSpreadsheetCellField(spreadsheetType, spreadsheetCell, fieldName, SpreadsheetCellRefType.ROW_AND_COLUMN);
        if (oneColumnSpreadsheet) {
            String simplifiedFieldName2 = this.getSpreadsheetCellSimplifiedFieldName(rowName);
            IOpenField field12 = spreadsheetType.getField(simplifiedFieldName2);
            if (field12 == null) {
                this.createSpreadsheetCellField(spreadsheetType, spreadsheetCell, simplifiedFieldName2, SpreadsheetCellRefType.SINGLE_COLUMN);
            }
        } else if (oneRowSpreadsheet && ((field1 = spreadsheetType.getField(simplifiedFieldName = this.getSpreadsheetCellSimplifiedFieldName(columnName))) == null || field1 instanceof SpreadsheetCellField && ((SpreadsheetCellField)field1).isLastColumnRef())) {
            this.createSpreadsheetCellField(spreadsheetType, spreadsheetCell, simplifiedFieldName, SpreadsheetCellRefType.SINGLE_ROW);
        }
    }

    private String getSpreadsheetCellSimplifiedFieldName(String rowName) {
        return (DOLLAR_SIGN + rowName).intern();
    }

    public static String getSpreadsheetCellFieldName(String columnName, String rowName) {
        return (DOLLAR_SIGN + columnName + DOLLAR_SIGN + rowName).intern();
    }

    private SpreadsheetCell buildCell(int rowIndex, int columnIndex, boolean autoType) {
        IOpenClass cellType;
        SpreadsheetCellType spreadsheetCellType;
        Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = this.componentsBuilder.getColumnHeaders();
        Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = this.componentsBuilder.getRowHeaders();
        ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getColumnNamesTable().getColumn(columnIndex));
        ICell sourceCell = cell.getSource().getCell(0, 0);
        String cellCode = sourceCell.getStringValue();
        ConstantOpenField openField = null;
        if (cellCode == null || cellCode.isEmpty() || columnHeaders.get(columnIndex) == null || rowHeaders.get(rowIndex) == null) {
            spreadsheetCellType = SpreadsheetCellType.EMPTY;
        } else if (SpreadsheetExpressionMarker.isFormula(cellCode)) {
            spreadsheetCellType = SpreadsheetCellType.METHOD;
        } else {
            spreadsheetCellType = SpreadsheetCellType.VALUE;
            openField = RuleRowHelper.findConstantField(this.spreadsheetBindingContext, cellCode);
            if (openField != null) {
                spreadsheetCellType = SpreadsheetCellType.CONSTANT;
            }
        }
        ICell sourceCellForExecutionMode = this.spreadsheetBindingContext.isExecutionMode() ? null : sourceCell;
        SpreadsheetCell spreadsheetCell = new SpreadsheetCell(rowIndex, columnIndex, sourceCellForExecutionMode, spreadsheetCellType);
        SpreadsheetHeaderDefinition columnHeader = columnHeaders.get(columnIndex);
        SpreadsheetHeaderDefinition rowHeader = rowHeaders.get(rowIndex);
        if (openField != null) {
            cellType = openField.getType();
        } else if (columnHeader != null && columnHeader.getType() != null) {
            cellType = columnHeader.getType();
        } else if (rowHeader != null && rowHeader.getType() != null) {
            cellType = rowHeader.getType();
        } else {
            try {
                if (autoType) {
                    if (SpreadsheetExpressionMarker.isFormula(cellCode)) {
                        cellType = null;
                    } else if (cellCode != null) {
                        Object objectValue = sourceCell.getObjectValue();
                        if (objectValue instanceof String) {
                            String2DataConvertorFactory.getConvertor(Double.class).parse(cellCode, null);
                            cellType = JavaOpenClass.getOpenClass(Double.class);
                        } else {
                            cellType = JavaOpenClass.getOpenClass(objectValue.getClass());
                        }
                    } else {
                        cellType = NullOpenClass.the;
                    }
                } else {
                    if (!SpreadsheetExpressionMarker.isFormula(cellCode)) {
                        String2DataConvertorFactory.getConvertor(Double.class).parse(cellCode, null);
                    }
                    cellType = JavaOpenClass.getOpenClass(Double.class);
                }
            }
            catch (Exception t) {
                cellType = JavaOpenClass.getOpenClass(String.class);
            }
        }
        spreadsheetCell.setType(cellType);
        return spreadsheetCell;
    }

    private IBindingContext getRowContext(int rowIndex) {
        IBindingContext rowContext = this.rowContexts.get(rowIndex);
        if (rowContext == null) {
            rowContext = this.makeRowContext(rowIndex);
            this.rowContexts.put(rowIndex, rowContext);
        }
        return rowContext;
    }

    private SpreadsheetContext getColumnContext(int columnIndex, int rowIndex, IBindingContext rowBindingContext) {
        Map contexts = this.spreadsheetResultContexts.computeIfAbsent(columnIndex, e -> new HashMap());
        return contexts.computeIfAbsent(rowIndex, e -> this.makeSpreadsheetResultContext(columnIndex, rowBindingContext));
    }

    private SpreadsheetContext makeSpreadsheetResultContext(int columnIndex, IBindingContext rowBindingContext) {
        SpreadsheetOpenClass columnOpenClass = this.colComponentOpenClasses.computeIfAbsent(columnIndex, e -> this.makeColumnComponentOpenClass(columnIndex));
        return new SpreadsheetContext(rowBindingContext, columnOpenClass, this.xlsModuleOpenClass);
    }

    private SpreadsheetOpenClass makeColumnComponentOpenClass(int columnIndex) {
        String columnOpenClassName = String.format("%sColType%d", this.spreadsheetHeader.getName(), columnIndex);
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        Map<Integer, SpreadsheetHeaderDefinition> headers = this.componentsBuilder.getRowHeaders();
        SpreadsheetOpenClass columnOpenClass = new SpreadsheetOpenClass(columnOpenClassName, generalBindingContext.getOpenL());
        int height = this.cells.length;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            SpreadsheetHeaderDefinition headerDefinition = headers.get(rowIndex);
            this.proc(rowIndex, columnOpenClass, columnIndex, headerDefinition);
        }
        return columnOpenClass;
    }

    private IBindingContext makeRowContext(int rowIndex) {
        String rowOpenClassName = String.format("%sRowType%d", this.spreadsheetHeader.getName(), rowIndex);
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        Map<Integer, SpreadsheetHeaderDefinition> headers = this.componentsBuilder.getColumnHeaders();
        SpreadsheetOpenClass rowOpenClass = new SpreadsheetOpenClass(rowOpenClassName, generalBindingContext.getOpenL());
        int width = this.cells[0].length;
        for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
            SpreadsheetHeaderDefinition columnHeader = headers.get(columnIndex);
            this.proc(rowIndex, rowOpenClass, columnIndex, columnHeader);
        }
        return new SpreadsheetContext(this.spreadsheetBindingContext, rowOpenClass, this.xlsModuleOpenClass);
    }

    private void proc(int rowIndex, ComponentOpenClass rowOpenClass, int columnIndex, SpreadsheetHeaderDefinition columnHeader) {
        if (columnHeader == null) {
            return;
        }
        SpreadsheetCell cell = this.cells[rowIndex][columnIndex];
        SymbolicTypeDefinition typeDefinition = columnHeader.getDefinition();
        String fieldName = (DOLLAR_SIGN + typeDefinition.getName().getIdentifier()).intern();
        this.createSpreadsheetCellField(rowOpenClass, cell, fieldName, SpreadsheetCellRefType.LOCAL);
    }

    private void createSpreadsheetCellField(ComponentOpenClass rowOpenClass, SpreadsheetCell cell, String fieldName, SpreadsheetCellRefType spreadsheetCellRefType) {
        SpreadsheetStructureBuilderHolder structureBuilderContainer = this.getSpreadsheetStructureBuilderHolder();
        SpreadsheetCellField field = cell.getSpreadsheetCellType() == SpreadsheetCellType.METHOD ? new SpreadsheetCellField(structureBuilderContainer, (IOpenClass)rowOpenClass, fieldName, cell, spreadsheetCellRefType) : new SpreadsheetCellField.ConstSpreadsheetCellField(structureBuilderContainer, (IOpenClass)rowOpenClass, fieldName, cell);
        rowOpenClass.addField((IOpenField)field);
    }
}

