/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.dt.IBaseAction;
import org.openl.types.IOpenClass;
import org.openl.types.Invokable;
import org.openl.util.ClassUtils;
import org.openl.vm.IRuntimeEnv;

public class ActionInvoker
implements Invokable {
    private final int[] rules;
    private final IBaseAction[] actions;
    private final boolean returnEmptyResult;

    ActionInvoker(int[] rules, IBaseAction[] actions, boolean returnEmptyResult) {
        this.rules = rules;
        this.actions = actions;
        this.returnEmptyResult = returnEmptyResult;
    }

    private static Object addReturnValues(Collection<Object> returnValue, Object returnValues, boolean[] f) {
        int returnValuesLength = Array.getLength(returnValues);
        for (int i = 0; i < returnValuesLength; ++i) {
            if (!f[i] || Array.get(returnValues, i) == null) continue;
            returnValue.add(Array.get(returnValues, i));
        }
        return returnValue;
    }

    private Object addReturnValues(Map<Object, Object> returnValue, Object returnValues, Object keyValues, boolean[] f) {
        int returnValuesLength = Array.getLength(returnValues);
        for (int i = 0; i < returnValuesLength; ++i) {
            if (!f[i] || !this.isValidResult(Array.get(keyValues, i)) || !this.isValidResult(Array.get(returnValues, i))) continue;
            returnValue.put(Array.get(keyValues, i), Array.get(returnValues, i));
        }
        return returnValue;
    }

    private Object processReturnValue(Object returnValues, Object keyValues, boolean[] f, IOpenClass type) {
        if (type.isArray()) {
            Object ret;
            int i;
            int c = 0;
            for (boolean b : f) {
                if (!b) continue;
                ++c;
            }
            int returnValuesLength = Array.getLength(returnValues);
            if (c == 0) {
                int retLength = 0;
                for (i = 0; i < returnValuesLength; ++i) {
                    if (!this.isValidResult(Array.get(returnValues, i))) continue;
                    ++retLength;
                }
                ret = Array.newInstance(type.getComponentClass().getInstanceClass(), retLength);
            } else {
                ret = Array.newInstance(type.getComponentClass().getInstanceClass(), c);
            }
            int j = 0;
            for (i = 0; i < returnValuesLength; ++i) {
                if (!f[i] && c != 0 || !this.isValidResult(Array.get(returnValues, i))) continue;
                Array.set(ret, j, Array.get(returnValues, i));
                ++j;
            }
            return ret;
        }
        if (Map.class == type.getInstanceClass()) {
            return this.addReturnValues(new HashMap<Object, Object>(), returnValues, keyValues, f);
        }
        if (SortedMap.class == type.getInstanceClass()) {
            return this.addReturnValues(new TreeMap<Object, Object>(), returnValues, keyValues, f);
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Map.class)) {
            try {
                return this.addReturnValues((Map)type.getInstanceClass().newInstance(), returnValues, keyValues, f);
            }
            catch (Exception e) {
                throw new OpenLRuntimeException((Throwable)e);
            }
        }
        if (Collection.class == type.getInstanceClass() || List.class == type.getInstanceClass()) {
            return ActionInvoker.addReturnValues(new ArrayList<Object>(), returnValues, f);
        }
        if (Set.class == type.getInstanceClass()) {
            return ActionInvoker.addReturnValues(new HashSet<Object>(), returnValues, f);
        }
        if (SortedSet.class == type.getInstanceClass()) {
            return ActionInvoker.addReturnValues(new TreeSet<Object>(), returnValues, f);
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Collection.class)) {
            try {
                return ActionInvoker.addReturnValues((Collection)type.getInstanceClass().newInstance(), returnValues, f);
            }
            catch (Exception e) {
                throw new OpenLRuntimeException((Throwable)e);
            }
        }
        throw new OpenLRuntimeException();
    }

    private boolean isValidResult(Object actionResult) {
        return actionResult != null || this.returnEmptyResult;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        Object[] retVal = null;
        Object[] keyValues = null;
        Object returnValues = null;
        boolean[] f = null;
        boolean isCollectReturn = false;
        IOpenClass type = null;
        for (IBaseAction action : this.actions) {
            Object actionResult;
            int i;
            if (action.isCollectReturnAction()) {
                if (returnValues == null) {
                    type = action.getType();
                    returnValues = type.isArray() ? Array.newInstance(type.getComponentClass().getInstanceClass(), this.rules.length) : new Object[this.rules.length];
                    if (f == null) {
                        f = new boolean[this.rules.length];
                        Arrays.fill(f, false);
                    }
                }
                for (i = 0; i < this.rules.length; ++i) {
                    actionResult = action.executeAction(this.rules[i], target, params, env);
                    if (!this.isValidResult(actionResult) || Array.get(returnValues, i) != null && f[i]) continue;
                    Array.set(returnValues, i, actionResult);
                    f[i] = true;
                }
                retVal = returnValues;
                isCollectReturn = true;
                continue;
            }
            if (action.isCollectReturnKeyAction()) {
                if (keyValues == null) {
                    keyValues = new Object[this.rules.length];
                    if (f == null) {
                        f = new boolean[this.rules.length];
                        Arrays.fill(f, false);
                    }
                }
                for (i = 0; i < this.rules.length; ++i) {
                    actionResult = action.executeAction(this.rules[i], target, params, env);
                    if (!this.isValidResult(actionResult) || Array.get(keyValues, i) != null && f[i]) continue;
                    Array.set(keyValues, i, actionResult);
                    f[i] = true;
                }
                continue;
            }
            actionResult = null;
            for (i = 0; i < this.rules.length; ++i) {
                if (action.isReturnAction()) {
                    actionResult = action.executeAction(this.rules[i], target, params, env);
                    if (!this.isValidResult(actionResult)) continue;
                    break;
                }
                action.executeAction(this.rules[i], target, params, env);
            }
            if (retVal != null || actionResult == null) continue;
            retVal = actionResult;
            isCollectReturn = false;
        }
        if (isCollectReturn) {
            return this.processReturnValue(retVal, keyValues, f, type);
        }
        return retVal;
    }

    public int[] getRules() {
        return this.rules;
    }
}

