/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import org.openl.binding.MethodUtil;
import org.openl.domain.IIntIterator;
import org.openl.rules.dt.ActionInvoker;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableRuntimePool;
import org.openl.rules.dt.IBaseAction;
import org.openl.rules.dt.algorithm.FailOnMissException;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.enumeration.DTEmptyResultProcessingEnum;
import org.openl.rules.method.RulesMethodInvoker;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.util.OpenClassUtils;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class DecisionTableInvoker
extends RulesMethodInvoker<DecisionTable> {
    private final boolean returnEmptyResult;
    private final IOpenClass retType;

    DecisionTableInvoker(DecisionTable decisionTable) {
        super(decisionTable);
        this.returnEmptyResult = decisionTable.getMethodProperties() != null && DTEmptyResultProcessingEnum.RETURN.equals((Object)decisionTable.getMethodProperties().getEmptyResultProcessing());
        this.retType = decisionTable.getType();
    }

    @Override
    public boolean canInvoke() {
        return ((DecisionTable)this.getInvokableMethod()).getAlgorithm() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeSimple(Object target, Object[] params, IRuntimeEnv env) {
        try {
            env.pushLocalFrame(new Object[]{new DecisionTableRuntimePool()});
            Object object = this.doInvoke(target, params, env);
            return object;
        }
        finally {
            env.popLocalFrame();
        }
    }

    private Object doInvoke(Object target, Object[] params, IRuntimeEnv env) {
        IDecisionTableAlgorithm algorithm = ((DecisionTable)this.getInvokableMethod()).getAlgorithm();
        IIntIterator rulesIntIterator = algorithm.checkedRules(target, params, env);
        boolean atLeastOneRuleFired = false;
        ArrayList<Integer> r = new ArrayList<Integer>();
        while (rulesIntIterator.hasNext()) {
            atLeastOneRuleFired = true;
            r.add(rulesIntIterator.nextInt());
        }
        int[] rules = new int[r.size()];
        int i = 0;
        for (Integer v : r) {
            rules[i++] = v;
        }
        IBaseAction[] actions = ((DecisionTable)this.getInvokableMethod()).getActionRows();
        Object returnValue = Tracer.invoke((Invokable)new ActionInvoker(rules, actions, this.returnEmptyResult), (Object)target, (Object[])params, (IRuntimeEnv)env, (Object)this);
        if (!OpenClassUtils.isVoid((IOpenClass)this.retType) && returnValue != null) {
            return returnValue;
        }
        if (!atLeastOneRuleFired && ((DecisionTable)this.getInvokableMethod()).shouldFailOnMiss()) {
            String method = MethodUtil.printMethodWithParameterValues((IOpenMethodHeader)((DecisionTable)this.getInvokableMethod()).getMethod(), (Object[])params);
            String message = String.format("Table '%s' failed to match any rule condition.", method);
            throw new FailOnMissException(message, (DecisionTable)this.getInvokableMethod());
        }
        return this.retType.nullObject();
    }
}

