/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.lang.reflect.Array;
import org.openl.binding.BindingDependencies;
import org.openl.types.IOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.vm.IRuntimeEnv;

public class ArrayHolder {
    private final Object[] values1;
    private final Object[][] values2;
    private final IOpenClass componentType;

    public ArrayHolder(IOpenClass componentType, Object[] values) {
        this.values1 = values;
        this.values2 = null;
        this.componentType = componentType;
    }

    public ArrayHolder(IOpenClass componentType, Object[][] values) {
        if (!componentType.isArray()) {
            throw new IllegalStateException("Expected an array component type");
        }
        this.values1 = null;
        this.values2 = values;
        this.componentType = componentType;
    }

    public boolean is2DimArray() {
        return this.values2 != null;
    }

    public Object[][] get2DimValues() {
        return this.values2;
    }

    public Object[] getValues() {
        return this.values1;
    }

    public Object invoke(Object target, Object[] dtParams, IRuntimeEnv env) {
        if (this.values2 != null) {
            Object res = this.componentType.getAggregateInfo().makeIndexedAggregate(this.componentType, this.values2.length);
            for (int i = 0; i < this.values2.length; ++i) {
                if (this.values2[i] == null) continue;
                Object array = this.componentType.getAggregateInfo().makeIndexedAggregate(this.componentType.getComponentClass(), this.values2[i].length);
                for (int j = 0; j < this.values2[i].length; ++j) {
                    if (this.values2[i][j] instanceof CompositeMethod) {
                        CompositeMethod compositeMethod = (CompositeMethod)this.values2[i][j];
                        Object result = compositeMethod.invoke(target, dtParams, env);
                        Array.set(array, j, result);
                        continue;
                    }
                    Array.set(array, j, this.values2[i][j] == null ? this.componentType.getComponentClass().nullObject() : this.values2[i][j]);
                }
                Array.set(res, i, array);
            }
            return res;
        }
        Object res = this.componentType.getAggregateInfo().makeIndexedAggregate(this.componentType, this.values1.length);
        for (int i = 0; i < this.values1.length; ++i) {
            if (this.values1[i] instanceof CompositeMethod) {
                CompositeMethod compositeMethod = (CompositeMethod)this.values1[i];
                Object result = compositeMethod.invoke(target, dtParams, env);
                Array.set(res, i, result);
                continue;
            }
            Array.set(res, i, this.values1[i] == null ? this.componentType.nullObject() : this.values1[i]);
        }
        return res;
    }

    public void updateDependency(BindingDependencies dependencies) {
        if (this.values2 != null) {
            Object[][] objectArray = this.values2;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] array;
                for (Object method : array = objectArray[i]) {
                    if (!(method instanceof CompositeMethod)) continue;
                    ((CompositeMethod)method).updateDependency(dependencies);
                }
            }
        } else {
            for (Object method : this.values1) {
                if (!(method instanceof CompositeMethod)) continue;
                ((CompositeMethod)method).updateDependency(dependencies);
            }
        }
    }
}

