/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openl.rules.table.ILogicalTable;

public class RuleRow {
    private final int row;
    private final ILogicalTable table;
    private final Map<Integer, String> cache = new HashMap<Integer, String>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public RuleRow(int row, ILogicalTable table) {
        this.row = row;
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRuleName(int col) {
        try {
            this.readLock.lock();
            String ruleName = this.cache.get(col);
            if (ruleName != null) {
                String string = ruleName;
                return string;
            }
        }
        finally {
            this.readLock.unlock();
        }
        try {
            ILogicalTable valueCell = (ILogicalTable)this.table.getSubtable(col + 4, this.row, 1, 1);
            String ruleName = valueCell.getSource().getCell(0, 0).getStringValue();
            if (ruleName == null) {
                ruleName = "";
            }
            this.writeLock.lock();
            this.cache.put(col, ruleName);
            String string = ruleName;
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

