/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import org.openl.util.StringUtils;

public class ArraySplitter {
    private static final char ARRAY_SEPARATOR = ',';
    private static final char ARRAY_ESCAPE = '\\';

    public static String[] split(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[ArraySplitter.count(text) + 1];
        int count = 0;
        int start = 0;
        int pos = -1;
        while ((pos = text.indexOf(44, pos + 1)) >= 0) {
            if (pos != 0 && text.charAt(pos - 1) == '\\') continue;
            result[count] = ArraySplitter.stripToNull(text, start, pos);
            start = pos + 1;
            ++count;
        }
        result[count] = ArraySplitter.stripToNull(text, start, text.length());
        return result;
    }

    public static boolean isArray(String text) {
        return text.indexOf(44) >= 0;
    }

    private static String stripToNull(String text, int start, int end) {
        int beginIndex = StringUtils.firstNonSpace((CharSequence)text, (int)start, (int)end);
        if (beginIndex < 0) {
            return null;
        }
        return text.substring(beginIndex, StringUtils.lastNonSpace((CharSequence)text, (int)start, (int)end) + 1).replace("\\,", ",");
    }

    private static int count(String text) {
        int count = 0;
        int pos = -1;
        while ((pos = text.indexOf(44, pos + 1)) >= 0) {
            if (pos != 0 && text.charAt(pos - 1) == '\\') continue;
            ++count;
        }
        return count;
    }
}

