/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import org.apache.poi.ss.usermodel.Sheet;
import org.openl.rules.lang.xls.load.CellLoader;
import org.openl.rules.lang.xls.load.LazyCellLoader;
import org.openl.rules.lang.xls.load.SheetLoader;
import org.openl.rules.lang.xls.load.WorkbookLoader;

public class LazySheetLoader
implements SheetLoader {
    private final WorkbookLoader workbookLoader;
    private final int sheetIndex;
    private String sheetName;

    public LazySheetLoader(WorkbookLoader workbookLoader, int sheetIndex) {
        this.workbookLoader = workbookLoader;
        this.sheetIndex = sheetIndex;
    }

    @Override
    public Sheet getSheet() {
        return this.workbookLoader.getWorkbook().getSheetAt(this.sheetIndex);
    }

    @Override
    public String getSheetName() {
        if (this.sheetName == null) {
            this.sheetName = this.getSheet().getSheetName();
        }
        return this.sheetName;
    }

    @Override
    public CellLoader getCellLoader(int column, int row) {
        return new LazyCellLoader(this, column, row);
    }
}

