/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.Date;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;

public class CompositeCell
implements ICell {
    private final int column;
    private final int row;
    private final IGridRegion region;
    private final ICell delegate;
    private final IGridTable gridTable;

    @Override
    public ICell getTopLeftCellFromRegion() {
        return this.delegate.getTopLeftCellFromRegion();
    }

    public CompositeCell(int column, int row, IGridRegion region, ICell delegate, IGridTable gridTable) {
        this.column = column;
        this.row = row;
        this.region = region;
        this.delegate = delegate;
        this.gridTable = gridTable;
    }

    @Override
    public int getAbsoluteColumn() {
        return this.delegate.getAbsoluteColumn();
    }

    @Override
    public int getAbsoluteRow() {
        return this.delegate.getAbsoluteRow();
    }

    @Override
    public IGridRegion getAbsoluteRegion() {
        return new GridRegion(this.delegate.getRow(), this.delegate.getColumn(), this.delegate.getRow(), this.delegate.getColumn());
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public IGridRegion getRegion() {
        return this.region;
    }

    @Override
    public ICellStyle getStyle() {
        return this.delegate.getStyle();
    }

    @Override
    public ICellFont getFont() {
        return this.delegate.getFont();
    }

    @Override
    public int getHeight() {
        if (!this.gridTable.isNormalOrientation()) {
            return this.getCellWidth();
        }
        return this.getCellHeight();
    }

    private int getCellHeight() {
        if (this.region == null) {
            return this.delegate.getHeight();
        }
        return this.region.getBottom() - this.region.getTop() + 1;
    }

    @Override
    public int getWidth() {
        if (!this.gridTable.isNormalOrientation()) {
            return this.getCellHeight();
        }
        return this.getCellWidth();
    }

    private int getCellWidth() {
        if (this.region == null) {
            return this.delegate.getWidth();
        }
        return this.region.getRight() - this.region.getLeft() + 1;
    }

    @Override
    public Object getObjectValue() {
        return this.delegate.getObjectValue();
    }

    @Override
    public String getStringValue() {
        return this.delegate.getStringValue();
    }

    @Override
    public String getFormula() {
        return this.delegate.getFormula();
    }

    @Override
    public int getType() {
        return this.delegate.getType();
    }

    @Override
    public String getUri() {
        return this.delegate.getUri();
    }

    @Override
    public boolean getNativeBoolean() {
        return this.delegate.getNativeBoolean();
    }

    @Override
    public double getNativeNumber() {
        return this.delegate.getNativeNumber();
    }

    @Override
    public int getNativeType() {
        return this.delegate.getNativeType();
    }

    @Override
    public boolean hasNativeType() {
        return this.delegate.hasNativeType();
    }

    @Override
    public Date getNativeDate() {
        return this.delegate.getNativeDate();
    }

    @Override
    public ICellComment getComment() {
        return this.delegate.getComment();
    }
}

