/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.ui.ICellStyle;

public abstract class AUndoableCellAction
implements IUndoableGridTableAction {
    private int col;
    private int row;
    private Object prevValue;
    private String prevFormula;
    private ICellStyle prevStyle;
    private String prevComment;
    private String prevCommentAuthor;
    private CellMetaInfo prevMetaInfo;
    protected final MetaInfoWriter metaInfoWriter;

    public AUndoableCellAction(int col, int row, MetaInfoWriter metaInfoWriter) {
        this.col = col;
        this.row = row;
        this.metaInfoWriter = metaInfoWriter;
    }

    protected void savePrevCell(IWritableGrid grid) {
        ICell cell = grid.getCell(this.col, this.row);
        this.setPrevValue(cell.getObjectValue());
        this.setPrevFormula(cell.getFormula());
        this.setPrevStyle(cell.getStyle());
        if (cell.getComment() != null) {
            this.setPrevComment(cell.getComment().getText());
            this.setPrevCommentAuthor(cell.getComment().getAuthor());
        }
        this.setPrevMetaInfo(this.metaInfoWriter.getMetaInfo(this.row, this.col));
    }

    protected void restorePrevCell(IWritableGrid grid) {
        if (this.prevValue != null || this.prevStyle != null) {
            grid.createCell(this.col, this.row, this.prevValue, this.prevFormula, this.prevStyle, this.prevComment, this.prevCommentAuthor);
        } else {
            grid.clearCell(this.col, this.row);
        }
        this.metaInfoWriter.setMetaInfo(this.row, this.col, this.prevMetaInfo);
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public Object getPrevValue() {
        return this.prevValue;
    }

    public void setPrevValue(Object prevValue) {
        this.prevValue = prevValue;
    }

    public String getPrevFormula() {
        return this.prevFormula;
    }

    public void setPrevFormula(String prevFormula) {
        this.prevFormula = prevFormula;
    }

    public ICellStyle getPrevStyle() {
        return this.prevStyle;
    }

    public void setPrevStyle(ICellStyle prevStyle) {
        this.prevStyle = prevStyle;
    }

    public String getPrevComment() {
        return this.prevComment;
    }

    public void setPrevComment(String prevComment) {
        this.prevComment = prevComment;
    }

    public String getPrevCommentAuthor() {
        return this.prevCommentAuthor;
    }

    public void setPrevCommentAuthor(String prevCommentAuthor) {
        this.prevCommentAuthor = prevCommentAuthor;
    }

    public CellMetaInfo getPrevMetaInfo() {
        return this.prevMetaInfo;
    }

    public void setPrevMetaInfo(CellMetaInfo prevMetaInfo) {
        this.prevMetaInfo = prevMetaInfo;
    }
}

