/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.formatters;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.openl.rules.helpers.ArraySplitter;
import org.openl.util.ArrayTool;
import org.openl.util.StringUtils;
import org.openl.util.formatters.IFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayFormatter
implements IFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(ArrayFormatter.class);
    private final IFormatter elementFormat;
    private final Class<?> elementType;

    public ArrayFormatter(IFormatter elementFormat, Class<?> elementType) {
        this.elementFormat = elementFormat;
        this.elementType = elementType;
    }

    public String format(Object value) {
        String result = null;
        if (value != null) {
            if (!value.getClass().isArray()) {
                LOG.debug("Should be an array: {}", value);
                return null;
            }
            Object[] array = ArrayTool.toArray((Object)value);
            CharSequence[] elementResults = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                elementResults[i] = this.elementFormat.format(element);
                result = String.join((CharSequence)",", elementResults);
            }
        }
        return result;
    }

    public Object parse(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] values = ArraySplitter.split(value);
            return Arrays.stream(values).map(arg_0 -> ((IFormatter)this.elementFormat).parse(arg_0)).toArray(e -> (Object[])Array.newInstance(this.elementType, e));
        }
        return null;
    }

    public IFormatter getElementFormat() {
        return this.elementFormat;
    }
}

