/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types;

import java.util.HashSet;
import java.util.Objects;
import org.openl.binding.MethodUtil;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.rules.lang.xls.binding.wrapper.WrapperLogic;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.types.IModuleInfo;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;

public final class DuplicateMemberThrowExceptionHelper {
    private DuplicateMemberThrowExceptionHelper() {
    }

    private static IOpenMethod extractOriginalMethod(IOpenMethod method) {
        if (method instanceof TestSuiteMethod) {
            method = ((TestSuiteMethod)method).getOriginalTestSuiteMethod();
        }
        return WrapperLogic.unwrapOpenMethod(method);
    }

    public static void throwDuplicateMethodExceptionIfMethodsAreNotTheSame(IOpenMethod newOpenMethod, IOpenMethod existedOpenMethod) {
        String message;
        boolean canBeDispatched;
        if ((newOpenMethod = DuplicateMemberThrowExceptionHelper.extractOriginalMethod(newOpenMethod)).equals(existedOpenMethod = DuplicateMemberThrowExceptionHelper.extractOriginalMethod(existedOpenMethod))) {
            return;
        }
        if (existedOpenMethod.getSignature().getNumberOfParameters() != newOpenMethod.getSignature().getNumberOfParameters()) {
            throw new IllegalStateException("Method signatures are not the same");
        }
        for (int i = 0; i < existedOpenMethod.getSignature().getNumberOfParameters(); ++i) {
            if (Objects.equals(existedOpenMethod.getSignature().getParameterType(i).getInstanceClass(), newOpenMethod.getSignature().getParameterType(i).getInstanceClass())) continue;
            throw new IllegalStateException("Method signatures are not the same");
        }
        HashSet<String> modules = new HashSet<String>();
        if (DuplicateMemberThrowExceptionHelper.extractModuleName(newOpenMethod) != null) {
            modules.add(DuplicateMemberThrowExceptionHelper.extractModuleName(newOpenMethod));
        }
        if (DuplicateMemberThrowExceptionHelper.extractModuleName(existedOpenMethod) != null) {
            modules.add(DuplicateMemberThrowExceptionHelper.extractModuleName(existedOpenMethod));
        }
        boolean bl = canBeDispatched = !(existedOpenMethod instanceof TestSuiteMethod) && !(newOpenMethod instanceof TestSuiteMethod);
        if (modules.isEmpty()) {
            message = canBeDispatched ? String.format("Method '%s' is already used with the same version, active status, properties set.", MethodUtil.printSignature((IOpenMethodHeader)existedOpenMethod, (int)1)) : String.format("Method '%s' is already used.", MethodUtil.printSignature((IOpenMethodHeader)existedOpenMethod, (int)1));
        } else if (modules.size() > 1) {
            String[] moduleNames = (String[])modules.stream().sorted().toArray(String[]::new);
            message = canBeDispatched ? String.format("Method '%s' is already used in modules '%s' and '%s' with the same version, active status, properties set.", MethodUtil.printSignature((IOpenMethodHeader)existedOpenMethod, (int)1), moduleNames[0], moduleNames[1]) : String.format("Method '%s' is already used in modules '%s' and '%s'.", existedOpenMethod.getName(), moduleNames[0], moduleNames[1]);
        } else {
            message = canBeDispatched ? String.format("Method '%s' is already used in module '%s' with the same version, active status, properties set.", MethodUtil.printSignature((IOpenMethodHeader)existedOpenMethod, (int)1), modules.iterator().next()) : String.format("Method '%s' is already used in module '%s'.", MethodUtil.printSignature((IOpenMethodHeader)existedOpenMethod, (int)1), modules.iterator().next());
        }
        throw new DuplicatedMethodException(message, existedOpenMethod, newOpenMethod);
    }

    private static String extractModuleName(IOpenMethod openMethod) {
        if (openMethod instanceof IModuleInfo) {
            return ((IModuleInfo)openMethod).getModuleName();
        }
        return null;
    }
}

