/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.binding.impl.cast.IOneElementArrayCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaInfo;
import org.openl.rules.calc.CellsHeaderExtractor;
import org.openl.rules.calc.ReturnSpreadsheetHeaderDefinition;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetSymbols;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetExpressionMarker;
import org.openl.rules.calc.result.ArrayResultBuilder;
import org.openl.rules.calc.result.EmptyResultBuilder;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.calc.result.ScalarResultBuilder;
import org.openl.rules.calc.result.SpreadsheetResultBuilder;
import org.openl.rules.lang.xls.syntax.SpreadsheetHeaderNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.SpreadsheetMetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.JavaKeywordUtils;
import org.openl.util.OpenClassUtils;
import org.openl.util.text.AbsolutePosition;
import org.openl.util.text.ILocation;
import org.openl.util.text.IPosition;
import org.openl.util.text.TextInfo;
import org.openl.util.text.TextInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetComponentsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SpreadsheetComponentsBuilder.class);
    private final TableSyntaxNode tableSyntaxNode;
    private final IBindingContext bindingContext;
    private final CellsHeaderExtractor cellsHeaderExtractor;
    private ReturnSpreadsheetHeaderDefinition returnHeaderDefinition;
    private final Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = new HashMap<Integer, SpreadsheetHeaderDefinition>();
    private final Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = new HashMap<Integer, SpreadsheetHeaderDefinition>();
    private final BidiMap<String, SpreadsheetHeaderDefinition> headerDefinitions = new DualHashBidiMap();

    public SpreadsheetComponentsBuilder(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) {
        this.tableSyntaxNode = tableSyntaxNode;
        CellsHeaderExtractor extractor = ((SpreadsheetHeaderNode)tableSyntaxNode.getHeader()).getCellHeadersExtractor();
        if (extractor == null) {
            extractor = new CellsHeaderExtractor(this.getSignature(tableSyntaxNode), (ILogicalTable)((ILogicalTable)tableSyntaxNode.getTableBody().getRow(0)).getColumns(1), (ILogicalTable)((ILogicalTable)tableSyntaxNode.getTableBody().getColumn(0)).getRows(1));
        }
        this.cellsHeaderExtractor = extractor;
        this.bindingContext = bindingContext;
    }

    public Map<Integer, SpreadsheetHeaderDefinition> getRowHeaders() {
        return this.rowHeaders;
    }

    public Map<Integer, SpreadsheetHeaderDefinition> getColumnHeaders() {
        return this.columnHeaders;
    }

    private static String removeWrongSymbols(String s) {
        if (s == null) {
            return null;
        }
        if (((String)(s = ((String)s).trim())).length() > 0) {
            s = ((String)s).replaceAll("\\s+", "_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ((String)s).length(); ++i) {
                if (!Character.isJavaIdentifierPart(((String)s).charAt(i))) continue;
                sb.append(((String)s).charAt(i));
            }
            s = sb.toString();
            if (JavaKeywordUtils.isJavaKeyword((String)s) || ((String)s).length() > 0 && !Character.isJavaIdentifierStart(((String)s).charAt(0))) {
                s = "_" + (String)s;
            }
        }
        return s;
    }

    public String[] getRowNamesForResultModel() {
        long rowsWithAsteriskCount = this.rowHeaders.entrySet().stream().filter(e -> ((SpreadsheetHeaderDefinition)e.getValue()).getDefinition().isAsteriskPresented()).count();
        String[] ret = rowsWithAsteriskCount > 0L ? this.buildArrayForHeaders(this.rowHeaders, this.cellsHeaderExtractor.getHeight(), e -> e.getDefinition().isAsteriskPresented()) : this.buildArrayForHeaders(this.rowHeaders, this.cellsHeaderExtractor.getHeight(), e -> !e.getDefinition().isTildePresented());
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = SpreadsheetComponentsBuilder.removeWrongSymbols(ret[i]);
        }
        return ret;
    }

    public String[] getColumnNamesForResultModel() {
        long columnsWithAsteriskCount = this.columnHeaders.entrySet().stream().filter(e -> ((SpreadsheetHeaderDefinition)e.getValue()).getDefinition().isAsteriskPresented()).count();
        String[] ret = columnsWithAsteriskCount > 0L ? this.buildArrayForHeaders(this.columnHeaders, this.cellsHeaderExtractor.getWidth(), e -> e.getDefinition().isAsteriskPresented()) : this.buildArrayForHeaders(this.columnHeaders, this.cellsHeaderExtractor.getWidth(), e -> !e.getDefinition().isTildePresented());
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = SpreadsheetComponentsBuilder.removeWrongSymbols(ret[i]);
        }
        return ret;
    }

    public String[] getRowNames() {
        return this.buildArrayForHeaders(this.rowHeaders, this.cellsHeaderExtractor.getHeight(), e -> true);
    }

    public String[] getColumnNames() {
        return this.buildArrayForHeaders(this.columnHeaders, this.cellsHeaderExtractor.getWidth(), e -> true);
    }

    private String[] buildArrayForHeaders(Map<Integer, SpreadsheetHeaderDefinition> headers, int size, Predicate<SpreadsheetHeaderDefinition> predicate) {
        String[] ret = new String[size];
        for (Map.Entry<Integer, SpreadsheetHeaderDefinition> x : headers.entrySet()) {
            int k = x.getKey();
            if (!predicate.test(x.getValue())) continue;
            ret[k] = x.getValue().getDefinitionName();
        }
        return ret;
    }

    public CellsHeaderExtractor getCellsHeadersExtractor() {
        return this.cellsHeaderExtractor;
    }

    public void buildHeaders(IOpenClass spreadsheetHeaderType) {
        this.addRowHeaders();
        this.addColumnHeaders();
        this.buildHeaderDefinitions();
        this.buildReturnCells(spreadsheetHeaderType);
    }

    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    public IResultBuilder buildResultBuilder(Spreadsheet spreadsheet, IBindingContext bindingContext) {
        IResultBuilder resultBuilder = null;
        try {
            resultBuilder = this.getResultBuilderInternal(spreadsheet, bindingContext);
        }
        catch (SyntaxNodeException e) {
            this.getBindingContext().addError(e);
        }
        return resultBuilder;
    }

    private void addRowHeaders() {
        String[] rowNames = this.cellsHeaderExtractor.getRowNames();
        for (int i = 0; i < rowNames.length; ++i) {
            if (rowNames[i] == null) continue;
            IGridTable rowNameForHeader = ((ILogicalTable)((ILogicalTable)this.cellsHeaderExtractor.getRowNamesTable().getRow(i)).getColumn(0)).getSource();
            GridCellSourceCodeModule source = new GridCellSourceCodeModule(rowNameForHeader, this.bindingContext);
            this.parseHeader(source, i, true);
        }
    }

    private void addColumnHeaders() {
        String[] columnNames = this.cellsHeaderExtractor.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i] == null) continue;
            IGridTable columnNameForHeader = ((ILogicalTable)((ILogicalTable)this.cellsHeaderExtractor.getColumnNamesTable().getColumn(i)).getRow(0)).getSource();
            GridCellSourceCodeModule source = new GridCellSourceCodeModule(columnNameForHeader, this.bindingContext);
            this.parseHeader(source, i, false);
        }
    }

    private void parseHeader(IOpenSourceCodeModule source, int index, boolean row) {
        try {
            SymbolicTypeDefinition parsed = this.parseHeaderElement(source);
            IdentifierNode name = parsed.getName();
            String headerName = name.getIdentifier();
            SpreadsheetHeaderDefinition h1 = (SpreadsheetHeaderDefinition)this.headerDefinitions.get((Object)headerName);
            if (h1 != null) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"The header definition is duplicated.", (ISyntaxNode)name);
                this.getBindingContext().addError(error);
                throw new DuplicatedVarException(null, headerName);
            }
            SpreadsheetHeaderDefinition header = row ? this.rowHeaders.computeIfAbsent(index, e -> new SpreadsheetHeaderDefinition(parsed, index, -1)) : this.columnHeaders.computeIfAbsent(index, e -> new SpreadsheetHeaderDefinition(parsed, -1, index));
            this.headerDefinitions.put((Object)headerName, (Object)header);
        }
        catch (SyntaxNodeException error) {
            this.getBindingContext().addError(error);
        }
    }

    private IdentifierNode removeSignInTheEnd(IdentifierNode identifierNode, String sign) {
        String s = StringUtils.stripEnd((String)identifierNode.getIdentifier(), null);
        int d = s.lastIndexOf(sign);
        if (d != s.length() - 1) {
            throw new IllegalStateException(String.format("'%s' symbols is not found.", sign));
        }
        String v = StringUtils.stripEnd((String)identifierNode.getIdentifier().substring(0, d), null);
        int delta = identifierNode.getIdentifier().length() - v.length();
        AbsolutePosition end = new AbsolutePosition(-delta + identifierNode.getLocation().getEnd().getAbsolutePosition(new TextInfo(identifierNode.getIdentifier())));
        TextInterval location = new TextInterval(identifierNode.getLocation().getStart(), (IPosition)end);
        return new IdentifierNode(identifierNode.getType(), (ILocation)location, v, identifierNode.getModule());
    }

    private SymbolicTypeDefinition parseHeaderElement(IOpenSourceCodeModule source) throws SyntaxNodeException {
        IdentifierNode[] nodes;
        try {
            nodes = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)SpreadsheetSymbols.TYPE_DELIMITER.toString());
        }
        catch (OpenLCompilationException e) {
            LOG.debug("Error occurred: ", (Throwable)e);
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot parse header.", (IOpenSourceCodeModule)source);
        }
        if (nodes.length == 0) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot parse header.", (IOpenSourceCodeModule)source);
        }
        IdentifierNode headerNameNode = nodes[0];
        boolean endsWithAsterisk = false;
        if ((nodes.length == 1 || nodes.length == 2) && nodes[0].getIdentifier().endsWith(SpreadsheetSymbols.ASTERISK.toString())) {
            headerNameNode = this.removeSignInTheEnd(nodes[0], SpreadsheetSymbols.ASTERISK.toString());
            endsWithAsterisk = true;
        }
        boolean endsWithTilde = false;
        if ((nodes.length == 1 || nodes.length == 2) && nodes[0].getIdentifier().endsWith(SpreadsheetSymbols.TILDE.toString())) {
            headerNameNode = this.removeSignInTheEnd(nodes[0], SpreadsheetSymbols.TILDE.toString());
            endsWithTilde = true;
        }
        switch (nodes.length) {
            case 1: {
                return new SymbolicTypeDefinition(headerNameNode, null, endsWithAsterisk, endsWithTilde, source);
            }
            case 2: {
                return new SymbolicTypeDefinition(headerNameNode, nodes[1], endsWithAsterisk, endsWithTilde, source);
            }
        }
        String message = String.format("Valid header format: name [%s type].", new Object[]{SpreadsheetSymbols.TYPE_DELIMITER});
        throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)nodes[2]);
    }

    private void buildHeaderDefinitions() {
        for (SpreadsheetHeaderDefinition headerDefinition : this.headerDefinitions.values()) {
            IdentifierNode identifier;
            SimpleNodeUsage nodeUsage;
            IOpenClass headerType = null;
            SymbolicTypeDefinition symbolicTypeDefinition = headerDefinition.getDefinition();
            IdentifierNode typeIdentifierNode = symbolicTypeDefinition.getType();
            if (typeIdentifierNode != null) {
                String typeIdentifier = typeIdentifierNode.getOriginalText();
                headerType = OpenLManager.makeType((OpenL)this.bindingContext.getOpenL(), (String)typeIdentifier, (IOpenSourceCodeModule)symbolicTypeDefinition.getSource(), (IBindingContext)this.bindingContext);
            }
            if (headerType != null) {
                headerDefinition.setType(headerType);
            }
            if (this.bindingContext.isExecutionMode() || !(this.getTableSyntaxNode().getMetaInfoReader() instanceof SpreadsheetMetaInfoReader)) continue;
            SpreadsheetMetaInfoReader metaInfoReader = (SpreadsheetMetaInfoReader)this.getTableSyntaxNode().getMetaInfoReader();
            ArrayList<SimpleNodeUsage> nodeUsages = new ArrayList<SimpleNodeUsage>();
            ILogicalTable cell = headerDefinition.getRow() >= 0 ? (ILogicalTable)this.cellsHeaderExtractor.getRowNamesTable().getRow(headerDefinition.getRow()) : (ILogicalTable)this.cellsHeaderExtractor.getColumnNamesTable().getColumn(headerDefinition.getColumn());
            if (headerDefinition.getDefinition().isAsteriskPresented()) {
                String s = SpreadsheetComponentsBuilder.removeWrongSymbols(headerDefinition.getDefinitionName());
                if (StringUtils.isEmpty((CharSequence)s)) {
                    s = "Empty string";
                }
                String stringValue = cell.getCell(0, 0).getStringValue();
                int d = stringValue.lastIndexOf(SpreadsheetSymbols.ASTERISK.toString());
                nodeUsage = new SimpleNodeUsage(0, d, s, null, NodeType.OTHER);
                nodeUsages.add(nodeUsage);
            }
            if (headerType != null && (identifier = this.cutTypeIdentifier(typeIdentifierNode)) != null) {
                IOpenClass type = headerType;
                while (type.getMetaInfo() == null && type.isArray()) {
                    type = type.getComponentClass();
                }
                IMetaInfo typeMeta = type.getMetaInfo();
                if (typeMeta != null) {
                    nodeUsage = new SimpleNodeUsage(identifier, typeMeta.getDisplayName(0), typeMeta.getSourceUrl(), NodeType.DATATYPE);
                    nodeUsages.add(nodeUsage);
                }
            }
            if (nodeUsages.isEmpty()) continue;
            CellMetaInfo cellMetaInfo = new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages);
            ICell c = cell.getCell(0, 0);
            metaInfoReader.addHeaderMetaInfo(c.getAbsoluteRow(), c.getAbsoluteColumn(), cellMetaInfo);
        }
    }

    private IdentifierNode cutTypeIdentifier(IdentifierNode typeIdentifierNode) {
        try {
            IdentifierNode[] nodes;
            IdentifierNode[] variableAndType = Tokenizer.tokenize((IOpenSourceCodeModule)typeIdentifierNode.getModule(), (String)SpreadsheetSymbols.TYPE_DELIMITER.toString());
            if (variableAndType.length > 1 && (nodes = Tokenizer.tokenize((IOpenSourceCodeModule)typeIdentifierNode.getModule(), (String)" []\n\r", (ILocation)variableAndType[1].getLocation())).length > 0) {
                return nodes[0];
            }
        }
        catch (OpenLCompilationException e) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Cannot parse header.", (ISyntaxNode)typeIdentifierNode);
            this.getBindingContext().addError(error);
            LOG.debug("Error occurred: ", (Throwable)e);
        }
        return null;
    }

    private void buildReturnCells(IOpenClass spreadsheetHeaderType) {
        int nonEmptyCellsCount;
        SpreadsheetHeaderDefinition headerDefinition = (SpreadsheetHeaderDefinition)this.headerDefinitions.get((Object)SpreadsheetSymbols.RETURN_NAME.toString());
        if (this.bindingContext.findType("org.openl.this", SpreadsheetResult.class.getSimpleName()).equals(spreadsheetHeaderType) && headerDefinition == null) {
            return;
        }
        if (headerDefinition == null) {
            for (SpreadsheetHeaderDefinition spreadsheetHeaderDefinition : this.headerDefinitions.values()) {
                if (headerDefinition != null && headerDefinition.getRow() >= spreadsheetHeaderDefinition.getRow()) continue;
                headerDefinition = spreadsheetHeaderDefinition;
            }
        }
        if (headerDefinition == null) {
            throw new IllegalStateException("Expected non-null headerDefinition");
        }
        if (Boolean.FALSE.equals(this.tableSyntaxNode.getTableProperties().getAutoType()) && headerDefinition.getType() == null) {
            headerDefinition.setType(spreadsheetHeaderType);
        } else if ((spreadsheetHeaderType.getAggregateInfo() == null || spreadsheetHeaderType.getAggregateInfo() != null && spreadsheetHeaderType.getAggregateInfo().getComponentType(spreadsheetHeaderType) == null) && (nonEmptyCellsCount = this.getNonEmptyCellsCount(headerDefinition)) == 1) {
            headerDefinition.setType(spreadsheetHeaderType);
        }
        String key = (String)this.headerDefinitions.getKey((Object)headerDefinition);
        this.returnHeaderDefinition = new ReturnSpreadsheetHeaderDefinition(headerDefinition);
        this.headerDefinitions.replace((Object)key, (Object)this.returnHeaderDefinition);
    }

    private int getNonEmptyCellsCount(SpreadsheetHeaderDefinition headerDefinition) {
        int fromRow = 0;
        int toRow = this.cellsHeaderExtractor.getHeight();
        int fromColumn = 0;
        int toColumn = this.cellsHeaderExtractor.getWidth();
        if (headerDefinition.isRow()) {
            fromRow = headerDefinition.getRow();
            toRow = fromRow + 1;
        } else {
            fromColumn = headerDefinition.getColumn();
            toColumn = fromColumn + 1;
        }
        int nonEmptyCellsCount = 0;
        for (int columnIndex = fromColumn; columnIndex < toColumn; ++columnIndex) {
            for (int rowIndex = fromRow; rowIndex < toRow; ++rowIndex) {
                ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.cellsHeaderExtractor.getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.cellsHeaderExtractor.getColumnNamesTable().getColumn(columnIndex));
                String value = cell.getSource().getCell(0, 0).getStringValue();
                boolean isFormula = Optional.ofNullable(StringUtils.trimToNull((String)value)).map(SpreadsheetExpressionMarker::isFormula).orElse(false);
                if (StringUtils.isBlank((CharSequence)value) || isFormula) continue;
                ++nonEmptyCellsCount;
            }
        }
        return nonEmptyCellsCount;
    }

    public boolean isExistsReturnHeader() {
        return this.returnHeaderDefinition != null;
    }

    public ReturnSpreadsheetHeaderDefinition getReturnHeaderDefinition() {
        return this.returnHeaderDefinition;
    }

    private IResultBuilder getResultBuilderInternal(Spreadsheet spreadsheet, IBindingContext bindingContext) throws SyntaxNodeException {
        IResultBuilder resultBuilder;
        if (OpenClassUtils.isVoid((IOpenClass)spreadsheet.getHeader().getType())) {
            return new EmptyResultBuilder();
        }
        SymbolicTypeDefinition symbolicTypeDefinition = null;
        if (this.isExistsReturnHeader()) {
            String key = (String)this.headerDefinitions.getKey((Object)this.returnHeaderDefinition);
            symbolicTypeDefinition = this.returnHeaderDefinition.findDefinition(key);
        }
        if (!this.isExistsReturnHeader() && bindingContext.findType("org.openl.this", SpreadsheetResult.class.getSimpleName()).equals(spreadsheet.getHeader().getType())) {
            resultBuilder = new SpreadsheetResultBuilder();
        } else {
            ArrayList<SpreadsheetCell> returnSpreadsheetCells = new ArrayList<SpreadsheetCell>();
            ArrayList<IOpenCast> casts = new ArrayList<IOpenCast>();
            ArrayList<SpreadsheetCell> returnSpreadsheetCellsAsArray = new ArrayList<SpreadsheetCell>();
            ArrayList<IOpenCast> castsAsArray = new ArrayList<IOpenCast>();
            IOpenClass type = spreadsheet.getType();
            IAggregateInfo aggregateInfo = type.getAggregateInfo();
            IOpenClass componentType = aggregateInfo.getComponentType(type);
            boolean asArray = false;
            ArrayList<SpreadsheetCell> sprCells = new ArrayList<SpreadsheetCell>();
            int n = this.returnHeaderDefinition.getRow();
            boolean byColumn = true;
            if (n < 0) {
                n = this.returnHeaderDefinition.getColumn();
                byColumn = false;
                for (int i = 0; i < spreadsheet.getCells().length; ++i) {
                    sprCells.add(spreadsheet.getCells()[i][n]);
                }
            } else {
                sprCells.addAll(Arrays.asList(spreadsheet.getCells()[n]));
            }
            ArrayList<SpreadsheetCell> nonEmptySpreadsheetCells = new ArrayList<SpreadsheetCell>();
            for (SpreadsheetCell cell : sprCells) {
                if (cell.isEmpty()) continue;
                nonEmptySpreadsheetCells.add(cell);
                if (cell.getType() == null) continue;
                IOpenCast cast = bindingContext.getCast(cell.getType(), type);
                if (cast != null && cast.isImplicit() && !(cast instanceof IOneElementArrayCast)) {
                    returnSpreadsheetCells.add(cell);
                    casts.add(cast);
                }
                if (!returnSpreadsheetCells.isEmpty() || componentType == null || (cast = bindingContext.getCast(cell.getType(), componentType)) == null || !cast.isImplicit() || cast instanceof IOneElementArrayCast) continue;
                returnSpreadsheetCellsAsArray.add(cell);
                castsAsArray.add(cast);
            }
            if (componentType != null && returnSpreadsheetCells.isEmpty()) {
                returnSpreadsheetCells = returnSpreadsheetCellsAsArray;
                this.returnHeaderDefinition.setType(componentType);
                casts = castsAsArray;
                asArray = true;
            } else {
                this.returnHeaderDefinition.setType(type);
            }
            SpreadsheetCell[] retCells = returnSpreadsheetCells.toArray(new SpreadsheetCell[0]);
            if (!returnSpreadsheetCells.isEmpty()) {
                if (asArray) {
                    this.returnHeaderDefinition.setReturnCells(byColumn, retCells);
                } else {
                    this.returnHeaderDefinition.setReturnCells(byColumn, (SpreadsheetCell)returnSpreadsheetCells.get(returnSpreadsheetCells.size() - 1));
                }
            } else if (!nonEmptySpreadsheetCells.isEmpty()) {
                if (asArray) {
                    this.returnHeaderDefinition.setReturnCells(byColumn, nonEmptySpreadsheetCells.toArray(new SpreadsheetCell[0]));
                } else {
                    this.returnHeaderDefinition.setReturnCells(byColumn, (SpreadsheetCell)nonEmptySpreadsheetCells.get(nonEmptySpreadsheetCells.size() - 1));
                }
            }
            if (returnSpreadsheetCells.size() == 0) {
                IdentifierNode symbolicTypeDefinitionName = Optional.ofNullable(symbolicTypeDefinition).map(SymbolicTypeDefinition::getName).orElse(null);
                if (!nonEmptySpreadsheetCells.isEmpty()) {
                    SpreadsheetCell nonEmptySpreadsheetCell = (SpreadsheetCell)nonEmptySpreadsheetCells.get(nonEmptySpreadsheetCells.size() - 1);
                    if (nonEmptySpreadsheetCell.getType() != null) {
                        throw SyntaxNodeExceptionUtils.createError((String)String.format("Cannot convert from '%s' to '%s'.", nonEmptySpreadsheetCell.getType().getName(), spreadsheet.getHeader().getType().getName()), (ISyntaxNode)Optional.ofNullable(nonEmptySpreadsheetCell.getMethod()).filter(CompositeMethod.class::isInstance).map(CompositeMethod.class::cast).map(CompositeMethod::getMethodBodyBoundNode).map(IBoundNode::getSyntaxNode).orElse((ISyntaxNode)symbolicTypeDefinitionName));
                    }
                    return null;
                }
                throw SyntaxNodeExceptionUtils.createError((String)"There is no return expression cell.", (ISyntaxNode)symbolicTypeDefinitionName);
            }
            resultBuilder = asArray ? new ArrayResultBuilder(retCells, castsAsArray.toArray(new IOpenCast[0]), type, this.isCalculateAllCellsInSpreadsheet(spreadsheet)) : new ScalarResultBuilder((SpreadsheetCell)returnSpreadsheetCells.get(returnSpreadsheetCells.size() - 1), (IOpenCast)casts.get(casts.size() - 1), this.isCalculateAllCellsInSpreadsheet(spreadsheet));
        }
        return resultBuilder;
    }

    private boolean isCalculateAllCellsInSpreadsheet(Spreadsheet spreadsheet) {
        return !Boolean.FALSE.equals(spreadsheet.getMethodProperties().getCalculateAllCells());
    }

    private String getSignature(TableSyntaxNode table) {
        return table.getHeader().getHeaderToken().getModule().getCode();
    }
}

