/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openl.binding.impl.AllowOnlyStrictFieldMatchType;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultBeanPropertyNamingStrategy;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultRootDictionaryContext;
import org.openl.rules.calc.SpreadsheetStructureBuilder;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.Point;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.CustomJavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.CollectionUtils;
import org.slf4j.LoggerFactory;

@XmlRootElement
@CustomJavaOpenClass(type=SpreadsheetResultOpenClass.class, variableInContextFinder=SpreadsheetResultRootDictionaryContext.class, normalize=true)
@AllowOnlyStrictFieldMatchType
public class SpreadsheetResult
implements Serializable {
    private static final int MAX_WIDTH = 4;
    private static final int MAX_HEIGHT = 10;
    private static final int MAX_DEPTH = 2;
    private static final int MAX_VALUE_LENGTH = 10240;
    Object[][] results;
    String[] columnNames;
    String[] rowNames;
    transient String[] rowNamesForResultModel;
    transient String[] columnNamesForResultModel;
    transient Map<String, Point> fieldsCoordinates;
    transient boolean tableStructureDetails;
    private transient ILogicalTable logicalTable;
    private transient CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass;
    private static final ThreadLocal<Integer> DEPTH_LOCAL_THREAD = new ThreadLocal();

    public SpreadsheetResult() {
    }

    public SpreadsheetResult(Object[][] results, String[] rowNames, String[] columnNames) {
        this(results, rowNames, columnNames, new String[rowNames.length], new String[columnNames.length], null);
        this.initFieldsCoordinates();
    }

    public SpreadsheetResult(Object[][] results, String[] rowNames, String[] columnNames, String[] rowNamesForResultModel, String[] columnNamesForResultModel, Map<String, Point> fieldsCoordinates) {
        this.rowNames = Objects.requireNonNull(rowNames);
        this.columnNames = Objects.requireNonNull(columnNames);
        this.rowNamesForResultModel = Objects.requireNonNull(rowNamesForResultModel);
        this.columnNamesForResultModel = Objects.requireNonNull(columnNamesForResultModel);
        if (rowNames.length != rowNamesForResultModel.length) {
            throw new IllegalArgumentException("The length of rowNames is not equal to the length of rowNamesForResultModel.");
        }
        if (columnNames.length != columnNamesForResultModel.length) {
            throw new IllegalArgumentException("The length of columnNames is not equal to the length of columnNamesForResultModel.");
        }
        this.results = results;
        this.fieldsCoordinates = fieldsCoordinates;
    }

    public SpreadsheetResult(SpreadsheetResult spr) {
        this(spr.results, spr.rowNames, spr.columnNames, spr.rowNamesForResultModel, spr.columnNamesForResultModel, spr.fieldsCoordinates);
        this.logicalTable = spr.logicalTable;
        this.customSpreadsheetResultOpenClass = spr.customSpreadsheetResultOpenClass;
        this.tableStructureDetails = spr.tableStructureDetails;
    }

    public boolean isFieldUsedInModel(String fieldName) {
        Point point = this.fieldsCoordinates.get(fieldName);
        if (point != null) {
            return this.columnNamesForResultModel[point.getColumn()] != null && this.rowNamesForResultModel[point.getRow()] != null;
        }
        return false;
    }

    static Map<String, Point> buildFieldsCoordinates(String[] columnNames, String[] rowNames, boolean simpleRefByColumn, boolean simpleRefByRow) {
        HashMap<String, Point> fieldsCoordinates = new HashMap<String, Point>();
        if (columnNames != null && rowNames != null) {
            int j;
            int i;
            long nonNullsColumnsCount = Arrays.stream(columnNames).filter(Objects::nonNull).count();
            long nonNullsRowsCount = Arrays.stream(rowNames).filter(Objects::nonNull).count();
            boolean simpleRefByC = nonNullsColumnsCount == 1L || simpleRefByRow;
            boolean simpleRefByR = nonNullsRowsCount == 1L || simpleRefByColumn;
            for (i = 0; i < rowNames.length; ++i) {
                for (j = 0; j < columnNames.length; ++j) {
                    if (columnNames[j] == null || rowNames[i] == null) continue;
                    fieldsCoordinates.put(SpreadsheetStructureBuilder.getSpreadsheetCellFieldName(columnNames[j], rowNames[i]), Point.get(j, i));
                }
            }
            if (simpleRefByC) {
                for (int j2 = 0; j2 < columnNames.length; ++j2) {
                    if (columnNames[j2] == null) continue;
                    for (int i2 = 0; i2 < rowNames.length; ++i2) {
                        if (rowNames[i2] == null) continue;
                        fieldsCoordinates.put("$" + rowNames[i2], Point.get(j2, i2));
                    }
                    break;
                }
            }
            if (simpleRefByR) {
                for (i = 0; i < rowNames.length; ++i) {
                    if (rowNames[i] == null) continue;
                    for (j = 0; j < columnNames.length; ++j) {
                        if (columnNames[j] == null) continue;
                        fieldsCoordinates.put("$" + columnNames[j], Point.get(j, i));
                    }
                    break;
                }
            }
        }
        return fieldsCoordinates;
    }

    private void initFieldsCoordinates() {
        this.fieldsCoordinates = SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames, false, false);
    }

    @XmlTransient
    public int getHeight() {
        return this.rowNames.length;
    }

    public Object[][] getResults() {
        return this.results;
    }

    public void setResults(Object[][] results) {
        this.results = (Object[][])results.clone();
    }

    @XmlTransient
    public int getWidth() {
        return this.columnNames.length;
    }

    public String[] getColumnNames() {
        return this.columnNames != null ? (String[])this.columnNames.clone() : null;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getRowNames() {
        return this.rowNames != null ? (String[])this.rowNames.clone() : null;
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = rowNames;
    }

    @XmlTransient
    public boolean isTableStructureDetails() {
        return this.tableStructureDetails;
    }

    public void setTableStructureDetails(boolean tableStructureDetails) {
        this.tableStructureDetails = tableStructureDetails;
    }

    public Object getValue(int row, int column) {
        return this.results[row][column];
    }

    public void setFieldValue(String name, Object value) {
        Point fieldCoordinates;
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        if ((fieldCoordinates = this.fieldsCoordinates.get(name)) != null) {
            this.setValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn(), value);
        }
    }

    protected void setValue(int row, int column, Object value) {
        this.results[row][column] = value;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public String getRowName(int row) {
        return this.rowNames[row];
    }

    @XmlTransient
    public ILogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public void setLogicalTable(ILogicalTable logicalTable) {
        this.logicalTable = logicalTable;
    }

    public Object getFieldValue(String name) {
        Point fieldCoordinates;
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        if ((fieldCoordinates = this.fieldsCoordinates.get(name)) != null) {
            return this.getValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn());
        }
        return null;
    }

    public boolean hasField(String name) {
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        return this.fieldsCoordinates.get(name) != null;
    }

    public String toString() {
        try {
            if (CollectionUtils.isEmpty((Object[])this.rowNames) || CollectionUtils.isEmpty((Object[])this.columnNames)) {
                return "[EMPTY]";
            }
            return this.printTable();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).debug(e.getMessage(), (Throwable)e);
            return super.toString();
        }
    }

    private String truncateStringValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.length() > 10240) {
            return value.substring(0, 10240) + " ... TRUNCATED ...";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printTable() {
        StringBuilder sb = new StringBuilder();
        Integer d = DEPTH_LOCAL_THREAD.get();
        d = d != null ? d : 0;
        try {
            DEPTH_LOCAL_THREAD.set(d + 1);
            int maxWidth = Math.min(4, this.getWidth());
            int maxHeight = Math.min(10, this.getHeight());
            int[] width = new int[maxWidth + 1];
            for (int i1 = 0; i1 <= maxHeight; ++i1) {
                for (int j1 = 0; j1 <= maxWidth; ++j1) {
                    width[j1] = Math.max(width[j1], i1 > 0 && j1 > 0 && this.getValue(i1 - 1, j1 - 1) instanceof SpreadsheetResult && d > 2 ? "... TRUNCATED TABLE ...".length() : this.truncateStringValue(this.getStringValue(j1, i1)).length());
                }
            }
            for (int i = 0; i <= maxHeight; ++i) {
                for (int j = 0; j <= maxWidth; ++j) {
                    if (j != 0) {
                        sb.append(" | ");
                    }
                    String cell = i > 0 && j > 0 && this.getValue(i - 1, j - 1) instanceof SpreadsheetResult && d > 2 ? "... TRUNCATED TABLE ..." : this.truncateStringValue(this.getStringValue(j, i));
                    sb.append(cell);
                    for (int k = 0; k < width[j] - cell.length(); ++k) {
                        sb.append(' ');
                    }
                }
                sb.append('\n');
            }
            if (this.getWidth() > 4 || this.getHeight() > 10) {
                sb.append("... TRUNCATED TABLE ...");
            }
        }
        finally {
            if (d == 0) {
                DEPTH_LOCAL_THREAD.remove();
            } else {
                DEPTH_LOCAL_THREAD.set(d);
            }
        }
        return sb.toString();
    }

    private String getStringValue(int col, int row) {
        if (col == 0 && row == 0) {
            return "-X-";
        }
        if (col == 0) {
            return this.getRowName(row - 1);
        }
        if (row == 0) {
            return this.getColumnName(col - 1);
        }
        Object value = this.getValue(row - 1, col - 1);
        if (value == null) {
            return "";
        }
        String s = Arrays.deepToString(new Object[]{value});
        return s.substring(1, s.length() - 1);
    }

    @XmlTransient
    public CustomSpreadsheetResultOpenClass getCustomSpreadsheetResultOpenClass() {
        return this.customSpreadsheetResultOpenClass;
    }

    public void setCustomSpreadsheetResultOpenClass(CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass) {
        this.customSpreadsheetResultOpenClass = customSpreadsheetResultOpenClass;
    }

    public Object toPlain() {
        return this.toPlain(null);
    }

    public Object toPlain(SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
        if (this.getCustomSpreadsheetResultOpenClass() != null) {
            return this.getCustomSpreadsheetResultOpenClass().createBean(this, spreadsheetResultBeanPropertyNamingStrategy);
        }
        return this.toMap(false, spreadsheetResultBeanPropertyNamingStrategy);
    }

    public Map<String, Object> toMap() {
        return this.toMap(true, null);
    }

    public Map<String, Object> toMap(boolean spreadsheetResultsToMap, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.columnNames != null && this.rowNames != null) {
            String[][] tableDetails;
            long nonNullsColumnsCount = Arrays.stream(this.columnNamesForResultModel).filter(Objects::nonNull).count();
            long nonNullsRowsCount = Arrays.stream(this.rowNamesForResultModel).filter(Objects::nonNull).count();
            boolean isSingleRow = nonNullsRowsCount == 1L;
            boolean isSingleColumn = nonNullsColumnsCount == 1L;
            boolean isTableStructureDetailsPresented = this.tableStructureDetails;
            String[][] stringArray = tableDetails = this.tableStructureDetails ? new String[this.rowNames.length][this.columnNames.length] : null;
            if (this.customSpreadsheetResultOpenClass != null) {
                Map<String, String> xmlNamesMap = this.customSpreadsheetResultOpenClass.getXmlNamesMap();
                for (Map.Entry<String, List<IOpenField>> e : this.customSpreadsheetResultOpenClass.getBeanFieldsMap().entrySet()) {
                    String key;
                    Point p;
                    List<IOpenField> openFields = e.getValue();
                    HashMap<String, Integer> p1 = new HashMap<String, Integer>();
                    HashSet<Point> points = new HashSet<Point>();
                    for (IOpenField openField : openFields) {
                        p = this.fieldsCoordinates.get(openField.getName());
                        if (p == null || points.contains(p) || this.columnNamesForResultModel[p.getColumn()] == null || this.rowNamesForResultModel[p.getRow()] == null) continue;
                        key = this.getKey(spreadsheetResultBeanPropertyNamingStrategy, xmlNamesMap, e, p);
                        p1.merge(key, 1, Integer::sum);
                        points.add(p);
                    }
                    for (IOpenField openField : openFields) {
                        p = this.fieldsCoordinates.get(openField.getName());
                        if (p == null || this.columnNamesForResultModel[p.getColumn()] == null || this.rowNamesForResultModel[p.getRow()] == null) continue;
                        key = this.getKey(spreadsheetResultBeanPropertyNamingStrategy, xmlNamesMap, e, p);
                        String fName = (Integer)p1.get(key) == 1 ? key : xmlNamesMap.get(e.getKey());
                        values.put(fName, SpreadsheetResult.convertSpreadsheetResult(this.getValue(p.getRow(), p.getColumn()), spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy));
                        if (!isTableStructureDetailsPresented) continue;
                        tableDetails[p.getRow()][p.getColumn()] = xmlNamesMap.get(e.getKey());
                    }
                }
            } else {
                for (int i = 0; i < this.rowNamesForResultModel.length; ++i) {
                    for (int j = 0; j < this.columnNamesForResultModel.length; ++j) {
                        if (this.columnNamesForResultModel[j] == null || this.rowNamesForResultModel[i] == null) continue;
                        Object fName = isSingleColumn ? (spreadsheetResultBeanPropertyNamingStrategy == null ? this.rowNamesForResultModel[i] : spreadsheetResultBeanPropertyNamingStrategy.transform(this.rowNamesForResultModel[i])) : (isSingleRow ? (spreadsheetResultBeanPropertyNamingStrategy == null ? this.columnNamesForResultModel[j] : spreadsheetResultBeanPropertyNamingStrategy.transform(this.columnNamesForResultModel[j])) : (spreadsheetResultBeanPropertyNamingStrategy == null ? this.columnNamesForResultModel[j] + "_" + this.rowNamesForResultModel[i] : spreadsheetResultBeanPropertyNamingStrategy.transform(this.columnNamesForResultModel[j], this.rowNamesForResultModel[i])));
                        Object fNewName = fName;
                        int k = 1;
                        while (values.containsKey(fNewName)) {
                            fNewName = (String)fName + k;
                            ++k;
                        }
                        values.put((String)fNewName, SpreadsheetResult.convertSpreadsheetResult(this.getValue(i, j), spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy));
                        if (!isTableStructureDetailsPresented) continue;
                        tableDetails[i][j] = fNewName;
                    }
                }
            }
            if (this.tableStructureDetails) {
                String[] sprStructureFieldNames = null;
                if (this.customSpreadsheetResultOpenClass != null) {
                    sprStructureFieldNames = this.customSpreadsheetResultOpenClass.getSprStructureFieldNames();
                }
                if (sprStructureFieldNames == null) {
                    sprStructureFieldNames = new String[]{CustomSpreadsheetResultOpenClass.findNonConflictFieldName(values.keySet(), "rowNames"), CustomSpreadsheetResultOpenClass.findNonConflictFieldName(values.keySet(), "columnNames"), CustomSpreadsheetResultOpenClass.findNonConflictFieldName(values.keySet(), "tableDetails")};
                }
                values.put(sprStructureFieldNames[0], this.rowNames);
                values.put(sprStructureFieldNames[1], this.columnNames);
                values.put(sprStructureFieldNames[2], tableDetails);
            }
        }
        return values;
    }

    private String getKey(SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy, Map<String, String> xmlNamesMap, Map.Entry<String, List<IOpenField>> e, Point p) {
        String key = spreadsheetResultBeanPropertyNamingStrategy == null ? xmlNamesMap.get(e.getKey()) : (this.customSpreadsheetResultOpenClass.isSimpleRefByRow() ? spreadsheetResultBeanPropertyNamingStrategy.transform(this.rowNamesForResultModel[p.getRow()]) : (this.customSpreadsheetResultOpenClass.isSimpleRefByColumn() ? spreadsheetResultBeanPropertyNamingStrategy.transform(this.columnNamesForResultModel[p.getColumn()]) : spreadsheetResultBeanPropertyNamingStrategy.transform(this.columnNamesForResultModel[p.getColumn()], this.rowNamesForResultModel[p.getRow()])));
        return key;
    }

    private static Object convertSpreadsheetResult(Object v, boolean spreadsheetResultsToMap, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
        if (v instanceof SpreadsheetResult) {
            SpreadsheetResult spreadsheetResult = (SpreadsheetResult)v;
            if (spreadsheetResult.getCustomSpreadsheetResultOpenClass() == null) {
                CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = spreadsheetResult.getCustomSpreadsheetResultOpenClass().getModule().getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass();
                return SpreadsheetResult.convertSpreadsheetResult(v, customSpreadsheetResultOpenClass.getBeanClass(), (IOpenClass)customSpreadsheetResultOpenClass, spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy);
            }
            return SpreadsheetResult.convertSpreadsheetResult(v, null, null, spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy);
        }
        return SpreadsheetResult.convertSpreadsheetResult(v, null, null, spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy);
    }

    public static Object convertSpreadsheetResult(Object v) {
        return SpreadsheetResult.convertSpreadsheetResult(v, null, null, false, null);
    }

    public static Object convertSpreadsheetResult(Object v, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
        return SpreadsheetResult.convertSpreadsheetResult(v, null, null, false, spreadsheetResultBeanPropertyNamingStrategy);
    }

    public static Object convertSpreadsheetResult(Object v, Class<?> toType, IOpenClass toTypeOpenClass, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
        return SpreadsheetResult.convertSpreadsheetResult(v, toType, toTypeOpenClass, false, spreadsheetResultBeanPropertyNamingStrategy);
    }

    public static Object convertBeansToSpreadsheetResults(Object v, Map<Class<?>, CustomSpreadsheetResultOpenClass> mapClassToSprOpenClass) {
        if (v == null) {
            return null;
        }
        if (v instanceof Collection) {
            return SpreadsheetResult.convertCollection((Collection)v, e -> SpreadsheetResult.convertBeansToSpreadsheetResults(e, mapClassToSprOpenClass));
        }
        if (v instanceof Map) {
            return SpreadsheetResult.convertMap((Map)v, e -> SpreadsheetResult.convertBeansToSpreadsheetResults(e, mapClassToSprOpenClass));
        }
        if (v.getClass().isArray()) {
            Class<?> componentType = v.getClass().getComponentType();
            Class<?> t = v.getClass();
            while (t.isArray()) {
                t = t.getComponentType();
            }
            int len = Array.getLength(v);
            Object newArray = null;
            if (mapClassToSprOpenClass.containsKey(t)) {
                newArray = Array.newInstance(SpreadsheetResult.class, len);
            } else if (ClassUtils.isAssignable(t, Map.class) || ClassUtils.isAssignable(t, Collection.class)) {
                newArray = Array.newInstance(componentType, len);
            }
            if (newArray != null) {
                for (int i = 0; i < len; ++i) {
                    Array.set(newArray, i, SpreadsheetResult.convertBeansToSpreadsheetResults(Array.get(v, i), mapClassToSprOpenClass));
                }
                return newArray;
            }
            return v;
        }
        if (mapClassToSprOpenClass.containsKey(v.getClass())) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass1 = mapClassToSprOpenClass.get(v.getClass());
            return customSpreadsheetResultOpenClass1.createSpreadsheetResult(v, mapClassToSprOpenClass);
        }
        return v;
    }

    private static Object convertSpreadsheetResult(Object v, Class<?> toType, IOpenClass toTypeOpenClass, boolean spreadsheetResultsToMap, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
        if (v == null) {
            return null;
        }
        if (v instanceof Collection) {
            return SpreadsheetResult.convertCollection((Collection)v, e -> SpreadsheetResult.convertSpreadsheetResult(e, spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy));
        }
        if (v instanceof Map) {
            return SpreadsheetResult.convertMap((Map)v, e -> SpreadsheetResult.convertSpreadsheetResult(e, spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy));
        }
        if (v.getClass().isArray()) {
            Class<?> componentType = v.getClass().getComponentType();
            Class<?> t = v.getClass();
            while (t.isArray()) {
                t = t.getComponentType();
            }
            int len = Array.getLength(v);
            if (ClassUtils.isAssignable(t, SpreadsheetResult.class)) {
                Object tmpArray = Array.newInstance(toType != null && toType.isArray() ? toType.getComponentType() : Object.class, len);
                for (int i = 0; i < len; ++i) {
                    Array.set(tmpArray, i, SpreadsheetResult.convertSpreadsheetResult(Array.get(v, i), toType != null && toType.isArray() ? toType.getComponentType() : null, toTypeOpenClass != null && toTypeOpenClass.isArray() ? toTypeOpenClass.getComponentClass() : null, spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy));
                }
                if (toType != null && toType.isArray() && Object.class != toType.getComponentType()) {
                    return tmpArray;
                }
                Class<?> c = null;
                boolean f = true;
                for (int i = 0; i < len; ++i) {
                    Object v1 = Array.get(tmpArray, i);
                    if (v1 == null) continue;
                    if (c == null) {
                        c = v1.getClass();
                        continue;
                    }
                    if (c.equals(v1.getClass())) continue;
                    f = false;
                }
                if (f && c != null) {
                    Object newArray = Array.newInstance(c, len);
                    for (int i = 0; i < len; ++i) {
                        Array.set(newArray, i, Array.get(tmpArray, i));
                    }
                    return newArray;
                }
                return tmpArray;
            }
            if (ClassUtils.isAssignable(SpreadsheetResult.class, t) || ClassUtils.isAssignable(t, Map.class) || ClassUtils.isAssignable(t, Collection.class)) {
                Object newArray = Array.newInstance(componentType, len);
                for (int i = 0; i < len; ++i) {
                    Array.set(newArray, i, SpreadsheetResult.convertSpreadsheetResult(Array.get(v, i), componentType, null, spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy));
                }
                return newArray;
            }
            return v;
        }
        if (v instanceof SpreadsheetResult) {
            SpreadsheetResult spreadsheetResult = (SpreadsheetResult)v;
            if (Map.class == toType || spreadsheetResultsToMap) {
                return spreadsheetResult.toMap(spreadsheetResultsToMap, spreadsheetResultBeanPropertyNamingStrategy);
            }
            if (toTypeOpenClass instanceof CustomSpreadsheetResultOpenClass && ((CustomSpreadsheetResultOpenClass)toTypeOpenClass).isGenerateBeanClass() && ((CustomSpreadsheetResultOpenClass)toTypeOpenClass).getBeanClass() == toType) {
                CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)toTypeOpenClass;
                return customSpreadsheetResultOpenClass.createBean(spreadsheetResult, spreadsheetResultBeanPropertyNamingStrategy);
            }
            if (toTypeOpenClass instanceof SpreadsheetResultOpenClass && ((SpreadsheetResultOpenClass)toTypeOpenClass).toCustomSpreadsheetResultOpenClass().isGenerateBeanClass() && ((SpreadsheetResultOpenClass)toTypeOpenClass).toCustomSpreadsheetResultOpenClass().getBeanClass() == toType) {
                CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = ((SpreadsheetResultOpenClass)toTypeOpenClass).toCustomSpreadsheetResultOpenClass();
                return customSpreadsheetResultOpenClass.createBean(spreadsheetResult, spreadsheetResultBeanPropertyNamingStrategy);
            }
            if (spreadsheetResult.getCustomSpreadsheetResultOpenClass() != null && toType == spreadsheetResult.getCustomSpreadsheetResultOpenClass().getModule().getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().getBeanClass()) {
                return spreadsheetResult.getCustomSpreadsheetResultOpenClass().getModule().getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().createBean(spreadsheetResult, spreadsheetResultBeanPropertyNamingStrategy);
            }
            return spreadsheetResult.toPlain();
        }
        return v;
    }

    private static Object convertMap(Map<?, ?> v, Function<Object, Object> function) {
        Map newMap;
        try {
            newMap = (Map)v.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return v;
        }
        for (Map.Entry<?, ?> e : v.entrySet()) {
            newMap.put(function.apply(e.getKey()), function.apply(e.getValue()));
        }
        return newMap;
    }

    private static Object convertCollection(Collection<?> v, Function<Object, Object> function) {
        Collection newCollection;
        try {
            newCollection = (Collection)v.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return v;
        }
        for (Object o : v) {
            newCollection.add(function.apply(o));
        }
        return newCollection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadsheetResult that = (SpreadsheetResult)o;
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        if (that.fieldsCoordinates == null) {
            that.initFieldsCoordinates();
        }
        if (this.fieldsCoordinates.keySet().equals(that.fieldsCoordinates.keySet())) {
            for (Map.Entry<String, Point> entry : this.fieldsCoordinates.entrySet()) {
                Object thatV;
                Object v = this.getFieldValue(entry.getKey());
                if (Objects.deepEquals(v, thatV = that.getFieldValue(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        return this.fieldsCoordinates.keySet().hashCode();
    }
}

