/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.openl.rules.table.CoordinatesTransformer;
import org.openl.rules.table.IGridTable;

public class TwoDimensionDecisionTableTransformer
implements CoordinatesTransformer {
    private static final int CONDITION_HEADERS_HEIGHT = 4;
    public static final int HCONDITION_HEADERS_HEIGHT = 3;
    private final int conditionsWidth;
    private final int hConditionsCount;
    private final int lookupValuesTableHeight;
    private final int lookupValuesTableWidth;
    private final int retTableWidth;
    private final int dtHeaderHeight;

    TwoDimensionDecisionTableTransformer(IGridTable entireTable, IGridTable lookupValuesTable, int retTableWidth) {
        this.lookupValuesTableHeight = lookupValuesTable.getHeight();
        this.lookupValuesTableWidth = lookupValuesTable.getWidth();
        this.conditionsWidth = entireTable.getWidth() - this.lookupValuesTableWidth;
        this.hConditionsCount = entireTable.getHeight() - this.lookupValuesTableHeight - 3;
        this.retTableWidth = retTableWidth;
        this.dtHeaderHeight = 4 + this.hConditionsCount - 1;
    }

    int getRetTableWidth() {
        return this.retTableWidth;
    }

    @Override
    public int getHeight() {
        return this.dtHeaderHeight + this.lookupValuesTableWidth / this.retTableWidth * this.lookupValuesTableHeight;
    }

    @Override
    public int getWidth() {
        return this.conditionsWidth + this.hConditionsCount + this.retTableWidth;
    }

    @Override
    public int getColumn(int col, int row) {
        if (row < this.dtHeaderHeight) {
            return col;
        }
        if (col < this.conditionsWidth) {
            return col;
        }
        if (col < this.conditionsWidth + this.hConditionsCount) {
            int hConditionValueIndex = (row - this.dtHeaderHeight) / this.lookupValuesTableHeight * this.retTableWidth;
            return this.conditionsWidth + hConditionValueIndex;
        }
        int hConditionValueIndex = (row - this.dtHeaderHeight) / this.lookupValuesTableHeight * this.retTableWidth;
        return this.conditionsWidth + hConditionValueIndex + col - this.conditionsWidth - this.hConditionsCount;
    }

    @Override
    public int getRow(int col, int row) {
        if (row < this.dtHeaderHeight) {
            return row;
        }
        if (col < this.conditionsWidth) {
            int conditionValueIndex = (row - this.dtHeaderHeight) % this.lookupValuesTableHeight;
            return this.dtHeaderHeight + conditionValueIndex;
        }
        if (col < this.conditionsWidth + this.hConditionsCount) {
            int hConditionIndex = col - this.conditionsWidth;
            return 3 + hConditionIndex;
        }
        int conditionValueIndex = (row - this.dtHeaderHeight) % this.lookupValuesTableHeight;
        return 3 + this.hConditionsCount + conditionValueIndex;
    }
}

