/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import java.util.Map;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.IStorageBuilder;
import org.openl.rules.dt.storage.StorageInfo;
import org.openl.rules.dt.storage.StorageUtils;

public abstract class StorageBuilder<T>
implements IStorageBuilder<T> {
    final StorageInfo info = new StorageInfo();

    public abstract void writeValue(T var1, int var2);

    public abstract void writeSpace(int var1);

    public abstract void writeElse(int var1);

    public abstract void writeFormula(Object var1, int var2);

    protected abstract void checkMinMax(Object var1);

    @Override
    public void writeObject(Object loadedValue, int index) {
        if (loadedValue == null || loadedValue == IStorage.StorageType.SPACE) {
            this.writeSpace(index);
            this.info.addSpaceIndex();
        } else if (loadedValue == IStorage.StorageType.ELSE) {
            this.writeElse(index);
            this.info.addElseIndex();
        } else if (StorageUtils.isFormula(loadedValue)) {
            this.writeFormula(loadedValue, index);
            this.info.addFormulaIndex();
        } else {
            this.checkMinMax(loadedValue);
            Map<Object, Integer> diffValues = this.info.getUniqueIndex();
            Integer index1 = diffValues.get(loadedValue);
            if (index1 == null) {
                int size = diffValues.size();
                diffValues.put(loadedValue, size);
            }
            this.writeValue(loadedValue, index);
        }
    }

    public StorageInfo getInfo() {
        return this.info;
    }
}

