/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.classes;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openl.rules.lang.xls.classes.ClassLocator;
import org.openl.rules.lang.xls.classes.LocatorExceptionHandler;

public class DirectoryClassLocator
implements ClassLocator {
    private final List<LocatorExceptionHandler> handlers;

    public DirectoryClassLocator() {
        this(new ArrayList());
    }

    public DirectoryClassLocator(List<? extends LocatorExceptionHandler> handlers) {
        this.handlers = new ArrayList<LocatorExceptionHandler>(handlers);
    }

    public void addExceptionHandler(LocatorExceptionHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public Collection<Class<?>> getClasses(URL pathURL, String packageName, ClassLoader classLoader) {
        File directory;
        try {
            directory = new File(pathURL.toURI());
        }
        catch (Exception e) {
            for (LocatorExceptionHandler handler : this.handlers) {
                handler.handleURLParseException(e);
            }
            return Collections.emptySet();
        }
        HashSet classes = new HashSet();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                String suffix;
                String fileName = file.getName();
                if (file.isDirectory() || !fileName.endsWith(suffix = ".class") || fileName.contains("$")) continue;
                try {
                    String className = fileName.substring(0, fileName.length() - suffix.length());
                    String fullClassName = packageName + "." + className;
                    Class<?> type = Class.forName(fullClassName, true, classLoader);
                    classes.add(type);
                }
                catch (Exception | LinkageError e) {
                    for (LocatorExceptionHandler handler : this.handlers) {
                        handler.handleClassInstatiateException(e);
                    }
                }
            }
        }
        return classes;
    }
}

