/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.range;

import java.text.ParseException;
import java.util.Objects;
import org.openl.rules.range.RangeParser;

public abstract class Range<T> {
    protected RangeParser parse(String text) {
        try {
            return RangeParser.parse(text);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse a range", e);
        }
    }

    protected void validate() {
        T left = this.getLeft();
        T right = this.getRight();
        if (left != null && right != null && this.compare(left, right) > 0) {
            StringBuilder sb = new StringBuilder(96);
            sb.append("The right bound '");
            this.format(sb, right);
            sb.append("' must be greater or equal than the left bound '");
            this.format(sb, left);
            sb.append("'.");
            throw new IllegalArgumentException(sb.toString());
        }
        Objects.requireNonNull(this.getType());
    }

    protected abstract Type getType();

    protected abstract T getLeft();

    protected abstract T getRight();

    protected abstract int compare(T var1, T var2);

    protected void format(StringBuilder sb, T value) {
        sb.append(value);
    }

    protected boolean contains(T value) {
        int comparison;
        if (value == null) {
            return false;
        }
        Type type = this.getType();
        if (type.left != Bound.UNBOUND && ((comparison = this.compare(this.getLeft(), value)) > 0 || comparison == 0 && type.left == Bound.OPEN)) {
            return false;
        }
        return type.right == Bound.UNBOUND || (comparison = this.compare(value, this.getRight())) <= 0 && (comparison != 0 || type.right != Bound.OPEN);
    }

    public boolean contains(Range<T> range) {
        if (this == range) {
            return true;
        }
        if (range == null) {
            return false;
        }
        if (this.getClass() != range.getClass()) {
            return false;
        }
        return this.compareLeft(range) <= 0 && this.compareRight(range) >= 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return this.getType().left == other.getType().left && this.getType().right == other.getType().right && Objects.equals(this.getLeft(), other.getLeft()) && Objects.equals(this.getRight(), other.getRight());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType().left, this.getType().right, this.getLeft(), this.getRight()});
    }

    public String toString() {
        StringBuilder s = new StringBuilder(20);
        Type type = this.getType();
        switch (type) {
            case OPEN: 
            case CLOSED: 
            case OPEN_CLOSED: 
            case CLOSED_OPEN: {
                s.append(type.left == Bound.OPEN ? (char)'(' : '[');
                this.format(s, this.getLeft());
                s.append("..");
                this.format(s, this.getRight());
                s.append(type.right == Bound.OPEN ? (char)')' : ']');
                break;
            }
            case LEFT_OPEN: {
                s.append("> ");
                this.format(s, this.getLeft());
                break;
            }
            case LEFT_CLOSED: {
                s.append(">= ");
                this.format(s, this.getLeft());
                break;
            }
            case RIGHT_OPEN: {
                s.append("< ");
                this.format(s, this.getRight());
                break;
            }
            case RIGHT_CLOSED: {
                s.append("<= ");
                this.format(s, this.getRight());
                break;
            }
            case DEGENERATE: {
                this.format(s, this.getLeft());
                break;
            }
            default: {
                s.append((Object)type);
            }
        }
        return s.toString();
    }

    private int compareLeft(Range<T> range) {
        Type type = this.getType();
        Type otherType = range.getType();
        if (type.left != Bound.UNBOUND) {
            if (otherType.left == Bound.UNBOUND) {
                return 1;
            }
            int comparison = this.compare(this.getLeft(), range.getLeft());
            if (comparison == 0 && type.left == otherType.left) {
                return 0;
            }
            return type.left == Bound.OPEN ? 1 : -1;
        }
        return otherType.left != Bound.UNBOUND ? -1 : 0;
    }

    private int compareRight(Range<T> range) {
        Type type = this.getType();
        Type otherType = range.getType();
        if (type.right != Bound.UNBOUND) {
            if (otherType.right == Bound.UNBOUND) {
                return -1;
            }
            int comparison = this.compare(this.getRight(), range.getRight());
            if (comparison == 0 && type.right == otherType.right) {
                return 0;
            }
            return type.right == Bound.OPEN ? -1 : 1;
        }
        return otherType.right != Bound.UNBOUND ? 1 : 0;
    }

    public static enum Type {
        OPEN(Bound.OPEN, Bound.OPEN),
        CLOSED(Bound.CLOSED, Bound.CLOSED),
        OPEN_CLOSED(Bound.OPEN, Bound.CLOSED),
        CLOSED_OPEN(Bound.CLOSED, Bound.OPEN),
        LEFT_OPEN(Bound.OPEN, Bound.UNBOUND),
        LEFT_CLOSED(Bound.CLOSED, Bound.UNBOUND),
        RIGHT_OPEN(Bound.UNBOUND, Bound.OPEN),
        RIGHT_CLOSED(Bound.UNBOUND, Bound.CLOSED),
        DEGENERATE(Bound.CLOSED, Bound.CLOSED);

        public final Bound left;
        public final Bound right;

        private Type(Bound left, Bound right) {
            this.left = left;
            this.right = right;
        }
    }

    public static enum Bound {
        OPEN,
        CLOSED,
        UNBOUND;

    }
}

