/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;

public class UndoableClearAction
extends AUndoableCellAction {
    private GridRegion toRestore;

    public UndoableClearAction(int col, int row, MetaInfoWriter metaInfoWriter) {
        super(col, row, metaInfoWriter);
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        this.savePrevCell(grid);
        grid.clearCell(this.getCol(), this.getRow());
        this.metaInfoWriter.setMetaInfo(this.getRow(), this.getCol(), null);
        this.clearRegion(grid);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        if (this.toRestore != null) {
            grid.addMergedRegion(this.toRestore);
        }
        this.restorePrevCell(grid);
    }

    private void clearRegion(IWritableGrid grid) {
        IGridRegion rrTo = grid.getRegionStartingAt(this.getCol(), this.getRow());
        if (rrTo == null) {
            return;
        }
        this.toRestore = new GridRegion(rrTo);
        grid.removeMergedRegion(this.toRestore);
    }
}

