/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.constraints;

import org.openl.rules.table.constraints.AbstractConstraint;
import org.openl.rules.table.constraints.Constraint;
import org.openl.rules.table.constraints.DataEnumConstraint;
import org.openl.rules.table.constraints.LessThanConstraint;
import org.openl.rules.table.constraints.MoreThanConstraint;
import org.openl.rules.table.constraints.RegexpValueConstraint;
import org.openl.rules.table.constraints.UniqueActiveTableConstraint;
import org.openl.rules.table.constraints.UniqueInModuleConstraint;

public class ConstraintFactory {
    public Constraint getConstraint(String value) {
        AbstractConstraint constraint = null;
        String string = value = value == null ? "" : value;
        if (value.matches("^\\s*([_a-zA-Z\\d\\$]+\\s*)?<\\s*[_a-zA-Z\\d\\$]+\\s*$")) {
            constraint = new LessThanConstraint(value);
        } else if (value.matches("^\\s*([_a-zA-Z\\d\\$]+\\s*)?>\\s*[_a-zA-Z\\d\\$]+\\s*$")) {
            constraint = new MoreThanConstraint(value);
        } else if (value.matches("^\\s*unique\\s+in\\s*:\\s*module\\s*$")) {
            constraint = new UniqueInModuleConstraint(value);
        } else if (value.matches("^\\s*unique\\s+in\\s*:\\s*TableGroup\\s*$")) {
            constraint = new UniqueActiveTableConstraint(value);
        } else if (value.matches("^\\s*data\\s*:\\s*([\\w_][\\d\\w_]*)\\s*$")) {
            constraint = new DataEnumConstraint(value);
        } else if (value.matches("^\\s*regexp\\s*:\\s*(\\S+)\\s*")) {
            constraint = new RegexpValueConstraint(value);
        }
        return constraint;
    }
}

