/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import java.net.URL;
import java.util.List;
import org.openl.rules.runtime.RulesEngineFactory;
import org.openl.rules.tbasic.IAlgorithmTableParserManager;
import org.openl.rules.tbasic.TableParserSpecificationBean;
import org.openl.rules.tbasic.compile.ConversionRuleBean;

public final class AlgorithmTableParserManager
implements IAlgorithmTableParserManager {
    private static volatile AlgorithmTableParserManager INSTANCE;
    private static final Object synchObjectForInstance;
    private final IAlgorithmTableParserManager rulesWrapperInstance;
    private volatile ConversionRuleBean[] convertionRules;
    private volatile ConversionRuleBean[] fixedConvertionRules;
    private final Object synchObjectForConvertionRules = new Object();
    private final Object synchObjectForFixedConvertionRules = new Object();

    public static AlgorithmTableParserManager getInstance() {
        AlgorithmTableParserManager.lazyLoadInstance();
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lazyLoadInstance() {
        if (INSTANCE == null) {
            Object object = synchObjectForInstance;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new AlgorithmTableParserManager();
                }
            }
        }
    }

    private AlgorithmTableParserManager() {
        URL sourceFile = AlgorithmTableParserManager.class.getResource("AlgorithmTableSpecification.xls");
        RulesEngineFactory<IAlgorithmTableParserManager> engineFactory = new RulesEngineFactory<IAlgorithmTableParserManager>(sourceFile, IAlgorithmTableParserManager.class);
        engineFactory.setExecutionMode(true);
        this.rulesWrapperInstance = (IAlgorithmTableParserManager)engineFactory.newInstance();
    }

    private static ConversionRuleBean[] fixBrokenValues(ConversionRuleBean[] conversionRules) {
        for (ConversionRuleBean conversionRule : conversionRules) {
            AlgorithmTableParserManager.fixBrokenValues(conversionRule.getOperationType());
            AlgorithmTableParserManager.fixBrokenValues(conversionRule.getOperationParam1());
            AlgorithmTableParserManager.fixBrokenValues(conversionRule.getOperationParam2());
            AlgorithmTableParserManager.fixBrokenValues(conversionRule.getLabel());
            AlgorithmTableParserManager.fixBrokenValues(conversionRule.getNameForDebug());
        }
        return conversionRules;
    }

    private static void fixBrokenValues(String[] label) {
        for (int i = 0; i < label.length; ++i) {
            if ("N/A".equalsIgnoreCase(label[i])) {
                label[i] = null;
                continue;
            }
            if (!"\"\"".equalsIgnoreCase(label[i])) continue;
            label[i] = "";
        }
    }

    @Override
    public TableParserSpecificationBean[] getAlgorithmSpecification() {
        return this.rulesWrapperInstance.getAlgorithmSpecification();
    }

    @Override
    public ConversionRuleBean[] getConversionRules() {
        this.lazyLoadConversionRules();
        return this.convertionRules;
    }

    public ConversionRuleBean[] getFixedConversionRules() {
        this.lazyLoadFixedConvertionRules();
        return this.fixedConvertionRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadConversionRules() {
        if (this.convertionRules == null) {
            Object object = this.synchObjectForConvertionRules;
            synchronized (object) {
                if (this.convertionRules == null) {
                    this.convertionRules = this.rulesWrapperInstance.getConversionRules();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadFixedConvertionRules() {
        if (this.fixedConvertionRules == null) {
            Object object = this.synchObjectForFixedConvertionRules;
            synchronized (object) {
                if (this.fixedConvertionRules == null) {
                    ConversionRuleBean[] draftConvertionRules = (ConversionRuleBean[])this.getConversionRules().clone();
                    this.fixedConvertionRules = AlgorithmTableParserManager.fixBrokenValues(draftConvertionRules);
                }
            }
        }
    }

    @Override
    public String whatIsOperationsGroupName(List<String> groupedOperationNames) {
        return this.rulesWrapperInstance.whatIsOperationsGroupName(groupedOperationNames);
    }

    @Override
    public String[] whatOperationsToGroup(String keyword) {
        return this.rulesWrapperInstance.whatOperationsToGroup(keyword);
    }

    static {
        synchObjectForInstance = new Object();
    }
}

