/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.TBasicSpecificationKey;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.CompileContext;
import org.openl.rules.tbasic.compile.ConversionRuleBean;
import org.openl.rules.tbasic.compile.ConversionRuleStep;
import org.openl.rules.tbasic.compile.ConversionRulesController;
import org.openl.rules.tbasic.compile.LabelManager;
import org.openl.rules.tbasic.compile.OperationFactory;
import org.openl.rules.tbasic.compile.OperationType;
import org.openl.rules.tbasic.compile.ParameterConverterManager;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenClass;

public class AlgoritmNodesCompiler {
    private final LabelManager labelManager;
    private final CompileContext currentCompileContext;
    private final ParameterConverterManager parameterConverter;
    private final OperationFactory operationFactory;
    private final List<OperationAnalyzer> operationAnalyzers = new ArrayList<OperationAnalyzer>();

    public AlgoritmNodesCompiler(IOpenClass returnType, CompileContext currentCompileContext, AlgorithmCompiler compiler) {
        this.operationAnalyzers.add(new CommonOperations());
        this.operationAnalyzers.add(new NotCompileOperations());
        this.operationAnalyzers.add(new NotCheckLabelOperations());
        this.labelManager = compiler.getLabelManager();
        this.currentCompileContext = currentCompileContext;
        this.parameterConverter = new ParameterConverterManager(compiler, returnType);
        this.operationFactory = new OperationFactory(this.parameterConverter);
    }

    public List<RuntimeOperation> compileNodes(List<AlgorithmTreeNode> nodes, IBindingContext bindingContext) {
        return this.compileNestedNodes(nodes, bindingContext);
    }

    private List<RuntimeOperation> compileNestedNodes(List<AlgorithmTreeNode> nodesToProcess, IBindingContext bindingContext) {
        int linkedNodesGroupSize;
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        for (int i = 0; i < nodesToProcess.size(); i += linkedNodesGroupSize) {
            if (AlgoritmNodesCompiler.hasUnreachableCode(nodesToProcess, i)) {
                IOpenSourceCodeModule errorSource = nodesToProcess.get(i + 1).getAlgorithmRow().getOperation().asSourceCodeModule();
                BindHelper.processError((String)"Unreachable code. Operations after BREAK,CONTINUE not allowed.", (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
            }
            linkedNodesGroupSize = AlgorithmCompilerTool.getLinkedNodesGroupSize(nodesToProcess, i);
            List<AlgorithmTreeNode> nodesToCompile = nodesToProcess.subList(i, i + linkedNodesGroupSize);
            emittedOperations.addAll(this.compileLinkedNodesGroup(nodesToCompile, bindingContext));
        }
        return emittedOperations;
    }

    private List<RuntimeOperation> compileLinkedNodesGroup(List<AlgorithmTreeNode> nodesToCompile, IBindingContext bindingContext) {
        List<StringValue> userDefinedLabels;
        assert (!nodesToCompile.isEmpty());
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        ConversionRuleBean conversionRule = ConversionRulesController.getInstance().getConvertionRule(nodesToCompile, bindingContext);
        if (conversionRule == null) {
            return Collections.emptyList();
        }
        boolean isLoopOperation = nodesToCompile.get(0).getSpecification().isLoopOperation();
        this.labelManager.startOperationsSet(isLoopOperation);
        this.labelManager.generateAllLabels(conversionRule.getLabel());
        RuntimeOperation beforeOperation = this.createOperationForFirstNodeField(nodesToCompile, "before", bindingContext);
        if (beforeOperation != null) {
            emittedOperations.add(beforeOperation);
        }
        for (ConversionRuleStep convertionStep : conversionRule.getConvertionSteps()) {
            List<RuntimeOperation> stepEmittedOperations = this.processConversionStep(nodesToCompile, convertionStep, bindingContext);
            emittedOperations.addAll(stepEmittedOperations);
        }
        RuntimeOperation afterOperation = this.createOperationForFirstNodeField(nodesToCompile, "after", bindingContext);
        if (afterOperation != null) {
            emittedOperations.add(afterOperation);
        }
        if (!(userDefinedLabels = nodesToCompile.get(0).getLabels()).isEmpty() && !emittedOperations.isEmpty()) {
            for (StringValue userDefinedLabel : userDefinedLabels) {
                this.currentCompileContext.setLabel(userDefinedLabel.getValue(), (RuntimeOperation)emittedOperations.get(0), bindingContext);
            }
        }
        this.labelManager.finishOperationsSet();
        return emittedOperations;
    }

    private RuntimeOperation createOperationForFirstNodeField(List<AlgorithmTreeNode> nodesToCompile, String fieldName, IBindingContext bindingContext) {
        String param = nodesToCompile.get(0).getAlgorithmRow().getOperation() + "." + fieldName;
        StringValue content = AlgorithmCompilerTool.getCellContent(nodesToCompile, param, bindingContext);
        RuntimeOperation operation = null;
        if (content.getValue() != null && !content.getValue().trim().isEmpty()) {
            ConversionRuleStep conversionStep = new ConversionRuleStep("Perform", param, null, null, fieldName + " execution");
            operation = this.operationFactory.createOperation(nodesToCompile, conversionStep, bindingContext);
        }
        return operation;
    }

    private static boolean hasUnreachableCode(List<AlgorithmTreeNode> nodesToProcess, int indexOfReturn) {
        return indexOfReturn < nodesToProcess.size() - 1 && (TBasicSpecificationKey.BREAK.toString().equals(nodesToProcess.get(indexOfReturn).getSpecificationKeyword()) || TBasicSpecificationKey.CONTINUE.toString().equals(nodesToProcess.get(indexOfReturn).getSpecificationKeyword()));
    }

    private List<RuntimeOperation> processConversionStep(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
        assert (!nodesToCompile.isEmpty());
        assert (conversionStep != null);
        String label = null;
        if (conversionStep.getLabelInstruction() != null) {
            label = this.labelManager.getLabelByInstruction(conversionStep.getLabelInstruction());
        }
        String operationType = conversionStep.getOperationType();
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        for (OperationAnalyzer analyzer : this.operationAnalyzers) {
            List<RuntimeOperation> operations;
            if (!analyzer.suits(operationType) || (operations = analyzer.getOperations(nodesToCompile, conversionStep, bindingContext)) == null) continue;
            emittedOperations.addAll(operations);
        }
        if (!emittedOperations.isEmpty() && label != null) {
            this.currentCompileContext.registerNewLabel(label, nodesToCompile.get(0), bindingContext);
            this.currentCompileContext.setLabel(label, (RuntimeOperation)emittedOperations.get(0), bindingContext);
        }
        return emittedOperations;
    }

    private final class NotCheckLabelOperations
    implements OperationAnalyzer {
        private NotCheckLabelOperations() {
        }

        @Override
        public boolean suits(String operationType) {
            return operationType.equals(OperationType.CHECK_LABEL.toString());
        }

        @Override
        public List<RuntimeOperation> getOperations(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
            String labelName = (String)AlgoritmNodesCompiler.this.parameterConverter.convertParam(nodesToCompile, String.class, conversionStep.getOperationParam1(), bindingContext);
            if (!AlgoritmNodesCompiler.this.currentCompileContext.isLabelRegistered(labelName)) {
                IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
                String errorMessage = String.format("Such label is not available from this place: '%s'.", labelName);
                BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
            }
            return null;
        }
    }

    private final class NotCompileOperations
    implements OperationAnalyzer {
        private NotCompileOperations() {
        }

        @Override
        public boolean suits(String operationType) {
            return operationType.equals(OperationType.COMPILE.toString());
        }

        @Override
        public List<RuntimeOperation> getOperations(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
            List<AlgorithmTreeNode> nodesToProcess = AlgorithmCompilerTool.getNestedInstructionsBlock(nodesToCompile, conversionStep.getOperationParam1(), bindingContext);
            return new ArrayList<RuntimeOperation>(AlgoritmNodesCompiler.this.compileNestedNodes(nodesToProcess, bindingContext));
        }
    }

    private final class CommonOperations
    implements OperationAnalyzer {
        private CommonOperations() {
        }

        @Override
        public boolean suits(String operationType) {
            return !operationType.startsWith("!");
        }

        @Override
        public List<RuntimeOperation> getOperations(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep, IBindingContext bindingContext) {
            ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
            RuntimeOperation emittedOperation = AlgoritmNodesCompiler.this.operationFactory.createOperation(nodesToCompile, conversionStep, bindingContext);
            emittedOperations.add(emittedOperation);
            return emittedOperations;
        }
    }

    public static interface OperationAnalyzer {
        public boolean suits(String var1);

        public List<RuntimeOperation> getOperations(List<AlgorithmTreeNode> var1, ConversionRuleStep var2, IBindingContext var3);
    }
}

