/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.ce;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.exception.FieldNotFoundException;
import org.openl.binding.impl.FieldBoundNode;
import org.openl.binding.impl.method.AOpenMethodDelegator;
import org.openl.binding.impl.method.MultiCallOpenMethod;
import org.openl.binding.impl.method.MultiCallOpenMethodMT;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.method.ITablePropertiesMethod;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

public class MethodNodeBinder
extends org.openl.binding.impl.MethodNodeBinder {
    private IOpenMethod extractMethod(IOpenMethod openMethod) {
        if (openMethod instanceof AOpenMethodDelegator) {
            return this.extractMethod(((AOpenMethodDelegator)openMethod).getDelegate());
        }
        return openMethod;
    }

    protected IMethodCaller processFoundMethodCaller(IMethodCaller methodCaller) {
        IOpenMethod openMethod;
        if (methodCaller instanceof MultiCallOpenMethod && this.isParallel(openMethod = this.extractMethod(methodCaller.getMethod()))) {
            MultiCallOpenMethod multiCallOpenMethod = (MultiCallOpenMethod)methodCaller;
            return new MultiCallOpenMethodMT(multiCallOpenMethod);
        }
        return methodCaller;
    }

    private boolean isParallel(IOpenMethod openMethod) {
        ITablePropertiesMethod tablePropertiesMethod;
        boolean parallel = false;
        if (openMethod instanceof ITablePropertiesMethod && Boolean.TRUE.equals((tablePropertiesMethod = (ITablePropertiesMethod)openMethod.getMethod()).getMethodProperties().getParallel())) {
            parallel = true;
        }
        if (openMethod instanceof OpenMethodDispatcher) {
            OpenMethodDispatcher openMethodDispatcher = (OpenMethodDispatcher)openMethod;
            boolean f = true;
            for (IOpenMethod method : openMethodDispatcher.getCandidates()) {
                if (method instanceof ITablePropertiesMethod) {
                    ITablePropertiesMethod tablePropertiesMethod2 = (ITablePropertiesMethod)method;
                    if (Boolean.TRUE.equals(tablePropertiesMethod2.getMethodProperties().getParallel())) continue;
                    f = false;
                    break;
                }
                f = false;
                break;
            }
            if (f) {
                parallel = true;
            }
        }
        return parallel;
    }

    protected FieldBoundNode bindAsFieldBoundNode(ISyntaxNode methodNode, String methodName, IOpenClass[] argumentTypes, IBoundNode[] children, int childrenCount, IOpenClass argumentType, int dims, IBindingContext bindingContext) throws Exception {
        FieldBoundNode fieldBoundNode = super.bindAsFieldBoundNode(methodNode, methodName, argumentTypes, children, childrenCount, argumentType, dims, bindingContext);
        if (fieldBoundNode == null && methodName.startsWith("$") && SpreadsheetResult.class.equals((Object)argumentType.getInstanceClass())) {
            throw new FieldNotFoundException("", methodName, argumentType);
        }
        return fieldBoundNode;
    }
}

