/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.binding;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openl.util.CollectionUtils;
import org.openl.util.PropertiesUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLMessageSource {
    private static final Logger LOG = LoggerFactory.getLogger(OpenLMessageSource.class);
    private static final String DEFAULT_MSG_SRC = "i18n/message";
    private final ClassLoader classLoader;
    private final Map<Locale, MessageBundle> cacheLocalProperties = new ConcurrentHashMap<Locale, MessageBundle>();
    private final Map<String, Map<String, String>> cacheProperties = new ConcurrentHashMap<String, Map<String, String>>();

    public OpenLMessageSource(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public MessageBundle getMessageBundle(Locale locale) {
        return this.cacheLocalProperties.computeIfAbsent(locale, this::loadMessageBundle);
    }

    private MessageBundle loadMessageBundle(Locale locale) {
        return this.loadMessageBundle(DEFAULT_MSG_SRC, locale);
    }

    private Map<String, String> getProperties(String basename) {
        return this.cacheProperties.computeIfAbsent(basename, this::loadProperties);
    }

    private Map<String, String> loadProperties(String basename) {
        HashMap<String, String> result = new HashMap<String, String>();
        String propFileName = basename + ".properties";
        URL url = this.classLoader.getResource(propFileName);
        if (url != null) {
            try {
                PropertiesUtils.load((URL)url, result::put);
            }
            catch (IOException ex) {
                LOG.error("Failed to process resource '{}'", (Object)url, (Object)ex);
            }
            Enumeration<URL> urls = null;
            try {
                urls = this.classLoader.getResources(propFileName);
            }
            catch (IOException ex) {
                LOG.error("Failed to collect resources for '{}'", (Object)propFileName, (Object)ex);
            }
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url1 = urls.nextElement();
                    try {
                        PropertiesUtils.load((URL)url1, result::putIfAbsent);
                    }
                    catch (IOException ex) {
                        LOG.error("Failed to process resource '{}'", (Object)url1, (Object)ex);
                    }
                }
            }
        }
        return result;
    }

    private MessageBundle loadMessageBundle(String basename, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(basename);
        HashMap<String, String> properties = new HashMap<String, String>(this.getProperties(basename));
        temp.append('_');
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            temp.append(language);
            properties.putAll(this.getProperties(temp.toString()));
        }
        temp.append('_');
        if (StringUtils.isNotEmpty((CharSequence)country)) {
            temp.append(country);
            properties.putAll(this.getProperties(temp.toString()));
        }
        if (StringUtils.isNotEmpty((CharSequence)variant) && (StringUtils.isNotEmpty((CharSequence)language) || StringUtils.isNotEmpty((CharSequence)country))) {
            temp.append('_').append(variant);
            properties.putAll(this.getProperties(temp.toString()));
        }
        return new MessageBundle(properties, locale);
    }

    public static class MessageBundle {
        private final Map<String, String> properties;
        private final Locale locale;
        private final Map<String, MessageFormat> cachedMessageFormats = new ConcurrentHashMap<String, MessageFormat>();

        public MessageBundle(Map<String, String> properties, Locale locale) {
            this.properties = properties;
            this.locale = locale;
        }

        public String msg(String code, Object ... args) {
            if (code == null) {
                return null;
            }
            String msg = this.properties.get(code);
            if (msg == null) {
                return code;
            }
            if (CollectionUtils.isEmpty((Object[])args)) {
                return msg;
            }
            return this.cachedMessageFormats.computeIfAbsent(msg, x -> new MessageFormat((String)x, this.locale)).format(args);
        }
    }
}

