/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.binding.impl.cast.IOneElementArrayCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetContext;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetSymbols;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.element.SpreadsheetCellRefType;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.calc.element.SpreadsheetExpressionMarker;
import org.openl.rules.calc.element.SpreadsheetStructureBuilderHolder;
import org.openl.rules.calc.result.ArrayResultBuilder;
import org.openl.rules.calc.result.EmptyResultBuilder;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.calc.result.ScalarResultBuilder;
import org.openl.rules.calc.result.SpreadsheetResultBuilder;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.SpreadsheetMetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.JavaKeywordUtils;
import org.openl.util.MessageUtils;
import org.openl.util.OpenClassUtils;
import org.openl.util.text.AbsolutePosition;
import org.openl.util.text.ILocation;
import org.openl.util.text.IPosition;
import org.openl.util.text.LocationUtils;
import org.openl.util.text.TextInterval;

public class SpreadsheetStructureBuilder {
    public static final String DOLLAR_SIGN = "$";
    private IBindingContext spreadsheetBindingContext;
    private final IOpenMethodHeader spreadsheetHeader;
    private final XlsModuleOpenClass xlsModuleOpenClass;
    private final SpreadsheetStructureBuilderHolder spreadsheetStructureBuilderHolder = new SpreadsheetStructureBuilderHolder(this);
    public static final ThreadLocal<Stack<Set<SpreadsheetCell>>> preventCellsLoopingOnThis = new ThreadLocal();
    private final TableSyntaxNode tableSyntaxNode;
    private final ILogicalTable tableBody;
    private final IBindingContext bindingContext;
    private final Map<Integer, IBindingContext> rowContexts = new HashMap<Integer, IBindingContext>();
    private final Map<Integer, SpreadsheetOpenClass> colComponentOpenClasses = new HashMap<Integer, SpreadsheetOpenClass>();
    private final Map<Integer, Map<Integer, SpreadsheetContext>> spreadsheetResultContexts = new HashMap<Integer, Map<Integer, SpreadsheetContext>>();
    private final SpreadsheetHeaderDefinition[] rowHeaders;
    private final SpreadsheetHeaderDefinition[] columnHeaders;
    private SpreadsheetHeaderDefinition returnHeaderDefinition;
    private SpreadsheetCell[][] cells;
    private final List<SpreadsheetCell> extractedCellValues = new ArrayList<SpreadsheetCell>();
    private volatile boolean cellsExtracted = false;

    public SpreadsheetStructureBuilderHolder getSpreadsheetStructureBuilderHolder() {
        return this.spreadsheetStructureBuilderHolder;
    }

    public SpreadsheetStructureBuilder(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext, IOpenMethodHeader spreadsheetHeader, XlsModuleOpenClass xlsModuleOpenClass) {
        this.tableSyntaxNode = tableSyntaxNode;
        this.tableBody = tableSyntaxNode.getTableBody();
        this.bindingContext = bindingContext;
        this.spreadsheetHeader = spreadsheetHeader;
        this.xlsModuleOpenClass = xlsModuleOpenClass;
        this.rowHeaders = new SpreadsheetHeaderDefinition[this.tableBody.getHeight() - 1];
        this.columnHeaders = new SpreadsheetHeaderDefinition[this.tableBody.getWidth() - 1];
        this.addHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpreadsheetCell[][] getCells() {
        if (!this.cellsExtracted) {
            SpreadsheetStructureBuilder spreadsheetStructureBuilder = this;
            synchronized (spreadsheetStructureBuilder) {
                if (!this.cellsExtracted) {
                    try {
                        this.extractCellValues();
                    }
                    finally {
                        this.cellsExtracted = true;
                    }
                }
            }
        }
        return this.cells;
    }

    public void addCellFields(SpreadsheetOpenClass spreadsheetType, boolean autoType) {
        int rowsCount = this.getHeight();
        int columnsCount = this.getWidth();
        this.cells = new SpreadsheetCell[rowsCount][columnsCount];
        this.spreadsheetBindingContext = new SpreadsheetContext(this.bindingContext, spreadsheetType, this.xlsModuleOpenClass);
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                SpreadsheetCell spreadsheetCell;
                this.cells[rowIndex][columnIndex] = spreadsheetCell = this.buildCell(rowIndex, columnIndex, autoType);
                this.addSpreadsheetFields(spreadsheetType, rowIndex, columnIndex);
            }
        }
    }

    private void extractCellValues() {
        int rowsCount = this.getHeight();
        int columnsCount = this.getWidth();
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            IBindingContext rowBindingContext = this.getRowContext(rowIndex);
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                boolean found = false;
                for (SpreadsheetCell cell : this.extractedCellValues) {
                    int row = cell.getRowIndex();
                    int column = cell.getColumnIndex();
                    if (row != rowIndex || columnIndex != column) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.extractCellValue(rowBindingContext, rowIndex, columnIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOpenClass makeType(SpreadsheetCell cell) {
        block12: {
            if (cell.getType() == null) {
                Stack<Set<SpreadsheetCell>> stack = preventCellsLoopingOnThis.get();
                boolean f = stack == null;
                try {
                    Set<Object> cellInProgressSet;
                    if (f) {
                        stack = new Stack();
                        preventCellsLoopingOnThis.set(stack);
                    }
                    if (stack.isEmpty()) {
                        cellInProgressSet = new HashSet();
                        stack.push(cellInProgressSet);
                    } else {
                        cellInProgressSet = stack.peek();
                    }
                    if (!cellInProgressSet.contains(cell)) {
                        try {
                            cellInProgressSet.add(cell);
                            int rowIndex = cell.getRowIndex();
                            int columnIndex = cell.getColumnIndex();
                            IBindingContext rowContext = this.getRowContext(rowIndex);
                            this.extractCellValue(rowContext, rowIndex, columnIndex);
                            this.extractedCellValues.add(cell);
                            break block12;
                        }
                        finally {
                            cellInProgressSet.remove(cell);
                        }
                    }
                    JavaOpenClass javaOpenClass = JavaOpenClass.OBJECT;
                    return javaOpenClass;
                }
                finally {
                    if (f) {
                        preventCellsLoopingOnThis.remove();
                    }
                }
            }
        }
        return cell.getType();
    }

    private void extractCellValue(IBindingContext rowBindingContext, int rowIndex, int columnIndex) {
        SpreadsheetCell spreadsheetCell = this.cells[rowIndex][columnIndex];
        if (this.columnHeaders[columnIndex] == null || this.rowHeaders[rowIndex] == null) {
            spreadsheetCell.setValue(null);
            return;
        }
        ICell cell = this.tableBody.getCell(columnIndex + 1, rowIndex + 1);
        CellSourceCodeModule source = new CellSourceCodeModule(cell, this.tableBody);
        String code = source.getCode();
        String name = SpreadsheetStructureBuilder.getSpreadsheetCellFieldName(this.columnHeaders[columnIndex].getDefinitionName(), this.rowHeaders[rowIndex].getDefinitionName());
        IOpenClass type = spreadsheetCell.getType();
        if (org.openl.util.StringUtils.isBlank((CharSequence)code)) {
            spreadsheetCell.setValue(type.nullObject());
        } else if (SpreadsheetExpressionMarker.isFormula(code)) {
            int end = 0;
            if (code.startsWith(SpreadsheetExpressionMarker.OPEN_CURLY_BRACKET.getSymbol())) {
                end = -1;
            }
            SubTextSourceCodeModule srcCode = new SubTextSourceCodeModule((IOpenSourceCodeModule)source, 1, end);
            IMethodSignature signature = this.spreadsheetHeader.getSignature();
            IOpenClass declaringClass = this.spreadsheetHeader.getDeclaringClass();
            OpenMethodHeader header = new OpenMethodHeader(name, type, signature, declaringClass);
            SpreadsheetContext columnBindingContext = this.getColumnContext(columnIndex, rowIndex, rowBindingContext);
            OpenL openl = columnBindingContext.getOpenL();
            try {
                CompositeMethod method;
                if (header.getType() == null) {
                    method = OpenLManager.makeMethodWithUnknownType((OpenL)openl, (IOpenSourceCodeModule)srcCode, (String)name, (IMethodSignature)signature, (IOpenClass)declaringClass, (IBindingContext)columnBindingContext);
                    spreadsheetCell.setType((IOpenClass)(method.getType() != null ? method.getType() : NullOpenClass.the));
                } else {
                    method = OpenLManager.makeMethod((OpenL)openl, (IOpenSourceCodeModule)srcCode, (IOpenMethodHeader)header, (IBindingContext)columnBindingContext);
                }
                spreadsheetCell.setValue(method);
            }
            catch (Exception | LinkageError e) {
                spreadsheetCell.setType((IOpenClass)NullOpenClass.the);
                String message = String.format("Cannot parse cell value '%s' to the necessary type.", code);
                this.spreadsheetBindingContext.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ILocation)LocationUtils.createTextInterval((String)code), (IOpenSourceCodeModule)source));
            }
        } else if (spreadsheetCell.isConstantCell()) {
            try {
                IOpenField openField = rowBindingContext.findVar("org.openl.this", code, true);
                ConstantOpenField constOpenField = (ConstantOpenField)openField;
                spreadsheetCell.setValue(constOpenField.getValue());
            }
            catch (Exception e) {
                String message = "Cannot parse cell value.";
                this.spreadsheetBindingContext.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)source));
            }
        } else {
            Class instanceClass = type.getInstanceClass();
            if (instanceClass == null) {
                String message = MessageUtils.getTypeDefinedErrorMessage((String)type.getName());
                this.spreadsheetBindingContext.addError(SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source));
            }
            try {
                SpreadsheetContext bindingContext = this.getColumnContext(columnIndex, rowIndex, rowBindingContext);
                Object result = null;
                if (String.class == instanceClass) {
                    result = String2DataConvertorFactory.parse(instanceClass, code, (IBindingContext)bindingContext);
                } else {
                    if (cell.hasNativeType()) {
                        result = RuleRowHelper.loadNativeValue(cell, type);
                    }
                    if (result == null) {
                        result = String2DataConvertorFactory.parse(instanceClass, code, (IBindingContext)bindingContext);
                    }
                }
                if (bindingContext.isExecutionMode() && result instanceof IMetaHolder) {
                    ValueMetaInfo meta = new ValueMetaInfo(name, null, (IOpenSourceCodeModule)source);
                    ((IMetaHolder)result).setMetaInfo((IMetaInfo)meta);
                }
                IOpenCast openCast = bindingContext.getCast((IOpenClass)JavaOpenClass.getOpenClass((Class)instanceClass), type);
                spreadsheetCell.setValue(openCast.convert(result));
            }
            catch (Exception t) {
                String message = String.format("Cannot parse cell value '%s' to the necessary type.", code);
                this.spreadsheetBindingContext.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)t, null, (IOpenSourceCodeModule)source));
            }
        }
    }

    private void addSpreadsheetFields(SpreadsheetOpenClass spreadsheetType, int rowIndex, int columnIndex) {
        String simplifiedFieldName;
        IOpenField field1;
        SpreadsheetHeaderDefinition columnHeader = this.columnHeaders[columnIndex];
        SpreadsheetHeaderDefinition rowHeader = this.rowHeaders[rowIndex];
        if (columnHeader == null || rowHeader == null) {
            return;
        }
        boolean oneColumnSpreadsheet = Arrays.stream(this.columnHeaders).filter(Objects::nonNull).limit(2L).count() == 1L;
        boolean oneRowSpreadsheet = Arrays.stream(this.rowHeaders).filter(Objects::nonNull).limit(2L).count() == 1L;
        SymbolicTypeDefinition columnDefinition = columnHeader.getDefinition();
        SymbolicTypeDefinition rowDefinition = rowHeader.getDefinition();
        String columnName = columnDefinition.getName().getIdentifier();
        String rowName = rowDefinition.getName().getIdentifier();
        String fieldName = SpreadsheetStructureBuilder.getSpreadsheetCellFieldName(columnName, rowName);
        SpreadsheetCell spreadsheetCell = this.cells[rowIndex][columnIndex];
        this.createSpreadsheetCellField(spreadsheetType, spreadsheetCell, fieldName, SpreadsheetCellRefType.ROW_AND_COLUMN);
        if (oneColumnSpreadsheet) {
            String simplifiedFieldName2 = this.getSpreadsheetCellSimplifiedFieldName(rowName);
            IOpenField field12 = spreadsheetType.getField(simplifiedFieldName2);
            if (field12 == null) {
                this.createSpreadsheetCellField(spreadsheetType, spreadsheetCell, simplifiedFieldName2, SpreadsheetCellRefType.SINGLE_COLUMN);
            }
        } else if (oneRowSpreadsheet && ((field1 = spreadsheetType.getField(simplifiedFieldName = this.getSpreadsheetCellSimplifiedFieldName(columnName))) == null || field1 instanceof SpreadsheetCellField && ((SpreadsheetCellField)field1).isLastColumnRef())) {
            this.createSpreadsheetCellField(spreadsheetType, spreadsheetCell, simplifiedFieldName, SpreadsheetCellRefType.SINGLE_ROW);
        }
    }

    private String getSpreadsheetCellSimplifiedFieldName(String rowName) {
        return (DOLLAR_SIGN + rowName).intern();
    }

    public static String getSpreadsheetCellFieldName(String columnName, String rowName) {
        return (DOLLAR_SIGN + columnName + DOLLAR_SIGN + rowName).intern();
    }

    private SpreadsheetCell buildCell(int rowIndex, int columnIndex, boolean autoType) {
        IOpenClass cellType;
        SpreadsheetCellType spreadsheetCellType;
        ICell sourceCell = this.tableBody.getCell(columnIndex + 1, rowIndex + 1);
        String cellCode = sourceCell.getStringValue();
        ConstantOpenField openField = null;
        SpreadsheetHeaderDefinition columnHeader = this.columnHeaders[columnIndex];
        SpreadsheetHeaderDefinition rowHeader = this.rowHeaders[rowIndex];
        if (cellCode == null || cellCode.isEmpty() || columnHeader == null || rowHeader == null) {
            spreadsheetCellType = SpreadsheetCellType.EMPTY;
        } else if (SpreadsheetExpressionMarker.isFormula(cellCode)) {
            spreadsheetCellType = SpreadsheetCellType.METHOD;
        } else {
            spreadsheetCellType = SpreadsheetCellType.VALUE;
            openField = RuleRowHelper.findConstantField(this.spreadsheetBindingContext, cellCode);
            if (openField != null) {
                spreadsheetCellType = SpreadsheetCellType.CONSTANT;
            }
        }
        ICell sourceCellForExecutionMode = this.spreadsheetBindingContext.isExecutionMode() ? null : sourceCell;
        SpreadsheetCell spreadsheetCell = new SpreadsheetCell(rowIndex, columnIndex, sourceCellForExecutionMode, spreadsheetCellType);
        if (openField != null) {
            cellType = openField.getType();
        } else if (columnHeader != null && columnHeader.getType() != null) {
            cellType = columnHeader.getType();
        } else if (rowHeader != null && rowHeader.getType() != null) {
            cellType = rowHeader.getType();
        } else {
            try {
                if (autoType) {
                    if (SpreadsheetExpressionMarker.isFormula(cellCode)) {
                        cellType = null;
                    } else if (cellCode != null) {
                        Object objectValue = sourceCell.getObjectValue();
                        if (objectValue instanceof String) {
                            String2DataConvertorFactory.getConvertor(Double.class).parse(cellCode, null);
                            cellType = JavaOpenClass.getOpenClass(Double.class);
                        } else {
                            cellType = JavaOpenClass.getOpenClass(objectValue.getClass());
                        }
                    } else {
                        cellType = NullOpenClass.the;
                    }
                } else {
                    if (!SpreadsheetExpressionMarker.isFormula(cellCode)) {
                        String2DataConvertorFactory.getConvertor(Double.class).parse(cellCode, null);
                    }
                    cellType = JavaOpenClass.getOpenClass(Double.class);
                }
            }
            catch (Exception t) {
                cellType = JavaOpenClass.getOpenClass(String.class);
            }
        }
        spreadsheetCell.setType(cellType);
        return spreadsheetCell;
    }

    private IBindingContext getRowContext(int rowIndex) {
        IBindingContext rowContext = this.rowContexts.get(rowIndex);
        if (rowContext == null) {
            rowContext = this.makeRowContext(rowIndex);
            this.rowContexts.put(rowIndex, rowContext);
        }
        return rowContext;
    }

    private SpreadsheetContext getColumnContext(int columnIndex, int rowIndex, IBindingContext rowBindingContext) {
        Map contexts = this.spreadsheetResultContexts.computeIfAbsent(columnIndex, e -> new HashMap());
        return contexts.computeIfAbsent(rowIndex, e -> this.makeSpreadsheetResultContext(columnIndex, rowBindingContext));
    }

    private SpreadsheetContext makeSpreadsheetResultContext(int columnIndex, IBindingContext rowBindingContext) {
        SpreadsheetOpenClass columnOpenClass = this.colComponentOpenClasses.computeIfAbsent(columnIndex, e -> this.makeColumnComponentOpenClass(columnIndex));
        return new SpreadsheetContext(rowBindingContext, columnOpenClass, this.xlsModuleOpenClass);
    }

    private SpreadsheetOpenClass makeColumnComponentOpenClass(int columnIndex) {
        String columnOpenClassName = String.format("%sColType%d", this.spreadsheetHeader.getName(), columnIndex);
        SpreadsheetOpenClass columnOpenClass = new SpreadsheetOpenClass(columnOpenClassName, this.bindingContext.getOpenL());
        for (int rowIndex = 0; rowIndex < this.cells.length; ++rowIndex) {
            SpreadsheetHeaderDefinition headerDefinition = this.rowHeaders[rowIndex];
            this.proc(rowIndex, columnOpenClass, columnIndex, headerDefinition);
        }
        return columnOpenClass;
    }

    private IBindingContext makeRowContext(int rowIndex) {
        String rowOpenClassName = String.format("%sRowType%d", this.spreadsheetHeader.getName(), rowIndex);
        SpreadsheetOpenClass rowOpenClass = new SpreadsheetOpenClass(rowOpenClassName, this.bindingContext.getOpenL());
        int width = this.cells[0].length;
        for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
            SpreadsheetHeaderDefinition columnHeader = this.columnHeaders[columnIndex];
            this.proc(rowIndex, rowOpenClass, columnIndex, columnHeader);
        }
        return new SpreadsheetContext(this.spreadsheetBindingContext, rowOpenClass, this.xlsModuleOpenClass);
    }

    private void proc(int rowIndex, ComponentOpenClass rowOpenClass, int columnIndex, SpreadsheetHeaderDefinition columnHeader) {
        if (columnHeader == null) {
            return;
        }
        SpreadsheetCell cell = this.cells[rowIndex][columnIndex];
        SymbolicTypeDefinition typeDefinition = columnHeader.getDefinition();
        String fieldName = (DOLLAR_SIGN + typeDefinition.getName().getIdentifier()).intern();
        this.createSpreadsheetCellField(rowOpenClass, cell, fieldName, SpreadsheetCellRefType.LOCAL);
    }

    private void createSpreadsheetCellField(ComponentOpenClass rowOpenClass, SpreadsheetCell cell, String fieldName, SpreadsheetCellRefType spreadsheetCellRefType) {
        SpreadsheetStructureBuilderHolder structureBuilderContainer = this.getSpreadsheetStructureBuilderHolder();
        SpreadsheetCellField field = cell.getSpreadsheetCellType() == SpreadsheetCellType.METHOD ? new SpreadsheetCellField(structureBuilderContainer, (IOpenClass)rowOpenClass, fieldName, cell, spreadsheetCellRefType) : new SpreadsheetCellField.ConstSpreadsheetCellField(structureBuilderContainer, (IOpenClass)rowOpenClass, fieldName, cell);
        rowOpenClass.addField((IOpenField)field);
    }

    private static String removeWrongSymbols(String s) {
        if (s == null) {
            return null;
        }
        if (((String)(s = ((String)s).trim())).length() > 0) {
            s = ((String)s).replaceAll("\\s+", "_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ((String)s).length(); ++i) {
                if (!Character.isJavaIdentifierPart(((String)s).charAt(i))) continue;
                sb.append(((String)s).charAt(i));
            }
            s = sb.toString();
            if (JavaKeywordUtils.isJavaKeyword((String)s) || ((String)s).length() > 0 && !Character.isJavaIdentifierStart(((String)s).charAt(0))) {
                s = "_" + (String)s;
            }
        }
        return s;
    }

    public String[] getRowNamesForResultModel() {
        return this.getNamesForResultModel(this.rowHeaders);
    }

    public String[] getColumnNamesForResultModel() {
        return this.getNamesForResultModel(this.columnHeaders);
    }

    private String[] getNamesForResultModel(SpreadsheetHeaderDefinition[] headers) {
        long rowsWithAsteriskCount = Arrays.stream(headers).filter(Objects::nonNull).filter(e -> e.getDefinition().isAsteriskPresented()).count();
        String[] ret = rowsWithAsteriskCount > 0L ? this.buildArrayForHeaders(headers, e -> e.getDefinition().isAsteriskPresented()) : this.buildArrayForHeaders(headers, e -> !e.getDefinition().isTildePresented());
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = SpreadsheetStructureBuilder.removeWrongSymbols(ret[i]);
        }
        return ret;
    }

    public String[] getRowNames() {
        return this.buildArrayForHeaders(this.rowHeaders, e -> true);
    }

    public String[] getColumnNames() {
        return this.buildArrayForHeaders(this.columnHeaders, e -> true);
    }

    private String[] buildArrayForHeaders(SpreadsheetHeaderDefinition[] headers, Predicate<SpreadsheetHeaderDefinition> predicate) {
        int size = headers.length;
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            if (headers[i] == null || !predicate.test(headers[i])) continue;
            ret[i] = headers[i].getDefinitionName();
        }
        return ret;
    }

    private void addHeaders() {
        String value;
        ICell cell;
        int height = this.getHeight();
        int width = this.getWidth();
        HashSet<String> registered = new HashSet<String>(height + width, 1.0f);
        for (int row = 0; row < height; ++row) {
            cell = this.tableBody.getCell(0, row + 1);
            value = cell.getStringValue();
            if (value == null) continue;
            this.parseHeader(cell, row, true, registered);
        }
        for (int col = 0; col < width; ++col) {
            cell = this.tableBody.getCell(col + 1, 0);
            value = cell.getStringValue();
            if (value == null) continue;
            this.parseHeader(cell, col, false, registered);
        }
        IOpenClass spreadsheetHeaderType = this.spreadsheetHeader.getType();
        if (this.bindingContext.findType("org.openl.this", SpreadsheetResult.class.getSimpleName()).equals(spreadsheetHeaderType) && this.returnHeaderDefinition == null) {
            return;
        }
        if (this.returnHeaderDefinition == null) {
            this.returnHeaderDefinition = this.rowHeaders[height - 1];
        }
        if (Boolean.FALSE.equals(this.tableSyntaxNode.getTableProperties().getAutoType()) && this.returnHeaderDefinition.getType() == null) {
            this.returnHeaderDefinition.setType(spreadsheetHeaderType);
        } else if ((spreadsheetHeaderType.getAggregateInfo() == null || spreadsheetHeaderType.getAggregateInfo() != null && spreadsheetHeaderType.getAggregateInfo().getComponentType(spreadsheetHeaderType) == null) && this.hasOnlyOneEmptyCell(this.returnHeaderDefinition)) {
            this.returnHeaderDefinition.setType(spreadsheetHeaderType);
        }
    }

    private void parseHeader(ICell cell, int index, boolean row, Set<String> registered) {
        IdentifierNode[] nodes;
        CellSourceCodeModule source = new CellSourceCodeModule(cell, this.tableBody);
        try {
            nodes = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)SpreadsheetSymbols.TYPE_DELIMITER.toString());
        }
        catch (OpenLCompilationException e) {
            this.bindingContext.addError(SyntaxNodeExceptionUtils.createError((String)"Cannot parse header.", (IOpenSourceCodeModule)source));
            return;
        }
        if (nodes.length == 0) {
            this.bindingContext.addError(SyntaxNodeExceptionUtils.createError((String)"Cannot parse header.", (IOpenSourceCodeModule)source));
            return;
        }
        if (nodes.length > 2) {
            this.bindingContext.addError(SyntaxNodeExceptionUtils.createError((String)"Valid header format: name [: type].", (ISyntaxNode)nodes[2]));
            return;
        }
        IdentifierNode headerNameNode = nodes[0];
        IdentifierNode typeIdentifierNode = nodes.length == 1 ? null : nodes[1];
        String headerName = headerNameNode.getIdentifier();
        boolean endsWithAsterisk = headerName.endsWith(SpreadsheetSymbols.ASTERISK.toString());
        boolean endsWithTilde = headerName.endsWith(SpreadsheetSymbols.TILDE.toString());
        if (endsWithAsterisk || endsWithTilde) {
            headerName = org.openl.util.StringUtils.trim((String)headerName.substring(0, headerName.length() - 1));
            AbsolutePosition end = new AbsolutePosition(headerName.length());
            TextInterval location = new TextInterval(headerNameNode.getLocation().getStart(), (IPosition)end);
            headerNameNode = new IdentifierNode(headerNameNode.getType(), (ILocation)location, headerName, headerNameNode.getModule());
        }
        SymbolicTypeDefinition parsed = new SymbolicTypeDefinition(headerNameNode, typeIdentifierNode, endsWithAsterisk, endsWithTilde, (IOpenSourceCodeModule)source);
        if (!registered.add(headerName)) {
            this.bindingContext.addError(SyntaxNodeExceptionUtils.createError((String)String.format("The header '%s' is already defined.", headerName), (ISyntaxNode)headerNameNode));
            return;
        }
        SpreadsheetHeaderDefinition header = row ? (this.rowHeaders[index] = new SpreadsheetHeaderDefinition(parsed, index, -1)) : (this.columnHeaders[index] = new SpreadsheetHeaderDefinition(parsed, -1, index));
        if (typeIdentifierNode != null) {
            String typeIdentifier = typeIdentifierNode.getOriginalText();
            IOpenClass headerType = OpenLManager.makeType((OpenL)this.bindingContext.getOpenL(), (String)typeIdentifier, (IOpenSourceCodeModule)source, (IBindingContext)this.bindingContext);
            header.setType(headerType);
        }
        this.addMetaInfo(header, cell);
        if ("RETURN".equals(headerName)) {
            this.returnHeaderDefinition = header;
        }
    }

    private void addMetaInfo(SpreadsheetHeaderDefinition headerDefinition, ICell cell) {
        if (!this.bindingContext.isExecutionMode() && this.tableSyntaxNode.getMetaInfoReader() instanceof SpreadsheetMetaInfoReader) {
            IdentifierNode identifier;
            SimpleNodeUsage nodeUsage;
            IOpenClass headerType = headerDefinition.getType();
            SymbolicTypeDefinition symbolicTypeDefinition = headerDefinition.getDefinition();
            IdentifierNode typeIdentifierNode = symbolicTypeDefinition.getType();
            SpreadsheetMetaInfoReader metaInfoReader = (SpreadsheetMetaInfoReader)this.tableSyntaxNode.getMetaInfoReader();
            ArrayList<SimpleNodeUsage> nodeUsages = new ArrayList<SimpleNodeUsage>();
            if (headerDefinition.getDefinition().isAsteriskPresented()) {
                String s = SpreadsheetStructureBuilder.removeWrongSymbols(headerDefinition.getDefinitionName());
                if (StringUtils.isEmpty((CharSequence)s)) {
                    s = "Empty string";
                }
                String stringValue = cell.getStringValue();
                int d = stringValue.lastIndexOf(SpreadsheetSymbols.ASTERISK.toString());
                nodeUsage = new SimpleNodeUsage(0, d, s, null, NodeType.OTHER);
                nodeUsages.add(nodeUsage);
            }
            if (headerType != null && (identifier = this.cutTypeIdentifier(typeIdentifierNode)) != null) {
                IOpenClass type = headerType;
                while (type.getMetaInfo() == null && type.isArray()) {
                    type = type.getComponentClass();
                }
                IMetaInfo typeMeta = type.getMetaInfo();
                if (typeMeta != null) {
                    nodeUsage = new SimpleNodeUsage(identifier, typeMeta.getDisplayName(0), typeMeta.getSourceUrl(), NodeType.DATATYPE);
                    nodeUsages.add(nodeUsage);
                }
            }
            if (!nodeUsages.isEmpty()) {
                CellMetaInfo cellMetaInfo = new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages);
                metaInfoReader.addHeaderMetaInfo(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), cellMetaInfo);
            }
        }
    }

    private IdentifierNode cutTypeIdentifier(IdentifierNode typeIdentifierNode) {
        try {
            IdentifierNode[] nodes;
            IdentifierNode[] variableAndType = Tokenizer.tokenize((IOpenSourceCodeModule)typeIdentifierNode.getModule(), (String)SpreadsheetSymbols.TYPE_DELIMITER.toString());
            if (variableAndType.length > 1 && (nodes = Tokenizer.tokenize((IOpenSourceCodeModule)typeIdentifierNode.getModule(), (String)" []\n\r", (ILocation)variableAndType[1].getLocation())).length > 0) {
                return nodes[0];
            }
        }
        catch (OpenLCompilationException e) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Cannot parse header.", (ISyntaxNode)typeIdentifierNode);
            this.bindingContext.addError(error);
        }
        return null;
    }

    private boolean hasOnlyOneEmptyCell(SpreadsheetHeaderDefinition headerDefinition) {
        int fromRow = 0;
        int toRow = this.getHeight();
        int fromColumn = 0;
        int toColumn = this.getWidth();
        if (headerDefinition.isRow()) {
            fromRow = headerDefinition.getRow();
            toRow = fromRow + 1;
        } else {
            fromColumn = headerDefinition.getColumn();
            toColumn = fromColumn + 1;
        }
        int nonEmptyCellsCount = 0;
        for (int columnIndex = fromColumn; columnIndex < toColumn; ++columnIndex) {
            for (int rowIndex = fromRow; rowIndex < toRow; ++rowIndex) {
                String value = this.tableBody.getCell(columnIndex + 1, rowIndex + 1).getStringValue();
                boolean isFormula = SpreadsheetExpressionMarker.isFormula(value);
                if (!org.openl.util.StringUtils.isNotBlank((CharSequence)value) || isFormula || ++nonEmptyCellsCount <= 1) continue;
                return false;
            }
        }
        return nonEmptyCellsCount == 1;
    }

    public boolean isExistsReturnHeader() {
        return this.returnHeaderDefinition != null;
    }

    public IResultBuilder buildResultBuilder(Spreadsheet spreadsheet, IBindingContext bindingContext) throws SyntaxNodeException {
        IResultBuilder resultBuilder;
        if (OpenClassUtils.isVoid((IOpenClass)spreadsheet.getHeader().getType())) {
            return new EmptyResultBuilder();
        }
        if (!this.isExistsReturnHeader() && bindingContext.findType("org.openl.this", SpreadsheetResult.class.getSimpleName()).equals(spreadsheet.getHeader().getType())) {
            resultBuilder = new SpreadsheetResultBuilder();
        } else {
            Object spreadsheetCell;
            ArrayList<SpreadsheetCell> returnSpreadsheetCells = new ArrayList<SpreadsheetCell>();
            ArrayList<IOpenCast> casts = new ArrayList<IOpenCast>();
            ArrayList<SpreadsheetCell> returnSpreadsheetCellsAsArray = new ArrayList<SpreadsheetCell>();
            ArrayList<IOpenCast> castsAsArray = new ArrayList<IOpenCast>();
            IOpenClass type = spreadsheet.getType();
            IAggregateInfo aggregateInfo = type.getAggregateInfo();
            IOpenClass componentType = aggregateInfo.getComponentType(type);
            boolean asArray = false;
            ArrayList<SpreadsheetCell> sprCells = new ArrayList<SpreadsheetCell>();
            int n = this.returnHeaderDefinition.getRow();
            if (n < 0) {
                n = this.returnHeaderDefinition.getColumn();
                for (int i = 0; i < spreadsheet.getCells().length; ++i) {
                    sprCells.add(spreadsheet.getCells()[i][n]);
                }
            } else {
                sprCells.addAll(Arrays.asList(spreadsheet.getCells()[n]));
            }
            ArrayList<SpreadsheetCell> nonEmptySpreadsheetCells = new ArrayList<SpreadsheetCell>();
            for (SpreadsheetCell cell : sprCells) {
                if (cell.isEmpty()) continue;
                nonEmptySpreadsheetCells.add(cell);
                if (cell.getType() == null) continue;
                IOpenCast cast = bindingContext.getCast(cell.getType(), type);
                if (cast != null && cast.isImplicit() && !(cast instanceof IOneElementArrayCast)) {
                    returnSpreadsheetCells.add(cell);
                    casts.add(cast);
                }
                if (!returnSpreadsheetCells.isEmpty() || componentType == null || (cast = bindingContext.getCast(cell.getType(), componentType)) == null || !cast.isImplicit() || cast instanceof IOneElementArrayCast) continue;
                returnSpreadsheetCellsAsArray.add(cell);
                castsAsArray.add(cast);
            }
            if (componentType != null && returnSpreadsheetCells.isEmpty()) {
                returnSpreadsheetCells = returnSpreadsheetCellsAsArray;
                this.returnHeaderDefinition.setType(componentType);
                casts = castsAsArray;
                asArray = true;
            } else {
                this.returnHeaderDefinition.setType(type);
            }
            if (!returnSpreadsheetCells.isEmpty()) {
                if (asArray) {
                    for (SpreadsheetCell cell : returnSpreadsheetCells) {
                        cell.setReturnCell(true);
                    }
                } else {
                    spreadsheetCell = (SpreadsheetCell)returnSpreadsheetCells.get(returnSpreadsheetCells.size() - 1);
                    ((SpreadsheetCell)spreadsheetCell).setReturnCell(true);
                }
            } else if (!nonEmptySpreadsheetCells.isEmpty()) {
                if (asArray) {
                    for (SpreadsheetCell cell : nonEmptySpreadsheetCells) {
                        cell.setReturnCell(true);
                    }
                } else {
                    spreadsheetCell = (SpreadsheetCell)nonEmptySpreadsheetCells.get(nonEmptySpreadsheetCells.size() - 1);
                    ((SpreadsheetCell)spreadsheetCell).setReturnCell(true);
                }
            }
            if (returnSpreadsheetCells.isEmpty()) {
                IdentifierNode symbolicTypeDefinitionName = Optional.ofNullable(this.returnHeaderDefinition).map(SpreadsheetHeaderDefinition::getDefinition).map(SymbolicTypeDefinition::getName).orElse(null);
                if (!nonEmptySpreadsheetCells.isEmpty()) {
                    SpreadsheetCell nonEmptySpreadsheetCell = (SpreadsheetCell)nonEmptySpreadsheetCells.get(nonEmptySpreadsheetCells.size() - 1);
                    if (nonEmptySpreadsheetCell.getType() != null) {
                        throw SyntaxNodeExceptionUtils.createError((String)String.format("Cannot convert from '%s' to '%s'.", nonEmptySpreadsheetCell.getType().getName(), spreadsheet.getHeader().getType().getName()), (ISyntaxNode)Optional.ofNullable(nonEmptySpreadsheetCell.getMethod()).filter(CompositeMethod.class::isInstance).map(CompositeMethod.class::cast).map(CompositeMethod::getMethodBodyBoundNode).map(IBoundNode::getSyntaxNode).orElse((ISyntaxNode)symbolicTypeDefinitionName));
                    }
                    return null;
                }
                throw SyntaxNodeExceptionUtils.createError((String)"There is no return expression cell.", (ISyntaxNode)symbolicTypeDefinitionName);
            }
            resultBuilder = asArray ? new ArrayResultBuilder(returnSpreadsheetCells.toArray(new SpreadsheetCell[0]), castsAsArray.toArray(new IOpenCast[0]), type, this.isCalculateAllCellsInSpreadsheet(spreadsheet)) : new ScalarResultBuilder((SpreadsheetCell)returnSpreadsheetCells.get(returnSpreadsheetCells.size() - 1), (IOpenCast)casts.get(casts.size() - 1), this.isCalculateAllCellsInSpreadsheet(spreadsheet));
        }
        return resultBuilder;
    }

    private boolean isCalculateAllCellsInSpreadsheet(Spreadsheet spreadsheet) {
        return !Boolean.FALSE.equals(spreadsheet.getMethodProperties().getCalculateAllCells());
    }

    private int getWidth() {
        return this.columnHeaders.length;
    }

    private int getHeight() {
        return this.rowHeaders.length;
    }

    private static class CellSourceCodeModule
    extends StringSourceCodeModule {
        public CellSourceCodeModule(ICell cell, ILogicalTable table) {
            super(cell.getStringValue(), table.getSource().getUri(cell.getColumn(), cell.getRow() - 1));
        }
    }
}

