/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.binding.IBoundNode;
import org.openl.util.text.AbsolutePosition;
import org.openl.util.text.ILocation;
import org.openl.util.text.IPosition;
import org.openl.util.text.TextInfo;
import org.openl.util.text.TextInterval;

public class AST {
    private final IBoundNode boundNode;
    private final Map<IBoundNode, ILocation> extensiveLocationMap;
    private final Map<IBoundNode, ILocation> locationMap;
    private final TextInfo textInfo;

    public AST(IBoundNode boundNode) {
        this.boundNode = boundNode;
        TextInfo textInfo = this.textInfo = boundNode != null ? new TextInfo(boundNode.getSyntaxNode().getModule().getCode()) : null;
        if (boundNode != null) {
            this.extensiveLocationMap = new IdentityHashMap<IBoundNode, ILocation>();
            this.locationMap = new IdentityHashMap<IBoundNode, ILocation>();
            this.buildLocationMaps(boundNode, this.extensiveLocationMap, this.locationMap);
        } else {
            this.extensiveLocationMap = null;
            this.locationMap = null;
        }
    }

    private Pair<IPosition, IPosition> f(IBoundNode boundNode, Map<IBoundNode, ILocation> map, Map<IBoundNode, ILocation> locationMap, IPosition start, IPosition end) {
        Pair<IPosition, IPosition> p = this.buildLocationMaps(boundNode, map, locationMap);
        if (start == null || p.getLeft() != null && start.getAbsolutePosition(this.textInfo) > ((IPosition)p.getLeft()).getAbsolutePosition(this.textInfo)) {
            start = (IPosition)p.getLeft();
        }
        if (end == null || p.getRight() != null && end.getAbsolutePosition(this.textInfo) < ((IPosition)p.getRight()).getAbsolutePosition(this.textInfo)) {
            end = (IPosition)p.getRight();
        }
        return Pair.of((Object)start, (Object)end);
    }

    private TextInterval fixTextInterval(IPosition start, IPosition end) {
        int s = start.getAbsolutePosition(this.textInfo);
        int e = end.getAbsolutePosition(this.textInfo);
        String text = this.textInfo.getText().substring(s, e + 1);
        int m = 0;
        int k = 0;
        for (char c : text.toCharArray()) {
            if (c == '(') {
                ++m;
                continue;
            }
            if (c != ')') continue;
            if (m > 0) {
                --m;
                continue;
            }
            ++k;
        }
        while (k > 0 && s - 1 >= 0) {
            if (this.textInfo.getText().charAt(s - 1) == '(') {
                --k;
            }
            --s;
        }
        m = 0;
        k = 0;
        for (int i = text.length() - 1; i > 0; --i) {
            if (text.charAt(i) == ')') {
                ++m;
                continue;
            }
            if (text.charAt(i) != '(') continue;
            if (m > 0) {
                --m;
                continue;
            }
            ++k;
        }
        while (k > 0 && e + 1 < this.textInfo.getText().length()) {
            if (this.textInfo.getText().charAt(e + 1) == ')') {
                --k;
            }
            ++e;
        }
        return new TextInterval((IPosition)new AbsolutePosition(s), (IPosition)new AbsolutePosition(e));
    }

    private Pair<IPosition, IPosition> buildLocationMaps(IBoundNode boundNode, Map<IBoundNode, ILocation> extensiveLocationMap, Map<IBoundNode, ILocation> locationMap) {
        ILocation location = boundNode.getSyntaxNode().getSourceLocation();
        IPosition start = location != null ? location.getStart() : null;
        IPosition end = location != null ? location.getEnd() : null;
        IBoundNode x = boundNode;
        while (x.getTargetNode() != null) {
            x = x.getTargetNode();
            Pair<IPosition, IPosition> p1 = this.f(x, extensiveLocationMap, locationMap, start, end);
            start = (IPosition)p1.getLeft();
            end = (IPosition)p1.getRight();
        }
        for (IBoundNode childNode : boundNode.getChildren()) {
            Pair<IPosition, IPosition> p = this.f(childNode, extensiveLocationMap, locationMap, start, end);
            start = (IPosition)p.getLeft();
            end = (IPosition)p.getRight();
        }
        if (start != null && end != null) {
            extensiveLocationMap.put(boundNode, (ILocation)this.fixTextInterval(start, end));
        }
        if (boundNode.getSyntaxNode().getSourceLocation() != null) {
            locationMap.put(boundNode, boundNode.getSyntaxNode().getSourceLocation());
        }
        return Pair.of((Object)start, (Object)end);
    }

    public IBoundNode getBoundNode() {
        return this.boundNode;
    }

    public ILocation getLocation(IBoundNode boundNode) {
        return this.locationMap.get(boundNode);
    }

    public String getCode() {
        return this.getCode(this.boundNode);
    }

    public String getCode(IBoundNode boundNode) {
        if (this.boundNode != null) {
            ILocation location = this.extensiveLocationMap.get(boundNode);
            int begin = location.getStart().getAbsolutePosition(this.textInfo);
            int end = location.getEnd().getAbsolutePosition(this.textInfo);
            return this.textInfo.getText().substring(begin, end + 1);
        }
        return null;
    }
}

