/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.algorithm.evaluator.AConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArraySelector;
import org.openl.rules.dt.algorithm.evaluator.FloatTypeComparator;
import org.openl.rules.dt.element.ConditionCasts;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.helpers.NumberUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.types.IParameterDeclaration;
import org.openl.vm.IRuntimeEnv;

public abstract class AContainsInArrayIndexedEvaluator
extends AConditionEvaluator {
    private int uniqueKeysSize = -1;
    private int maxArrayLength = -1;

    public AContainsInArrayIndexedEvaluator(ConditionCasts conditionCasts) {
        super(conditionCasts);
    }

    @Override
    public IOpenSourceCodeModule getFormalSourceCode(IBaseCondition condition) {
        IParameterDeclaration[] cparams = condition.getParams();
        IOpenSourceCodeModule conditionSource = condition.getSourceCodeModule();
        String code = String.format("containsCtr(%1$s, %2$s)", cparams[0].getName(), conditionSource.getCode());
        return new StringSourceCodeModule(code, conditionSource.getUri());
    }

    @Override
    public IIntSelector getSelector(ICondition condition, Object target, Object[] params, IRuntimeEnv env) {
        Object value = this.conditionCasts.castToConditionType(condition.getEvaluator().invoke(target, params, env));
        return new ContainsInArraySelector(condition, value);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int countUniqueKeys(ICondition condition, IIntIterator it) {
        if (this.uniqueKeysSize < 0) {
            this.countUniqueKeysAndMaxArrayLength(condition, it);
        }
        return this.uniqueKeysSize;
    }

    public int getMaxArrayLength(ICondition condition, IIntIterator it) {
        if (this.maxArrayLength < 0) {
            this.countUniqueKeysAndMaxArrayLength(condition, it);
        }
        return this.maxArrayLength;
    }

    private void countUniqueKeysAndMaxArrayLength(ICondition condition, IIntIterator it) {
        AbstractSet uniqueVals = null;
        while (it.hasNext()) {
            int i = it.nextInt();
            if (condition.isEmpty(i)) continue;
            Object values = condition.getParamValue(0, i);
            int length = Array.getLength(values);
            this.maxArrayLength = Math.max(length, this.maxArrayLength);
            for (int j = 0; j < length; ++j) {
                Object val = Array.get(values, j);
                val = this.conditionCasts.castToInputType(val);
                if (uniqueVals == null) {
                    uniqueVals = NumberUtils.isObjectFloatPointNumber(val) ? (val instanceof BigDecimal ? new HashSet() : new TreeSet<Object>(FloatTypeComparator.getInstance())) : new HashSet<Object>();
                }
                uniqueVals.add(val);
            }
        }
        this.uniqueKeysSize = uniqueVals == null ? 0 : uniqueVals.size();
    }

    protected IDomain<Object> indexedDomain(IBaseCondition condition) {
        int len = condition.getNumberOfRules();
        ArrayList<Object> list = new ArrayList<Object>(len);
        HashSet<Object> set = new HashSet<Object>(len);
        for (int ruleN = 0; ruleN < len; ++ruleN) {
            if (condition.isEmpty(ruleN)) continue;
            Object ary = condition.getParamValue(0, ruleN);
            int plen = Array.getLength(ary);
            for (int j = 0; j < plen; ++j) {
                Object key = Array.get(ary, j);
                if (key == null || !set.add(key)) continue;
                list.add(key);
            }
        }
        return new EnumDomain(list.toArray());
    }
}

