/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type.domains;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.domain.EnumDomain;
import org.openl.rules.dt.type.domains.EnumDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainCollector;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;

public class EnumDomainCollector
implements IDomainCollector {
    private final String propertyToSearch;
    private final Set<Object> enumProp = new HashSet<Object>();

    public EnumDomainCollector(String propertyToSearch) {
        this.propertyToSearch = propertyToSearch;
    }

    @Override
    public void gatherDomains(Map<String, Object> methodProperties) {
        Object propvalue;
        if (methodProperties != null && (propvalue = methodProperties.get(this.propertyToSearch)) != null) {
            this.enumProp.add(propvalue);
        }
    }

    @Override
    public IDomainAdaptor getGatheredDomain() {
        EnumDomainAdaptor result = null;
        if (!this.enumProp.isEmpty()) {
            Class<?> propertyType = TablePropertyDefinitionUtils.getPropertyTypeByPropertyName(this.propertyToSearch);
            Object[] resultArray = (Object[])Array.newInstance(propertyType, this.enumProp.size());
            EnumDomain enumDomain = new EnumDomain(this.enumProp.toArray(resultArray));
            result = new EnumDomainAdaptor(enumDomain);
        }
        return result;
    }
}

