/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.result;

import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.testmethod.result.TestResultComparator;

class NumberComparator
implements TestResultComparator {
    private static final NumberComparator INSTANCE = new NumberComparator();
    private Double delta;

    private NumberComparator() {
    }

    NumberComparator(Double delta) {
        this.delta = delta;
    }

    @Override
    public boolean isEqual(Object expectedResult, Object actualResult) {
        if (actualResult == null || expectedResult == null) {
            return actualResult == expectedResult;
        }
        Double actual = NumberUtils.convertToDouble(actualResult);
        Double expected = NumberUtils.convertToDouble(expectedResult);
        if (actual != null && expected != null) {
            double epsilon;
            if (Double.compare(actual, expected) == 0) {
                return true;
            }
            if (Double.isInfinite(actual) || Double.isInfinite(expected) || Double.isNaN(actual) || Double.isNaN(expected)) {
                return false;
            }
            double diff = Math.abs(actual - expected);
            double d = epsilon = this.delta == null ? Math.ulp(actual) : this.delta;
            return epsilon < 1.0 ? diff <= epsilon : diff < epsilon;
        }
        return false;
    }

    public static TestResultComparator getInstance() {
        return INSTANCE;
    }
}

