/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.TypeBoundNode;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableUtils;
import org.openl.rules.dt.IBaseAction;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IBaseDecisionRow;
import org.openl.rules.dt.algorithm.DecisionTableOptimizedAlgorithm;
import org.openl.rules.dt.algorithm.DependentParametersOptimizedAlgorithm;
import org.openl.rules.dt.algorithm.IAlgorithmBuilder;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm.TwoDimensionalAlgorithm;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.data.ConditionOrActionDirectParameterField;
import org.openl.rules.dt.data.ConditionOrActionParameterField;
import org.openl.rules.dt.data.DecisionExprFieldDataType;
import org.openl.rules.dt.data.DecisionTableDataType;
import org.openl.rules.dt.element.Condition;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.lang.xls.binding.ExpressionIdentifier;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ParameterMethodCaller;
import org.openl.types.impl.SourceCodeMethodCaller;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.StringUtils;

public class DecisionTableAlgorithmBuilder
implements IAlgorithmBuilder {
    private static final Pattern ARRAY_ACCESS_PATTERN = Pattern.compile(".+\\[.+]$");
    private IndexInfo baseInfo;
    private final DecisionTable table;
    private IConditionEvaluator[] evaluators;
    private final IOpenMethodHeader header;
    private final OpenL openl;
    private final IMethodSignature signature;
    private final RuleRow ruleRow;

    public DecisionTableAlgorithmBuilder(DecisionTable decisionTable, IOpenMethodHeader header, OpenL openl) {
        this.table = decisionTable;
        this.header = header;
        this.signature = header.getSignature();
        this.openl = openl;
        this.ruleRow = this.table.getRuleRow();
    }

    private static String cutExpressionRoot(String expression) {
        StringTokenizer stringTokenizer = new StringTokenizer(expression, ".");
        if (stringTokenizer.hasMoreTokens()) {
            String v = stringTokenizer.nextToken();
            boolean arrayAccess = StringUtils.matches((Pattern)ARRAY_ACCESS_PATTERN, (CharSequence)v);
            if (arrayAccess) {
                v = v.substring(0, v.indexOf("["));
            }
            return v;
        }
        return expression;
    }

    static IOpenClass findExpressionType(IOpenClass type, String expression) {
        StringTokenizer stringTokenizer = new StringTokenizer(expression, ".");
        boolean isFirst = true;
        while (stringTokenizer.hasMoreTokens()) {
            IOpenField field;
            String v = stringTokenizer.nextToken();
            boolean arrayAccess = StringUtils.matches((Pattern)ARRAY_ACCESS_PATTERN, (CharSequence)v);
            if (isFirst) {
                if (arrayAccess) {
                    type = type.getComponentClass();
                }
                isFirst = false;
                continue;
            }
            if (arrayAccess) {
                v = v.substring(0, v.indexOf("["));
            }
            if (!(type = (field = type.getField(v)).getType()).isArray() || !arrayAccess) continue;
            type = type.getComponentClass();
        }
        return type;
    }

    private IDecisionTableAlgorithm buildAlgorithm() {
        if (this.table.getDtInfo().getNumberHConditions() > 0) {
            IndexInfo vInfo = this.baseInfo.makeVerticalInfo();
            IndexInfo hInfo = this.baseInfo.makeHorizontalalInfo();
            DecisionTableOptimizedAlgorithm va = new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, vInfo);
            DecisionTableOptimizedAlgorithm ha = new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, hInfo);
            return new TwoDimensionalAlgorithm(va, ha);
        }
        return new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, this.baseInfo);
    }

    private void prepareParams(IDecisionRow decisionRow, IBindingContext bindingContext, Map<String, Boolean> usedHeaderNames) {
        Boolean v = usedHeaderNames.get(decisionRow.getName());
        if (v == null) {
            usedHeaderNames.put(decisionRow.getName(), Boolean.FALSE);
        } else if (Boolean.FALSE.equals(v)) {
            usedHeaderNames.put(decisionRow.getName(), Boolean.TRUE);
            String columnType = "Condition";
            if (decisionRow instanceof IBaseAction) {
                IBaseAction baseAction = (IBaseAction)((Object)decisionRow);
                columnType = baseAction.isReturnAction() ? "Return" : "Action";
            }
            GridCellSourceCodeModule cellSourceCodeModule = new GridCellSourceCodeModule(decisionRow.getInfoTable().getSource(), bindingContext);
            BindHelper.processError((String)String.format("%s '%s' is already defined.", columnType, decisionRow.getName()), (IOpenSourceCodeModule)cellSourceCodeModule, (IBindingContext)bindingContext);
        }
        decisionRow.prepareParams(this.openl, bindingContext);
    }

    private void prepareCondAndActionParams(IBindingContext bindingContext) {
        HashMap<String, Boolean> usedHeaderNames = new HashMap<String, Boolean>();
        for (IBaseCondition iBaseCondition : this.table.getConditionRows()) {
            this.prepareParams((IDecisionRow)((Object)iBaseCondition), bindingContext, usedHeaderNames);
        }
        for (IBaseDecisionRow iBaseDecisionRow : this.table.getActionRows()) {
            this.prepareParams((IDecisionRow)iBaseDecisionRow, bindingContext, usedHeaderNames);
        }
    }

    @Override
    public IDecisionTableAlgorithm prepareAndBuildAlgorithm(IBindingContext bindingContext) throws Exception {
        this.prepareCondAndActionParams(bindingContext);
        DecisionTableDataType ruleExecutionType = new DecisionTableDataType(this.table, this.table.getName() + "Type", this.openl, false);
        this.evaluators = this.prepareConditions(ruleExecutionType, bindingContext);
        this.prepareActions(ruleExecutionType, bindingContext);
        this.baseInfo = new IndexInfo().withTable(this.table);
        IDecisionTableAlgorithm algorithm = this.buildAlgorithm();
        this.clearMemoryAfterDTCompilationCompleted(ruleExecutionType);
        return algorithm;
    }

    private void clearMemoryAfterDTCompilationCompleted(DecisionTableDataType ruleExecutionType) {
        DecisionExprFieldDataType decisionExprFieldDataType;
        IOpenField exprOpenField = ruleExecutionType.getField(DecisionTableDataType.EXPR_FIELD_NAME);
        if (exprOpenField != null && exprOpenField.getType() instanceof DecisionExprFieldDataType && !(decisionExprFieldDataType = (DecisionExprFieldDataType)exprOpenField.getType()).isExprParameterFieldIsUsed()) {
            for (IBaseCondition iBaseCondition : this.table.getConditionRows()) {
                ((IDecisionRow)((Object)iBaseCondition)).clearExprs();
            }
            for (IBaseDecisionRow iBaseDecisionRow : this.table.getActionRows()) {
                ((IDecisionRow)iBaseDecisionRow).clearExprs();
            }
        }
    }

    private void prepareActions(DecisionTableDataType ruleExecutionType, IBindingContext bindingContext) throws Exception {
        ComponentBindingContext actionBindingContext = new ComponentBindingContext(bindingContext, (ComponentOpenClass)ruleExecutionType);
        int nActions = this.table.getNumberOfActions();
        for (int i = 0; i < nActions; ++i) {
            IAction action = this.table.getAction(i);
            this.prepareAction(action, (IBindingContext)actionBindingContext, ruleExecutionType);
        }
    }

    private void prepareAction(IAction action, IBindingContext actionBindingContext, DecisionTableDataType ruleExecutionType) throws Exception {
        action.prepareAction(this.table, this.header, this.signature, this.openl, actionBindingContext, this.ruleRow, (IOpenClass)ruleExecutionType, this.table.getSyntaxNode());
    }

    private IConditionEvaluator[] prepareConditions(DecisionTableDataType ruleExecutionType, IBindingContext bindingContext) {
        ComponentBindingContext conditionBindingContext = new ComponentBindingContext(bindingContext, (ComponentOpenClass)ruleExecutionType);
        int nConditions = this.table.getNumberOfConditions();
        IConditionEvaluator[] evaluators = new IConditionEvaluator[nConditions];
        for (int i = 0; i < nConditions; ++i) {
            evaluators[i] = this.prepareCondition(ruleExecutionType, (IBindingContext)conditionBindingContext, i);
        }
        return evaluators;
    }

    private IConditionEvaluator prepareCondition(DecisionTableDataType ruleExecutionType, IBindingContext bindingContext, int index) {
        ICondition condition = this.table.getCondition(index);
        try {
            condition.prepare(this.table, (IOpenClass)NullOpenClass.the, this.signature, this.openl, bindingContext, this.ruleRow, (IOpenClass)ruleExecutionType, this.table.getSyntaxNode());
        }
        catch (Exception e) {
            BindHelper.processError((Throwable)e, (ISyntaxNode)this.table.getSyntaxNode(), (IBindingContext)bindingContext);
            return DefaultConditionEvaluator.INSTANCE;
        }
        IBoundMethodNode methodNode = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode();
        if (methodNode == null) {
            return DefaultConditionEvaluator.INSTANCE;
        }
        condition.setConditionParametersUsed(DecisionTableAlgorithmBuilder.checkConditionParameterUsedInExpression(condition));
        condition.setRuleIdOrRuleNameUsed(DecisionTableAlgorithmBuilder.checkRuleIdOrRuleNameInExpression(condition));
        condition.setDependentOnOtherColumnsParams(this.checkOtherColumnParametersInExpression((Condition)condition));
        IOpenSourceCodeModule source = methodNode.getSyntaxNode().getModule();
        if (StringUtils.isEmpty((CharSequence)source.getCode())) {
            BindHelper.processError((String)"Cannot execute empty expression.", (IOpenSourceCodeModule)source, (IBindingContext)bindingContext);
            return DefaultConditionEvaluator.INSTANCE;
        }
        IBoundNode[] children = methodNode.getChildren();
        if (children != null && children.length == 1 && children[0].getChildren() != null && children[0].getChildren().length > 0 && children[0].getChildren()[0] instanceof TypeBoundNode) {
            String message = String.format("Cannot execute expression with only type definition '%s'.", source.getCode());
            BindHelper.processError((String)message, (IOpenSourceCodeModule)source, (IBindingContext)bindingContext);
            return DefaultConditionEvaluator.INSTANCE;
        }
        IOpenClass methodType = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode().getType();
        if (condition.isDependentOnOtherColumnsParams()) {
            condition.setConditionEvaluator(DefaultConditionEvaluator.INSTANCE);
            if (!JavaOpenClass.BOOLEAN.equals((Object)methodType) && !JavaOpenClass.getOpenClass(Boolean.class).equals((Object)methodType)) {
                if (condition.getParams().length != 1) {
                    BindHelper.processError((String)"Condition expression must return a boolean type if it uses condition parameters.", (IOpenSourceCodeModule)source, (IBindingContext)bindingContext);
                    return DefaultConditionEvaluator.INSTANCE;
                }
                IOpenCast openCast = bindingContext.getCast(methodType, condition.getParams()[0].getType());
                if (openCast.isImplicit()) {
                    condition.setComparisonCast(openCast);
                }
            }
            return DefaultConditionEvaluator.INSTANCE;
        }
        if (condition.isDependentOnInputParams() || condition.isRuleIdOrRuleNameUsed()) {
            if (!JavaOpenClass.BOOLEAN.equals((Object)methodType) && !JavaOpenClass.getOpenClass(Boolean.class).equals((Object)methodType)) {
                BindHelper.processError((String)"Condition expression must return a boolean type if it uses condition parameters.", (IOpenSourceCodeModule)source, (IBindingContext)bindingContext);
                return DefaultConditionEvaluator.INSTANCE;
            }
            IConditionEvaluator conditionEvaluator = DependentParametersOptimizedAlgorithm.makeEvaluator(condition, this.signature, bindingContext);
            if (conditionEvaluator != null) {
                condition.setConditionEvaluator(conditionEvaluator);
                IMethodCaller evaluator = DecisionTableAlgorithmBuilder.makeOptimizedConditionMethodEvaluator(condition, this.signature, conditionEvaluator.getOptimizedSourceCode());
                condition.setEvaluator(evaluator);
                if (evaluator == null) {
                    condition.setEvaluator(DecisionTableAlgorithmBuilder.makeDependentParamsIndexedConditionMethodEvaluator(condition, this.signature, conditionEvaluator.getOptimizedSourceCode()));
                }
            } else {
                conditionEvaluator = DefaultConditionEvaluator.INSTANCE;
                condition.setConditionEvaluator(conditionEvaluator);
            }
            return conditionEvaluator;
        }
        IConditionEvaluator dtcev = DecisionTableOptimizedAlgorithm.makeEvaluator(condition, methodType, bindingContext);
        condition.setEvaluator(this.makeOptimizedConditionMethodEvaluator(condition, this.signature));
        condition.setConditionEvaluator(dtcev);
        return dtcev;
    }

    private boolean checkOtherColumnParametersInExpression(Condition condition) {
        RulesBindingDependencies dependencies = new RulesBindingDependencies();
        condition.getMethod().updateDependency((BindingDependencies)dependencies);
        for (IOpenField field : dependencies.getFieldsMap().values()) {
            if (!((field = Condition.getLocalField(field)) instanceof ConditionOrActionParameterField) && !(field instanceof ConditionOrActionDirectParameterField)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkConditionParameterUsedInExpression(ICondition condition) {
        List<ExpressionIdentifier> identifiers = DecisionTableUtils.extractIdentifiers(condition);
        for (IParameterDeclaration condParam : condition.getParams()) {
            if (!identifiers.stream().anyMatch(identifierNode -> condParam.getName() != null && condParam.getName().equalsIgnoreCase(identifierNode.getIdentifier()))) continue;
            return true;
        }
        return identifiers.stream().anyMatch(identifierNode -> Objects.equals("$" + condition.getName(), identifierNode.getIdentifier()));
    }

    private static boolean checkRuleIdOrRuleNameInExpression(ICondition condition) {
        List<ExpressionIdentifier> identifiers = DecisionTableUtils.extractIdentifiers(condition);
        return identifiers.stream().anyMatch(e -> "$Rule".equals(e.getIdentifier()) || "$RuleId".equals(e.getIdentifier()));
    }

    private IMethodCaller makeOptimizedConditionMethodEvaluator(ICondition condition, IMethodSignature signature) {
        return DecisionTableAlgorithmBuilder.makeOptimizedConditionMethodEvaluator(condition, signature, DecisionTableUtils.getConditionSourceCode(condition));
    }

    private static IMethodCaller makeOptimizedConditionMethodEvaluator(ICondition condition, IMethodSignature signature, String code) {
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            String pname = signature.getParameterName(i);
            if (!pname.equals(code)) continue;
            return new ParameterMethodCaller(condition.getMethod(), i);
        }
        return null;
    }

    private static IMethodCaller makeDependentParamsIndexedConditionMethodEvaluator(ICondition condition, IMethodSignature signature, String optimizedCode) {
        String v = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        if (optimizedCode != null && !optimizedCode.equals(v)) {
            String p = DecisionTableAlgorithmBuilder.cutExpressionRoot(optimizedCode);
            for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
                String pname = signature.getParameterName(i);
                if (!pname.equals(p)) continue;
                IOpenClass type = DecisionTableAlgorithmBuilder.findExpressionType(signature.getParameterType(i), optimizedCode);
                return new SourceCodeMethodCaller(signature, type, optimizedCode);
            }
        }
        return null;
    }
}

