/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.rules.dt.Expr;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.ReadOnlyStorage;
import org.openl.rules.dt.storage.StorageInfo;
import org.openl.rules.dt.storage.StorageUtils;

abstract class MappedStorage
extends ReadOnlyStorage<Object> {
    private final Object[] uniqueValues;
    private IStorage storage;

    MappedStorage(Object[] uniqueValues, IStorage storage, StorageInfo info) {
        super(info);
        this.uniqueValues = uniqueValues;
        this.storage = storage;
    }

    @Override
    public Object getValue(int index) {
        return this.uniqueValues[this.mapIndex(index)];
    }

    protected abstract int mapIndex(int var1);

    @Override
    public boolean isSpace(int index) {
        return this.uniqueValues[this.mapIndex(index)] == null;
    }

    @Override
    public boolean isFormula(int index) {
        return StorageUtils.isFormula(this.uniqueValues[this.mapIndex(index)]);
    }

    @Override
    public boolean isElse(int index) {
        return this.uniqueValues[this.mapIndex(index)] == IStorage.StorageType.ELSE;
    }

    @Override
    public Expr getExprValue(int index) {
        return this.storage.getExprValue(index);
    }

    @Override
    public void removeExprs() {
        this.storage = null;
    }
}

