/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.MappedStorage;
import org.openl.rules.dt.storage.StorageInfo;

class ShortExtMappedStorage
extends MappedStorage {
    private final short[] bmap;

    ShortExtMappedStorage(int[] map, Object[] uniqueValues, IStorage storage, StorageInfo info) {
        super(uniqueValues, storage, info);
        int size = map.length;
        this.bmap = new short[size];
        for (int i = 0; i < size; ++i) {
            this.bmap[i] = (short)(Short.MAX_VALUE - map[i]);
        }
    }

    @Override
    public final int size() {
        return this.bmap.length;
    }

    @Override
    protected int mapIndex(int index) {
        return Short.MAX_VALUE - this.bmap[index];
    }
}

