package org.openl.rules.lang.xls;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

import org.apache.poi.ss.usermodel.Sheet;

import org.openl.rules.lang.xls.load.SheetLoader;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.StringTool;

@Deprecated
public class XlsSheetSourceCodeModule implements IOpenSourceCodeModule {
    private final XlsWorkbookSourceCodeModule workbookSource;

    private final SheetLoader sheetLoader;

    private Map<String, Object> params;

    public XlsSheetSourceCodeModule(int sheetIndex, XlsWorkbookSourceCodeModule workbookSource) {
        this(workbookSource.getWorkbookLoader().getSheetLoader(sheetIndex), workbookSource);
    }

    public XlsSheetSourceCodeModule(SheetLoader sheetLoader, XlsWorkbookSourceCodeModule workbookSource) {
        this.sheetLoader = sheetLoader;
        this.workbookSource = workbookSource;
    }

    @Override
    public InputStream getByteStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCode() {
        return null;
    }

    public String getDisplayName() {
        return getSheetName();
    }

    public Sheet getSheet() {
        return sheetLoader.getSheet();
    }

    public String getSheetName() {
        return sheetLoader.getSheetName();
    }

    public SheetLoader getSheetLoader() {
        return sheetLoader;
    }

    @Override
    public int getStartPosition() {
        return 0;
    }

    @Override
    public String getFileUri() {
        return workbookSource.getFileUri();
    }

    @Override
    public String getUri() {
        String workbookUri = workbookSource.getUri();
        if (workbookUri == null) {
            // assume that URI is null for virtual grid module, let's try to make it unique
            workbookUri = "VIRTUAL_WORKBOOK@" + System.identityHashCode(this);
        }
        return workbookUri + "?sheet=" + StringTool.encodeURL(getSheetName());
    }

    public XlsWorkbookSourceCodeModule getWorkbookSource() {
        return workbookSource;
    }

    @Override
    public Map<String, Object> getParams() {
        return params;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}
