/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.openl.binding.exception.AmbiguousFieldException;
import org.openl.binding.exception.DuplicatedFieldException;
import org.openl.binding.impl.cast.VOID;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.binding.impl.module.ModuleSpecificType;
import org.openl.gen.FieldDescription;
import org.openl.rules.calc.AnySpreadsheetResultOpenClass;
import org.openl.rules.calc.CastingCustomSpreadsheetResultField;
import org.openl.rules.calc.CombinedSpreadsheetResultOpenClass;
import org.openl.rules.calc.CustomSpreadsheetResultConstructor;
import org.openl.rules.calc.CustomSpreadsheetResultField;
import org.openl.rules.calc.SpreadsheetCell;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultBeanClass;
import org.openl.rules.calc.SpreadsheetResultBeanPropertyNamingStrategy;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.datatype.gen.JavaBeanClassBuilder;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.Point;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.DynamicArrayAggregateInfo;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSpreadsheetResultOpenClass
extends ADynamicClass
implements ModuleSpecificType {
    public static final String ROW_NAMES_FIELD_NAME = "rowNames";
    public static final String COLUMN_NAMES_FIELD_NAME = "columnNames";
    public static final String TABLE_DETAILS_FIELD_NAME = "tableDetails";
    private final Logger log = LoggerFactory.getLogger(CustomSpreadsheetResultOpenClass.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Comparator<String> FIELD_COMPARATOR = (o1, o2) -> {
        char c2;
        char c1 = Character.toUpperCase(o1.charAt(0));
        if (c1 != (c2 = Character.toUpperCase(o2.charAt(0)))) {
            return c1 - c2;
        }
        int len1 = o1.length();
        int len2 = o2.length();
        int lim = Math.min(len1, len2);
        for (int k = 1; k < lim; ++k) {
            c1 = o1.charAt(k);
            if (c1 == (c2 = o2.charAt(k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    };
    private String[] rowNames;
    private String[] columnNames;
    private String[] rowNamesForResultModel;
    private String[] columnNamesForResultModel;
    private final List<Pair<String[], String[]>> rowAndColumnNamesForResultModelHistory;
    private Map<String, Point> fieldsCoordinates;
    private final XlsModuleOpenClass module;
    private volatile Class<?> beanClass;
    private volatile SpreadsheetResultSetter[] spreadsheetResultSetters;
    private boolean simpleRefByRow;
    private boolean simpleRefByColumn;
    private long columnsForResultModelCount;
    private long rowsForResultModelCount;
    private boolean tableStructureDetails;
    private boolean ignoreCompilation;
    private ILogicalTable logicalTable;
    private volatile byte[] beanClassByteCode;
    protected volatile String beanClassName;
    volatile Map<String, List<IOpenField>> beanFieldsMap;
    volatile Map<String, String> xmlNamesMap;
    private String[] sprStructureFieldNames;
    private volatile boolean initializing;
    private final boolean generateBeanClass;
    private final boolean spreadsheet;
    private final Collection<Consumer<CustomSpreadsheetResultOpenClass>> eventsOnUpdateWithType = new ArrayList<Consumer<CustomSpreadsheetResultOpenClass>>();
    private static final Comparator<Pair<Point, IOpenField>> COMP = Comparator.comparing(Pair::getLeft, Comparator.nullsLast(Comparator.comparingInt(Point::getRow).thenComparingInt(Point::getColumn)));

    public CustomSpreadsheetResultOpenClass(String name, String[] rowNames, String[] columnNames, String[] rowNamesForResultModel, String[] columnNamesForResultModel, XlsModuleOpenClass module, boolean tableStructureDetails, boolean generateBeanClass, boolean spreadsheet) {
        super(name, SpreadsheetResult.class);
        this.rowNames = Objects.requireNonNull(rowNames);
        this.columnNames = Objects.requireNonNull(columnNames);
        this.rowNamesForResultModel = Objects.requireNonNull(rowNamesForResultModel);
        this.columnNamesForResultModel = Objects.requireNonNull(columnNamesForResultModel);
        this.columnsForResultModelCount = Arrays.stream(columnNamesForResultModel).filter(Objects::nonNull).count();
        this.rowsForResultModelCount = Arrays.stream(rowNamesForResultModel).filter(Objects::nonNull).count();
        this.simpleRefByRow = this.columnsForResultModelCount == 1L;
        this.simpleRefByColumn = this.rowsForResultModelCount == 1L;
        this.rowAndColumnNamesForResultModelHistory = new ArrayList<Pair<String[], String[]>>();
        this.rowAndColumnNamesForResultModelHistory.add((Pair<String[], String[]>)Pair.of((Object)this.columnNamesForResultModel, (Object)this.rowNamesForResultModel));
        this.fieldsCoordinates = SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames, this.simpleRefByColumn, this.simpleRefByRow);
        this.module = module;
        this.tableStructureDetails = tableStructureDetails;
        this.generateBeanClass = generateBeanClass;
        this.spreadsheet = spreadsheet;
    }

    public CustomSpreadsheetResultOpenClass(String name, XlsModuleOpenClass module, ILogicalTable logicalTable, boolean generateBeanClass, boolean spreadsheet) {
        this(name, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, module, false, generateBeanClass, spreadsheet);
        this.simpleRefByRow = true;
        this.simpleRefByColumn = true;
        this.logicalTable = logicalTable;
    }

    public String[] getSprStructureFieldNames() {
        return this.sprStructureFieldNames;
    }

    public boolean isSimpleRefByColumn() {
        return this.simpleRefByColumn;
    }

    public boolean isSimpleRefByRow() {
        return this.simpleRefByRow;
    }

    public boolean isSpreadsheet() {
        return this.spreadsheet;
    }

    public IOpenClass getClosestClass(ModuleSpecificType openClass) {
        return this.getParentClass(openClass);
    }

    public IOpenClass getParentClass(ModuleSpecificType openClass) {
        if (openClass instanceof CustomSpreadsheetResultOpenClass) {
            CustomSpreadsheetResultOpenClass csroc = (CustomSpreadsheetResultOpenClass)openClass;
            if (this.getModule().isDependencyModule(csroc.getModule(), new IdentityHashMap())) {
                return this.getModule().buildOrGetCombinedSpreadsheetResult(this, csroc);
            }
            return AnySpreadsheetResultOpenClass.INSTANCE;
        }
        return null;
    }

    public void addField(IOpenField field) throws DuplicatedFieldException {
        if (!(field instanceof CustomSpreadsheetResultField)) {
            throw new IllegalStateException(String.format("Expected type '%s', but found type '%s'.", CustomSpreadsheetResultField.class.getTypeName(), field.getClass().getTypeName()));
        }
        super.addField(field);
    }

    public boolean isAssignableFrom(IOpenClass ioc) {
        if (ioc instanceof CustomSpreadsheetResultOpenClass && !(ioc instanceof CombinedSpreadsheetResultOpenClass)) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)ioc;
            return this.getModule().isDependencyModule(customSpreadsheetResultOpenClass.getModule(), new IdentityHashMap()) && this.getName().equals(customSpreadsheetResultOpenClass.getName());
        }
        return false;
    }

    public IAggregateInfo getAggregateInfo() {
        return DynamicArrayAggregateInfo.aggregateInfo;
    }

    public byte[] getBeanClassByteCode() {
        return (byte[])this.beanClassByteCode.clone();
    }

    public Collection<IOpenClass> superClasses() {
        return Collections.singleton(this.getModule().getSpreadsheetResultOpenClassWithResolvedFieldTypes());
    }

    protected IOpenField searchFieldFromSuperClass(String fname, boolean strictMatch) throws AmbiguousFieldException {
        return null;
    }

    public XlsModuleOpenClass getModule() {
        return this.module;
    }

    private void extendSpreadsheetResult(String[] rowNames, String[] columnNames, String[] rowNamesForResultModel, String[] columnNamesForResultModel, Collection<IOpenField> fields, boolean simpleRefByRow, boolean simpleRefByColumn, boolean tableStructureDetails) {
        int k;
        int i;
        if (this.beanClass != null) {
            throw new IllegalStateException("Bean class for custom spreadsheet result is already generated. This spreadsheet result type cannot be extended.");
        }
        List<String> nRowNames = Arrays.stream(this.rowNames).collect(Collectors.toList());
        List<String> nRowNamesForResultModel = Arrays.stream(this.rowNamesForResultModel).collect(Collectors.toList());
        Set existedRowNamesSet = Arrays.stream(this.rowNames).collect(Collectors.toSet());
        List<String> nColumnNames = Arrays.stream(this.columnNames).collect(Collectors.toList());
        List<String> nColumnNamesForResultModel = Arrays.stream(this.columnNamesForResultModel).collect(Collectors.toList());
        Set existedColumnNamesSet = Arrays.stream(this.columnNames).collect(Collectors.toSet());
        boolean rowColumnsForResultModelNeedUpdate = false;
        for (i = 0; i < rowNames.length; ++i) {
            if (!existedRowNamesSet.contains(rowNames[i])) {
                nRowNames.add(rowNames[i]);
                nRowNamesForResultModel.add(rowNamesForResultModel[i]);
                rowColumnsForResultModelNeedUpdate = true;
                continue;
            }
            if (rowNamesForResultModel[i] == null) continue;
            k = nRowNames.indexOf(rowNames[i]);
            nRowNamesForResultModel.set(k, rowNamesForResultModel[i]);
            rowColumnsForResultModelNeedUpdate = true;
        }
        for (i = 0; i < columnNames.length; ++i) {
            if (!existedColumnNamesSet.contains(columnNames[i])) {
                nColumnNames.add(columnNames[i]);
                nColumnNamesForResultModel.add(columnNamesForResultModel[i]);
                rowColumnsForResultModelNeedUpdate = true;
                continue;
            }
            if (columnNamesForResultModel[i] == null) continue;
            k = nColumnNames.indexOf(columnNames[i]);
            nColumnNamesForResultModel.set(k, columnNamesForResultModel[i]);
            rowColumnsForResultModelNeedUpdate = true;
        }
        if (rowColumnsForResultModelNeedUpdate) {
            this.simpleRefByRow = simpleRefByRow && this.simpleRefByRow;
            this.simpleRefByColumn = simpleRefByColumn && this.simpleRefByColumn;
            this.rowAndColumnNamesForResultModelHistory.add((Pair<String[], String[]>)Pair.of((Object)columnNamesForResultModel, (Object)rowNamesForResultModel));
            this.rowNamesForResultModel = nRowNamesForResultModel.toArray(EMPTY_STRING_ARRAY);
            this.columnNamesForResultModel = nColumnNamesForResultModel.toArray(EMPTY_STRING_ARRAY);
            this.columnsForResultModelCount = Arrays.stream(this.columnNamesForResultModel).filter(Objects::nonNull).count();
            this.rowsForResultModelCount = Arrays.stream(this.rowNamesForResultModel).filter(Objects::nonNull).count();
            this.rowNames = nRowNames.toArray(EMPTY_STRING_ARRAY);
            this.columnNames = nColumnNames.toArray(EMPTY_STRING_ARRAY);
            this.fieldsCoordinates = Collections.unmodifiableMap(SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames, this.simpleRefByColumn, this.simpleRefByRow));
        }
        for (IOpenField field : fields) {
            IOpenField thisField = this.getField(field.getName());
            if (thisField == null) {
                this.addField((IOpenField)new CustomSpreadsheetResultField(this, field));
                continue;
            }
            this.fieldMap().put(field.getName(), new CastingCustomSpreadsheetResultField((IOpenClass)this, field.getName(), thisField, field));
        }
        this.tableStructureDetails = this.tableStructureDetails || tableStructureDetails;
    }

    public String[] getRowNames() {
        return (String[])this.rowNames.clone();
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public Map<String, Point> getFieldsCoordinates() {
        return this.fieldsCoordinates;
    }

    public void updateWithType(IOpenClass openClass) {
        if (this.beanClassByteCode != null) {
            throw new IllegalStateException("Java bean class for custom spreadsheet result is loaded to classloader. Custom spreadsheet result cannot be extended.");
        }
        if (openClass instanceof SpreadsheetResultOpenClass) {
            this.updateWithType((IOpenClass)((SpreadsheetResultOpenClass)openClass).toCustomSpreadsheetResultOpenClass());
            return;
        }
        CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)openClass;
        if (customSpreadsheetResultOpenClass.getModule() != this.getModule()) {
            customSpreadsheetResultOpenClass = customSpreadsheetResultOpenClass.convertToModuleType(this.getModule(), false);
        }
        this.extendSpreadsheetResult(customSpreadsheetResultOpenClass.rowNames, customSpreadsheetResultOpenClass.columnNames, customSpreadsheetResultOpenClass.rowNamesForResultModel, customSpreadsheetResultOpenClass.columnNamesForResultModel, customSpreadsheetResultOpenClass.getFields(), customSpreadsheetResultOpenClass.simpleRefByRow, customSpreadsheetResultOpenClass.simpleRefByColumn, customSpreadsheetResultOpenClass.tableStructureDetails);
        this.eventsOnUpdateWithType.forEach(e -> e.accept(this));
    }

    public void addEventOnUpdateWithType(Consumer<CustomSpreadsheetResultOpenClass> c) {
        this.eventsOnUpdateWithType.add(c);
    }

    public Collection<IOpenField> getFields() {
        return Collections.unmodifiableCollection(this.fieldMap().values());
    }

    private IOpenField fixModuleFieldType(IOpenField openField) {
        IOpenClass type = openField.getType();
        int dim = 0;
        while (type.isArray()) {
            type = type.getComponentClass();
            ++dim;
        }
        IOpenClass t = this.getModule().toModuleType(type);
        if (t != type) {
            if (dim > 0) {
                t = t.getArrayType(dim);
            }
            return new CustomSpreadsheetResultField((IOpenClass)this, openField.getName(), t);
        }
        return openField;
    }

    public String[] getRowNamesForResultModel() {
        return (String[])this.rowNamesForResultModel.clone();
    }

    public String[] getColumnNamesForResultModel() {
        return (String[])this.columnNamesForResultModel.clone();
    }

    public CustomSpreadsheetResultOpenClass convertToModuleTypeAndRegister(ModuleOpenClass module) {
        return this.convertToModuleType(module, true);
    }

    protected CustomSpreadsheetResultOpenClass convertToModuleType(ModuleOpenClass module, boolean register) {
        if (this.getModule() != module) {
            if (register && module.findType(this.getName()) != null) {
                throw new IllegalStateException("Type has already exists in the module.");
            }
            CustomSpreadsheetResultOpenClass type = new CustomSpreadsheetResultOpenClass(this.getName(), this.rowNames, this.columnNames, this.rowNamesForResultModel, this.columnNamesForResultModel, (XlsModuleOpenClass)module, this.tableStructureDetails, this.generateBeanClass, this.spreadsheet);
            type.simpleRefByRow = this.simpleRefByRow;
            type.simpleRefByColumn = this.simpleRefByColumn;
            if (register) {
                module.addType((IOpenClass)type);
            }
            for (IOpenField field : this.getFields()) {
                if (field instanceof CustomSpreadsheetResultField) {
                    type.addField(type.fixModuleFieldType(field));
                    continue;
                }
                type.addField(field);
            }
            type.setMetaInfo(this.getMetaInfo());
            type.logicalTable = this.logicalTable;
            return type;
        }
        return this;
    }

    public ILogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public Object newInstance(IRuntimeEnv env) {
        SpreadsheetResult spr = new SpreadsheetResult(new Object[this.rowNames.length][this.columnNames.length], this.rowNames, this.columnNames, this.rowNamesForResultModel, this.columnNamesForResultModel, this.fieldsCoordinates);
        spr.setCustomSpreadsheetResultOpenClass(this);
        spr.setLogicalTable(this.logicalTable);
        return spr;
    }

    public Object createBean(SpreadsheetResult spreadsheetResult) {
        return this.createBean(spreadsheetResult, null);
    }

    public Object createBean(SpreadsheetResult spreadsheetResult, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
        Object target;
        Class<?> clazz = this.getBeanClass();
        try {
            target = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log.debug("Ignored error: ", (Throwable)e);
            return null;
        }
        for (SpreadsheetResultSetter spreadsheetResultSetter : this.spreadsheetResultSetters) {
            spreadsheetResultSetter.setToBean(spreadsheetResult, target, spreadsheetResultBeanPropertyNamingStrategy);
        }
        return target;
    }

    public boolean isBeanClassInitialized() {
        return this.beanClass != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getBeanClass() {
        if (this.beanClass == null) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = this;
            synchronized (customSpreadsheetResultOpenClass) {
                if (this.beanClass == null) {
                    try {
                        this.generateBeanClass();
                        Class beanClass = this.getModule().getClassGenerationClassLoader().loadClass(this.getBeanClassName());
                        ArrayList<SpreadsheetResultSetter> sprSetters = new ArrayList<SpreadsheetResultSetter>();
                        for (Field field : beanClass.getDeclaredFields()) {
                            if (field.isSynthetic()) continue;
                            List<IOpenField> openFields = this.beanFieldsMap.get(field.getName());
                            if (openFields != null) {
                                ArrayList<SpreadsheetResultFieldValueSetter> sprSettersForField = new ArrayList<SpreadsheetResultFieldValueSetter>();
                                for (IOpenField openField : openFields) {
                                    SpreadsheetResultFieldValueSetter spreadsheetResultValueSetter = new SpreadsheetResultFieldValueSetter(field, openField);
                                    sprSettersForField.add(spreadsheetResultValueSetter);
                                }
                                sprSetters.add(new SpreadsheetResultValueSetter(sprSettersForField.toArray(SpreadsheetResultFieldValueSetter.EMPTY_ARRAY)));
                                continue;
                            }
                            if (field.getName().equals(this.sprStructureFieldNames[0])) {
                                sprSetters.add(new SpreadsheetResultRowNamesSetter(field));
                                continue;
                            }
                            if (field.getName().equals(this.sprStructureFieldNames[1])) {
                                sprSetters.add(new SpreadsheetResultColumnNamesSetter(field));
                                continue;
                            }
                            if (!field.getName().equals(this.sprStructureFieldNames[2])) continue;
                            sprSetters.add(new SpreadsheetResultFieldNamesSetter(field, this.beanFieldsMap, this.xmlNamesMap));
                        }
                        this.spreadsheetResultSetters = sprSetters.toArray(SpreadsheetResultSetter.EMPTY_ARRAY);
                        this.beanClass = beanClass;
                    }
                    catch (Exception | LinkageError e) {
                        throw new IllegalStateException(String.format("Failed to create bean class for '%s' spreadsheet result.", this.getName()), e);
                    }
                }
            }
        }
        return this.beanClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateBeanClass() {
        if (!this.generateBeanClass) {
            throw new IllegalStateException("This custom spreadsheet result cannot be converted to a bean.");
        }
        if (this.beanClassByteCode == null) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = this;
            synchronized (customSpreadsheetResultOpenClass) {
                if (this.beanClassByteCode == null && !this.initializing) {
                    try {
                        this.initializing = true;
                        String beanClassName = this.getBeanClassName();
                        JavaBeanClassBuilder beanClassBuilder = new JavaBeanClassBuilder(beanClassName).withAdditionalConstructor(false).withEqualsHashCodeToStringMethods(false);
                        beanClassBuilder.writeToType(e -> {
                            AnnotationVisitor av = e.visitAnnotation(Type.getDescriptor(SpreadsheetResultBeanClass.class), true);
                            av.visitEnd();
                        });
                        TreeMap<String, String> xmlNames = new TreeMap<String, String>(FIELD_COMPARATOR);
                        List[][] used = new List[this.rowNames.length][this.columnNames.length];
                        HashMap<String, List<IOpenField>> fieldsMap = new HashMap<String, List<IOpenField>>();
                        List<Pair<Point, IOpenField>> fields = this.getListOfFields();
                        IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>> cache = new IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>>();
                        this.addFieldsToJavaClassBuilder(beanClassBuilder, fields, used, xmlNames, true, fieldsMap, cache);
                        this.addFieldsToJavaClassBuilder(beanClassBuilder, fields, used, xmlNames, false, fieldsMap, cache);
                        this.sprStructureFieldNames = this.addSprStructureFields(beanClassBuilder, fieldsMap.keySet(), xmlNames.values());
                        byte[] bc = beanClassBuilder.byteCode();
                        this.getModule().getClassGenerationClassLoader().addGeneratedClass(beanClassName, bc);
                        this.beanFieldsMap = Collections.unmodifiableMap(fieldsMap);
                        this.xmlNamesMap = Collections.unmodifiableMap(xmlNames);
                        this.beanClassByteCode = bc;
                    }
                    finally {
                        this.initializing = false;
                    }
                }
            }
        }
    }

    private List<Pair<Point, IOpenField>> getListOfFields() {
        return this.getFields().stream().map(e -> Pair.of((Object)this.fieldsCoordinates.get(e.getName()), (Object)e)).sorted(COMP).collect(Collectors.toList());
    }

    public Map<String, List<IOpenField>> getBeanFieldsMap() {
        if (this.beanFieldsMap == null) {
            this.generateBeanClass();
        }
        return this.beanFieldsMap;
    }

    public Map<String, String> getXmlNamesMap() {
        if (this.xmlNamesMap == null) {
            this.generateBeanClass();
        }
        return this.xmlNamesMap;
    }

    public static String findNonConflictFieldName(Collection<String> beanFieldNames, String fName) {
        Object fNewName = fName;
        int i = 1;
        while (beanFieldNames.contains(fNewName)) {
            fNewName = fName + i;
            ++i;
        }
        return fNewName;
    }

    public boolean isGenerateBeanClass() {
        return this.generateBeanClass;
    }

    private String[] addSprStructureFields(JavaBeanClassBuilder beanClassBuilder, Set<String> beanFieldNames, Collection<String> xmlNames) {
        if (this.tableStructureDetails) {
            String[] sprStructureFieldNames = new String[]{CustomSpreadsheetResultOpenClass.findNonConflictFieldName(beanFieldNames, ROW_NAMES_FIELD_NAME), CustomSpreadsheetResultOpenClass.findNonConflictFieldName(beanFieldNames, COLUMN_NAMES_FIELD_NAME), CustomSpreadsheetResultOpenClass.findNonConflictFieldName(beanFieldNames, TABLE_DETAILS_FIELD_NAME)};
            beanClassBuilder.addField(sprStructureFieldNames[0], new FieldDescription(String[].class.getName(), null, null, null, CustomSpreadsheetResultOpenClass.findNonConflictFieldName(xmlNames, "RowNames"), false));
            beanClassBuilder.addField(sprStructureFieldNames[1], new FieldDescription(String[].class.getName(), null, null, null, CustomSpreadsheetResultOpenClass.findNonConflictFieldName(xmlNames, "ColumnNames"), false));
            beanClassBuilder.addField(sprStructureFieldNames[2], new FieldDescription(String[][].class.getName(), null, null, null, CustomSpreadsheetResultOpenClass.findNonConflictFieldName(xmlNames, "TableDetails"), false));
            return sprStructureFieldNames;
        }
        return new String[3];
    }

    public boolean isExternalCustomSpreadsheetResultOpenClass(CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass, IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>> cache) {
        return !this.getModule().isDependencyModule(customSpreadsheetResultOpenClass.getModule(), cache);
    }

    public boolean isExternalSpreadsheetResultOpenClass(SpreadsheetResultOpenClass spreadsheetResultOpenClass, IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>> cache) {
        return !this.getModule().isDependencyModule(spreadsheetResultOpenClass.getModule(), cache);
    }

    private void addFieldsToJavaClassBuilder(JavaBeanClassBuilder beanClassBuilder, List<Pair<Point, IOpenField>> fields, List<IOpenField>[][] used, Map<String, String> usedXmlNames, boolean addFieldNameWithCollisions, Map<String, List<IOpenField>> beanFieldsMap, IdentityHashMap<ModuleOpenClass, IdentityHashMap<ModuleOpenClass, Boolean>> cache) {
        for (Pair<Point, IOpenField> pair : fields) {
            Point point = (Point)pair.getLeft();
            if (point == null) continue;
            int row = point.getRow();
            int column = point.getColumn();
            String rowName = this.rowNamesForResultModel[row];
            String columnName = this.columnNamesForResultModel[column];
            if (rowName == null || columnName == null) continue;
            IOpenField field = null;
            if (used[row][column] == null) {
                String typeName;
                Object xmlName;
                Object fieldName;
                if (this.simpleRefByRow) {
                    fieldName = rowName;
                    xmlName = rowName;
                    field = this.getField("$" + rowName);
                } else if (this.simpleRefByColumn) {
                    fieldName = columnName;
                    xmlName = columnName;
                    field = this.getField("$" + columnName);
                } else {
                    if (this.absentInHistory(rowName, columnName)) continue;
                    if (StringUtils.isBlank((CharSequence)columnName)) {
                        fieldName = rowName;
                        xmlName = rowName;
                    } else if (StringUtils.isBlank((CharSequence)rowName)) {
                        fieldName = columnName;
                        xmlName = columnName;
                    } else {
                        fieldName = columnName + StringUtils.capitalize((String)rowName);
                        xmlName = columnName + "_" + rowName;
                    }
                }
                if (field == null) {
                    field = (IOpenField)pair.getRight();
                }
                if (!field.getName().startsWith("$")) continue;
                if (StringUtils.isBlank((CharSequence)fieldName)) {
                    fieldName = "_";
                    xmlName = "_";
                }
                IOpenClass t = field.getType();
                int dim = 0;
                while (t.isArray()) {
                    ++dim;
                    t = t.getComponentClass();
                }
                if (t instanceof CustomSpreadsheetResultOpenClass || t instanceof SpreadsheetResultOpenClass || t instanceof AnySpreadsheetResultOpenClass) {
                    XlsModuleOpenClass m;
                    Object fieldClsName;
                    XlsModuleOpenClass additionalClassGenerationClassloaderModule = null;
                    if (t instanceof CustomSpreadsheetResultOpenClass) {
                        CustomSpreadsheetResultOpenClass csroc = (CustomSpreadsheetResultOpenClass)t;
                        boolean externalCustomSpreadsheetResultOpenClass = this.isExternalCustomSpreadsheetResultOpenClass(csroc, cache);
                        if (externalCustomSpreadsheetResultOpenClass) {
                            additionalClassGenerationClassloaderModule = csroc.getModule();
                        }
                        if (csroc.isGenerateBeanClass()) {
                            fieldClsName = csroc.getBeanClassName();
                            csroc.generateBeanClass();
                        } else {
                            m = externalCustomSpreadsheetResultOpenClass ? csroc.getModule() : this.getModule();
                            fieldClsName = m.getGlobalTableProperties().getSpreadsheetResultPackage() + ".AnySpreadsheetResult";
                            m.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().generateBeanClass();
                        }
                    } else if (t instanceof SpreadsheetResultOpenClass) {
                        SpreadsheetResultOpenClass spreadsheetResultOpenClass = (SpreadsheetResultOpenClass)t;
                        boolean externalSpreadsheetResultOpenClass = this.isExternalSpreadsheetResultOpenClass(spreadsheetResultOpenClass, cache);
                        XlsModuleOpenClass xlsModuleOpenClass = m = externalSpreadsheetResultOpenClass ? spreadsheetResultOpenClass.getModule() : this.getModule();
                        if (externalSpreadsheetResultOpenClass) {
                            additionalClassGenerationClassloaderModule = spreadsheetResultOpenClass.getModule();
                        }
                        fieldClsName = m.getGlobalTableProperties().getSpreadsheetResultPackage() + ".AnySpreadsheetResult";
                        m.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass().generateBeanClass();
                    } else {
                        fieldClsName = Map.class.getName();
                    }
                    if (additionalClassGenerationClassloaderModule != null) {
                        this.getModule().getClassGenerationClassLoader().addClassLoader((ClassLoader)additionalClassGenerationClassloaderModule.getClassGenerationClassLoader());
                    }
                    typeName = dim > 0 ? IntStream.range(0, dim).mapToObj(e -> "[").collect(Collectors.joining()) + "L" + (String)fieldClsName + ";" : fieldClsName;
                } else {
                    if (JavaOpenClass.VOID.equals((Object)t) || JavaOpenClass.CLS_VOID.equals((Object)t) || NullOpenClass.the.equals(t) || JavaOpenClass.getOpenClass(VOID.class).equals((Object)t)) continue;
                    Class instanceClass = field.getType().getInstanceClass();
                    typeName = instanceClass.isPrimitive() ? ClassUtils.primitiveToWrapper((Class)instanceClass).getName() : instanceClass.getName();
                }
                Set<Consumer<FieldVisitor>> fieldVisitorWriters = Collections.singleton(fieldVisitor -> {
                    AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(Type.getDescriptor(SpreadsheetCell.class), true);
                    annotationVisitor.visit("column", (Object)columnName);
                    annotationVisitor.visit("row", (Object)rowName);
                    if (this.simpleRefByRow) {
                        annotationVisitor.visit("simpleRefByRow", (Object)true);
                    }
                    if (this.simpleRefByColumn) {
                        annotationVisitor.visit("simpleRefByColumn", (Object)true);
                    }
                    annotationVisitor.visitEnd();
                });
                fieldName = ClassUtils.decapitalize((String)fieldName);
                if (!usedXmlNames.containsKey(fieldName) && !usedXmlNames.containsValue(xmlName)) {
                    FieldDescription fieldDescription = new FieldDescription(typeName, null, null, null, (String)xmlName, false, fieldVisitorWriters, null);
                    beanClassBuilder.addField((String)fieldName, fieldDescription);
                    beanFieldsMap.put((String)fieldName, this.fillUsed(used, point, field));
                    usedXmlNames.put((String)fieldName, (String)xmlName);
                    continue;
                }
                if (!addFieldNameWithCollisions) continue;
                Object newFieldName = fieldName;
                int i = 1;
                while (usedXmlNames.containsKey(newFieldName)) {
                    newFieldName = (String)fieldName + i;
                    ++i;
                }
                Object newXmlName = xmlName;
                i = 1;
                while (usedXmlNames.containsValue(newXmlName)) {
                    newXmlName = (String)xmlName + i;
                    ++i;
                }
                FieldDescription fieldDescription = new FieldDescription(typeName, null, null, null, (String)newXmlName, false, fieldVisitorWriters, null);
                beanClassBuilder.addField((String)newFieldName, fieldDescription);
                beanFieldsMap.put((String)newFieldName, this.fillUsed(used, point, field));
                usedXmlNames.put((String)newFieldName, (String)newXmlName);
                continue;
            }
            boolean f = false;
            for (IOpenField openField : used[row][column]) {
                if (!openField.getName().equals(((IOpenField)pair.getRight()).getName())) continue;
                f = true;
                break;
            }
            if (f) continue;
            used[row][column].add((IOpenField)pair.getRight());
        }
    }

    private boolean absentInHistory(String rowName, String columnName) {
        block0: for (Pair<String[], String[]> p : this.rowAndColumnNamesForResultModelHistory) {
            for (String col : (String[])p.getLeft()) {
                if (!Objects.equals(columnName, col)) continue;
                for (String row : (String[])p.getRight()) {
                    if (!Objects.equals(rowName, row)) continue;
                    return false;
                }
                continue block0;
            }
        }
        return true;
    }

    private List<IOpenField> fillUsed(List<IOpenField>[][] used, Point point, IOpenField field) {
        ArrayList<IOpenField> fields = new ArrayList<IOpenField>();
        fields.add(field);
        if (this.simpleRefByRow) {
            Arrays.fill(used[point.getRow()], fields);
        } else if (this.simpleRefByColumn) {
            for (int w = 0; w < used.length; ++w) {
                used[w][point.getColumn()] = fields;
            }
        } else {
            used[point.getRow()][point.getColumn()] = fields;
        }
        return fields;
    }

    protected String spreadsheetResultNameToBeanName(String name) {
        if (name.startsWith("SpreadsheetResult")) {
            if (name.length() > "SpreadsheetResult".length()) {
                name = name.substring("SpreadsheetResult".length());
            }
            String firstLetterUppercaseName = StringUtils.capitalize((String)name);
            if (this.getModule().findType("SpreadsheetResult" + firstLetterUppercaseName) == null) {
                name = firstLetterUppercaseName;
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBeanClassName() {
        if (this.beanClassName == null) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = this;
            synchronized (customSpreadsheetResultOpenClass) {
                if (this.beanClassName == null) {
                    String name = this.spreadsheetResultNameToBeanName(this.getName());
                    this.beanClassName = this.getModule().getGlobalTableProperties().getSpreadsheetResultPackage() + "." + name;
                }
            }
        }
        return this.beanClassName;
    }

    public SpreadsheetResult createSpreadsheetResult(Object bean, Map<Class<?>, CustomSpreadsheetResultOpenClass> mapClassToSpr) {
        SpreadsheetResult spreadsheetResult = (SpreadsheetResult)this.newInstance(null);
        for (SpreadsheetResultSetter spreadsheetResultSetter : this.spreadsheetResultSetters) {
            spreadsheetResultSetter.setToSpr(spreadsheetResult, bean, mapClassToSpr);
        }
        return spreadsheetResult;
    }

    public boolean isIgnoreCompilation() {
        return this.ignoreCompilation;
    }

    public void setIgnoreCompilation(boolean ignoreCompilation) {
        this.ignoreCompilation = ignoreCompilation;
    }

    protected Map<MethodKey, IOpenMethod> initConstructorMap() {
        Map constructorMap = super.initConstructorMap();
        HashMap<MethodKey, IOpenMethod> spreadsheetResultConstructorMap = new HashMap<MethodKey, IOpenMethod>();
        for (Map.Entry entry : constructorMap.entrySet()) {
            CustomSpreadsheetResultConstructor constructor = new CustomSpreadsheetResultConstructor((IOpenMethod)entry.getValue(), this);
            spreadsheetResultConstructorMap.put(new MethodKey((IOpenMethod)constructor), (IOpenMethod)constructor);
        }
        return spreadsheetResultConstructorMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomSpreadsheetResultOpenClass that = (CustomSpreadsheetResultOpenClass)((Object)o);
        return Objects.equals((Object)this.module, (Object)that.module) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
        return result;
    }

    private static class SpreadsheetResultFieldNamesSetter
    implements SpreadsheetResultSetter {
        private final Field field;
        private final Map<String, List<IOpenField>> beanFieldsMap;
        private final Map<String, String> xmlNamesMap;

        public SpreadsheetResultFieldNamesSetter(Field field, Map<String, List<IOpenField>> beanFieldsMap, Map<String, String> xmlNamesMap) {
            this.field = Objects.requireNonNull(field);
            this.beanFieldsMap = Objects.requireNonNull(beanFieldsMap);
            this.field.setAccessible(true);
            this.xmlNamesMap = Objects.requireNonNull(xmlNamesMap);
        }

        @Override
        public void setToBean(SpreadsheetResult spreadsheetResult, Object target, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
            if (spreadsheetResult.isTableStructureDetails()) {
                String[][] tableStructureDetails = new String[spreadsheetResult.getRowNames().length][spreadsheetResult.getColumnNames().length];
                for (Map.Entry<String, List<IOpenField>> e : this.beanFieldsMap.entrySet()) {
                    List<IOpenField> openFields = e.getValue();
                    for (IOpenField openField : openFields) {
                        Point p = spreadsheetResult.fieldsCoordinates.get(openField.getName());
                        if (p == null || spreadsheetResult.rowNamesForResultModel[p.getRow()] == null || spreadsheetResult.columnNamesForResultModel[p.getColumn()] == null) continue;
                        tableStructureDetails[p.getRow()][p.getColumn()] = this.xmlNamesMap.get(e.getKey());
                    }
                }
                try {
                    this.field.set(target, tableStructureDetails);
                }
                catch (IllegalAccessException e) {
                    LoggerFactory.getLogger(SpreadsheetResultFieldNamesSetter.class).debug("Ignored error: ", (Throwable)e);
                }
            }
        }
    }

    private static class SpreadsheetResultRowNamesSetter
    implements SpreadsheetResultSetter {
        private final Field field;

        public SpreadsheetResultRowNamesSetter(Field field) {
            this.field = Objects.requireNonNull(field);
            this.field.setAccessible(true);
        }

        @Override
        public void setToBean(SpreadsheetResult spreadsheetResult, Object target, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
            try {
                if (spreadsheetResult.isTableStructureDetails()) {
                    this.field.set(target, spreadsheetResult.rowNames);
                }
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(SpreadsheetResultRowNamesSetter.class).debug("Ignored error: ", (Throwable)e);
            }
        }
    }

    private static class SpreadsheetResultColumnNamesSetter
    implements SpreadsheetResultSetter {
        private final Field field;

        public SpreadsheetResultColumnNamesSetter(Field field) {
            this.field = Objects.requireNonNull(field);
            this.field.setAccessible(true);
        }

        @Override
        public void setToBean(SpreadsheetResult spreadsheetResult, Object target, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
            try {
                if (spreadsheetResult.isTableStructureDetails()) {
                    this.field.set(target, spreadsheetResult.columnNames);
                }
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(SpreadsheetResultColumnNamesSetter.class).debug("Ignored error: ", (Throwable)e);
            }
        }
    }

    private static final class SpreadsheetResultFieldValueSetter {
        static final SpreadsheetResultFieldValueSetter[] EMPTY_ARRAY = new SpreadsheetResultFieldValueSetter[0];
        private final Field field;
        private final IOpenField openField;

        private SpreadsheetResultFieldValueSetter(Field field, IOpenField openField) {
            this.field = Objects.requireNonNull(field);
            this.openField = Objects.requireNonNull(openField);
            this.field.setAccessible(true);
        }

        public boolean setToBean(SpreadsheetResult spreadsheetResult, Object target, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
            if (!spreadsheetResult.isFieldUsedInModel(this.openField.getName())) {
                return false;
            }
            Object v = this.openField.get((Object)spreadsheetResult, null);
            try {
                if (v != null) {
                    Object cv = SpreadsheetResult.convertSpreadsheetResult(v, this.field.getType(), this.openField.getType(), spreadsheetResultBeanPropertyNamingStrategy);
                    this.field.set(target, cv);
                    return true;
                }
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(SpreadsheetResultFieldValueSetter.class).debug("Ignored error: ", (Throwable)e);
            }
            return false;
        }

        public boolean setToSpr(SpreadsheetResult spreadsheetResult, Object target, Map<Class<?>, CustomSpreadsheetResultOpenClass> mapClassToSprOpenClass) {
            try {
                Object v = this.field.get(target);
                Object cv = SpreadsheetResult.convertBeansToSpreadsheetResults(v, mapClassToSprOpenClass);
                this.openField.set((Object)spreadsheetResult, cv, null);
                return true;
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(SpreadsheetResultFieldValueSetter.class).debug("Ignored error: ", (Throwable)e);
                return false;
            }
        }
    }

    private static final class SpreadsheetResultValueSetter
    implements SpreadsheetResultSetter {
        private final SpreadsheetResultFieldValueSetter[] spreadsheetResultFieldValueSetters;

        private SpreadsheetResultValueSetter(SpreadsheetResultFieldValueSetter[] spreadsheetResultFieldValueSetters) {
            this.spreadsheetResultFieldValueSetters = Objects.requireNonNull(spreadsheetResultFieldValueSetters);
        }

        @Override
        public void setToBean(SpreadsheetResult spreadsheetResult, Object target, SpreadsheetResultBeanPropertyNamingStrategy spreadsheetResultBeanPropertyNamingStrategy) {
            for (SpreadsheetResultFieldValueSetter valueSetter : this.spreadsheetResultFieldValueSetters) {
                if (!valueSetter.setToBean(spreadsheetResult, target, spreadsheetResultBeanPropertyNamingStrategy)) continue;
                return;
            }
        }

        @Override
        public void setToSpr(SpreadsheetResult spreadsheetResult, Object target, Map<Class<?>, CustomSpreadsheetResultOpenClass> mapClassToSpr) {
            for (SpreadsheetResultFieldValueSetter valueSetter : this.spreadsheetResultFieldValueSetters) {
                if (!valueSetter.setToSpr(spreadsheetResult, target, mapClassToSpr)) continue;
                return;
            }
        }
    }

    private static interface SpreadsheetResultSetter {
        public static final SpreadsheetResultSetter[] EMPTY_ARRAY = new SpreadsheetResultSetter[0];

        public void setToBean(SpreadsheetResult var1, Object var2, SpreadsheetResultBeanPropertyNamingStrategy var3);

        default public void setToSpr(SpreadsheetResult spreadsheetResult, Object target, Map<Class<?>, CustomSpreadsheetResultOpenClass> mapClassToSpr) {
        }
    }
}

