/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.text.DecimalFormat;
import org.openl.rules.convertor.String2NumberConverter;

abstract class String2IntegersConvertor<T extends Number>
extends String2NumberConverter<T> {
    private final long min;
    private final long max;

    String2IntegersConvertor(long min, long max) {
        this.min = min;
        this.max = max;
    }

    @Override
    final T convert(Number number, String data) {
        long dValue;
        if (!(number instanceof Long)) {
            this.throwException(number);
        }
        if ((dValue = number.longValue()) > this.max || dValue < this.min) {
            this.throwException(number);
        }
        return this.toNumber(dValue);
    }

    private void throwException(Number number) {
        throw new NumberFormatException(String.format("The number '%s' is out of the range [%s]", number, this.min + "...+" + this.max));
    }

    abstract T toNumber(long var1);

    @Override
    final DecimalFormat getFormatter(String format) {
        DecimalFormat formatter = super.getFormatter(format);
        formatter.setParseIntegerOnly(true);
        return formatter;
    }
}

