/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openl.exception.OpenLRuntimeException;
import org.openl.types.IOpenClass;
import org.openl.types.impl.AOpenField;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public class DatatypeOpenField
extends AOpenField {
    private volatile byte flag;
    private volatile Method getter;
    private volatile Method setter;
    private final boolean isTransient;
    private final IOpenClass declaringClass;
    private final String contextProperty;

    public DatatypeOpenField(IOpenClass declaringClass, String name, IOpenClass type, String contextProperty, boolean isTransient) {
        super(name, type);
        this.declaringClass = declaringClass;
        this.contextProperty = contextProperty;
        this.isTransient = isTransient;
    }

    public IOpenClass getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isContextProperty() {
        return this.contextProperty != null;
    }

    public String getContextProperty() {
        return this.contextProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMethods() {
        if (this.flag == 0) {
            DatatypeOpenField datatypeOpenField = this;
            synchronized (datatypeOpenField) {
                if (this.flag == 0) {
                    Class instanceClass = this.declaringClass.getInstanceClass();
                    String name = ClassUtils.capitalize((String)this.getName());
                    try {
                        this.getter = instanceClass.getMethod("get" + name, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        name = StringUtils.capitalize((String)this.getName());
                        try {
                            this.getter = instanceClass.getMethod("get" + name, new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    try {
                        Class type = this.getType().getInstanceClass();
                        this.setter = instanceClass.getMethod("set" + name, type);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    this.flag = 1;
                }
            }
        }
    }

    public Method getGetter() {
        this.initMethods();
        return this.getter;
    }

    public Method getSetter() {
        this.initMethods();
        return this.setter;
    }

    public Object get(Object target, IRuntimeEnv env) {
        if (target == null) {
            return null;
        }
        try {
            Object res = this.getGetter().invoke(target, new Object[0]);
            return res != null ? res : this.getType().nullObject();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new OpenLRuntimeException((Throwable)e);
        }
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isWritable() {
        return true;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        this.initMethods();
        if (target != null) {
            try {
                this.setter.invoke(target, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new OpenLRuntimeException((Throwable)e);
            }
        }
    }
}

