/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.rules.calc.SpreadsheetBoundNode;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.AMethodMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReaderUtils;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.ICell;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.OpenClassUtils;

public class SpreadsheetMetaInfoReader
extends AMethodMetaInfoReader<SpreadsheetBoundNode> {
    private final Map<CellKey, CellMetaInfo> headerMetaInfo = new HashMap<CellKey, CellMetaInfo>();

    public SpreadsheetMetaInfoReader(SpreadsheetBoundNode boundNode) {
        super(boundNode);
    }

    @Override
    public CellMetaInfo getBodyMetaInfo(int row, int col) {
        SpreadsheetCell[][] cells = ((SpreadsheetBoundNode)((Object)this.getBoundNode())).getCells();
        if (cells == null || cells.length == 0 || cells[0].length == 0) {
            return null;
        }
        ICell firstCell = cells[0][0].getSourceCell();
        int r = row - firstCell.getAbsoluteRow();
        int c = col - firstCell.getAbsoluteColumn();
        if (r < 0 || c < 0) {
            return this.headerMetaInfo.get(CellKey.CellKeyFactory.getCellKey(col, row));
        }
        SpreadsheetCell spreadsheetCell = this.findCell(cells, row, col);
        if (spreadsheetCell == null || spreadsheetCell.isEmpty()) {
            return null;
        }
        ICell sourceCell = spreadsheetCell.getSourceCell();
        IOpenClass type = spreadsheetCell.getType();
        String stringValue = sourceCell.getStringValue();
        if (stringValue != null) {
            ArrayList<NodeUsage> nodeUsages = null;
            int from = -1;
            if (stringValue.startsWith("=")) {
                nodeUsages = new ArrayList<NodeUsage>();
                from = 0;
                if (type != null) {
                    String description = "Cell type: " + MethodUtil.printType((IOpenClass)type);
                    nodeUsages.add(new SimpleNodeUsage(from, from + 1, description, null, NodeType.OTHER));
                }
            } else if (stringValue.startsWith("{") && stringValue.endsWith("}")) {
                nodeUsages = new ArrayList();
                from = 0;
            }
            IOpenMethod method = spreadsheetCell.getMethod();
            if (from > -1) {
                ++from;
                if (method instanceof CompositeMethod) {
                    List<NodeUsage> parsedNodeUsages = MetaInfoReaderUtils.getNodeUsages((CompositeMethod)method, stringValue, from);
                    nodeUsages.addAll(parsedNodeUsages);
                }
            }
            boolean isRet = spreadsheetCell.isReturnCell();
            if (method == null && type != null) {
                boolean multiValue = type.isArray();
                if (multiValue) {
                    type = OpenClassUtils.getRootComponentClass((IOpenClass)type);
                }
                return new CellMetaInfo(type, multiValue, nodeUsages, isRet);
            }
            return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages, isRet);
        }
        return null;
    }

    public void addHeaderMetaInfo(int row, int col, CellMetaInfo metaInfo) {
        this.headerMetaInfo.put(CellKey.CellKeyFactory.getCellKey(col, row), metaInfo);
    }

    private SpreadsheetCell findCell(SpreadsheetCell[][] cells, int row, int col) {
        SpreadsheetCell spreadsheetCell;
        ICell sourceCell;
        ICell firstCell = cells[0][0].getSourceCell();
        int r = row - firstCell.getAbsoluteRow();
        int c = col - firstCell.getAbsoluteColumn();
        if (r >= cells.length) {
            r = cells.length - 1;
        }
        if (c >= cells[0].length) {
            c = cells[0].length - 1;
        }
        if ((sourceCell = (spreadsheetCell = cells[r][c]).getSourceCell()).getAbsoluteRow() == row && sourceCell.getAbsoluteColumn() == col) {
            return spreadsheetCell;
        }
        while (col < sourceCell.getAbsoluteColumn() && c > 0) {
            spreadsheetCell = cells[r][--c];
            sourceCell = spreadsheetCell.getSourceCell();
        }
        while (row < sourceCell.getAbsoluteRow() && r > 0) {
            spreadsheetCell = cells[--r][c];
            sourceCell = spreadsheetCell.getSourceCell();
        }
        if (sourceCell.getAbsoluteRow() == row && sourceCell.getAbsoluteColumn() == col) {
            return spreadsheetCell;
        }
        return null;
    }
}

