/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.property;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.PropertyTableMetaInfoReader;
import org.openl.rules.property.PropertyTableBoundNode;
import org.openl.rules.property.exception.DuplicatedPropertiesTableException;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.TableNameChecker;

public class PropertyTableBinder
extends DataNodeBinder {
    private static final String DEFAULT_TABLE_NAME_PREFIX = "InheritedProperties: ";
    private static final String SCOPE_PROPERTY_NAME = "scope";

    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tsn, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        PropertyTableBoundNode propertyNode = (PropertyTableBoundNode)this.makeNode(tsn, module, bindingContext);
        IdentifierNode identifierNode = this.parseHeader(tsn);
        Object tableName = identifierNode == null ? null : identifierNode.getIdentifier();
        propertyNode.setTableName((String)tableName);
        if (identifierNode == null) {
            tableName = DEFAULT_TABLE_NAME_PREFIX + tsn.getUri();
        } else {
            tableName = identifierNode.getIdentifier();
            if (TableNameChecker.isInvalidJavaIdentifier((String)tableName)) {
                String message = String.format("%s '%s' name error. Name can only have letters, digits, _, $ and should not start with a digit.", "Property table", tableName);
                bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)message, (ISyntaxNode)identifierNode));
            }
        }
        ITable propertyTable = module.getDataBase().registerTable((String)tableName, tsn);
        JavaOpenClass propertiesClass = JavaOpenClass.getOpenClass(TableProperties.class);
        ILogicalTable propTableBody = this.getTableBody(tsn);
        this.processTable(module, propertyTable, propTableBody, (String)tableName, (IOpenClass)propertiesClass, (IBindingContext)bindingContext, openl, false);
        TableProperties propertiesInstance = ((TableProperties[])propertyTable.getDataArray())[0];
        propertiesInstance.setPropertiesSection((ILogicalTable)tsn.getTable().getRows(1));
        propertiesInstance.setCurrentTableType(tsn.getType());
        PropertiesChecker.checkProperties((IBindingContext)bindingContext, propertiesInstance.getAllProperties().keySet(), tsn, InheritanceLevel.getEnumByValue(propertiesInstance.getPropertyValueAsString(SCOPE_PROPERTY_NAME)));
        tsn.setTableProperties(propertiesInstance);
        this.analysePropertiesNode(tsn, propertiesInstance, bindingContext);
        propertyNode.setPropertiesInstance(propertiesInstance);
        return propertyNode;
    }

    private IdentifierNode parseHeader(TableSyntaxNode tsn) throws Exception {
        IOpenSourceCodeModule src = tsn.getHeader().getModule();
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)src, (String)" \n\r");
        if (parsedHeader.length > 1) {
            return parsedHeader[1];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void analysePropertiesNode(TableSyntaxNode tableSyntaxNode, TableProperties propertiesInstance, RulesModuleBindingContext bindingContext) throws SyntaxNodeException {
        String scope = propertiesInstance.getScope();
        if (scope == null) {
            String message = String.format("There is no obligatory property '%s'.", SCOPE_PROPERTY_NAME);
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
        }
        if (this.isModuleProperties(scope)) {
            this.processModuleProperties(tableSyntaxNode, bindingContext);
            return;
        }
        if (this.isCategoryProperties(scope)) {
            this.processCategoryProperties(tableSyntaxNode, propertiesInstance, bindingContext);
            return;
        }
        if (this.isGlobalProperties(scope)) {
            this.processGlobalProperties(tableSyntaxNode, bindingContext);
            return;
        }
        String message = String.format("Value of the property '%s' is neither '%s', '%s' or '%s'.", SCOPE_PROPERTY_NAME, InheritanceLevel.GLOBAL.getDisplayName(), InheritanceLevel.MODULE.getDisplayName(), InheritanceLevel.CATEGORY.getDisplayName());
        throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
    }

    private void processCategoryProperties(TableSyntaxNode tableSyntaxNode, TableProperties propertiesInstance, RulesModuleBindingContext bindingContext) throws SyntaxNodeException {
        String category = this.getCategoryToApplyProperties(tableSyntaxNode, propertiesInstance);
        String key = "Properties:Category:" + category;
        if (bindingContext.isTableSyntaxNodePresented(key)) {
            String message = String.format("Properties for category '%s' already exists.", category);
            throw new DuplicatedPropertiesTableException(message, null, (ISyntaxNode)tableSyntaxNode);
        }
        bindingContext.registerTableSyntaxNode(key, tableSyntaxNode);
    }

    private void processGlobalProperties(TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext bindingContext) throws SyntaxNodeException {
        String key = "Properties:Global";
        if (bindingContext.isTableSyntaxNodePresented(key)) {
            throw new DuplicatedPropertiesTableException("Global properties already exist.", null, (ISyntaxNode)tableSyntaxNode);
        }
        bindingContext.registerTableSyntaxNode(key, tableSyntaxNode);
    }

    private void processModuleProperties(TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext bindingContext) throws SyntaxNodeException {
        String key = "Properties:Module";
        if (bindingContext.isTableSyntaxNodePresented(key)) {
            XlsWorkbookSourceCodeModule module = ((XlsSheetSourceCodeModule)tableSyntaxNode.getModule()).getWorkbookSource();
            String moduleName = module.getDisplayName();
            String message = String.format("Properties for module '%s' already exists", moduleName);
            throw new DuplicatedPropertiesTableException(message, null, (ISyntaxNode)tableSyntaxNode);
        }
        bindingContext.registerTableSyntaxNode(key, tableSyntaxNode);
    }

    private String getCategoryToApplyProperties(TableSyntaxNode tsn, TableProperties properties) {
        String category = properties.getCategory();
        if (category != null) {
            return category;
        }
        return ((XlsSheetSourceCodeModule)tsn.getModule()).getSheetName();
    }

    private boolean isModuleProperties(String scope) {
        return InheritanceLevel.MODULE.getDisplayName().equals(scope);
    }

    private boolean isCategoryProperties(String scope) {
        return InheritanceLevel.CATEGORY.getDisplayName().equals(scope);
    }

    private boolean isGlobalProperties(String scope) {
        return InheritanceLevel.GLOBAL.getDisplayName().equals(scope);
    }

    @Override
    protected ATableBoundNode makeNode(TableSyntaxNode tsn, XlsModuleOpenClass module, RulesModuleBindingContext bindingContext) {
        PropertyTableBoundNode boundNode = new PropertyTableBoundNode(tsn);
        if (!bindingContext.isExecutionMode()) {
            tsn.setMetaInfoReader(new PropertyTableMetaInfoReader(boundNode));
        }
        return boundNode;
    }
}

