/*
 * Decompiled with CFR 0.152.
 */
package org.openl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.MethodUsage;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.Point;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

public final class OpenL2TextUtils {
    private OpenL2TextUtils() {
    }

    public static String methodToString(ExecutableRulesMethod rulesMethod, boolean replaceAliasesWithBaseTypes, boolean tableAsCode, boolean onlyMethodCells, int maxRows) {
        if (rulesMethod instanceof Spreadsheet) {
            return OpenL2TextUtils.spreadsheetToString((Spreadsheet)rulesMethod, replaceAliasesWithBaseTypes, tableAsCode, onlyMethodCells);
        }
        if (rulesMethod instanceof DecisionTable) {
            DecisionTable decisionTable = (DecisionTable)rulesMethod;
            return OpenL2TextUtils.tableSyntaxNodeToString(decisionTable.getSyntaxNode(), decisionTable.getDtInfo() != null && decisionTable.getDtInfo().isTransposed(), replaceAliasesWithBaseTypes, maxRows);
        }
        return OpenL2TextUtils.tableSyntaxNodeToString(rulesMethod.getSyntaxNode(), false, replaceAliasesWithBaseTypes, Integer.MAX_VALUE);
    }

    private static String cellToString(ICell cell, MetaInfoReader metaInfoReader, boolean replaceAliasesWithBaseTypes) {
        CellMetaInfo cellMetaInfo;
        Object cellValue = cell.getStringValue();
        if (metaInfoReader != null && replaceAliasesWithBaseTypes && (cellMetaInfo = metaInfoReader.getMetaInfo(cell.getAbsoluteRow(), cell.getAbsoluteColumn())) != null && cellMetaInfo.getUsedNodes() != null) {
            ArrayList<? extends NodeUsage> usedNodes = new ArrayList<NodeUsage>(cellMetaInfo.getUsedNodes());
            usedNodes.sort(Comparator.comparing(NodeUsage::getStart).reversed());
            for (NodeUsage nodeUsage : usedNodes) {
                SimpleNodeUsage simpleNodeUsage;
                if (!(nodeUsage instanceof SimpleNodeUsage) || !((simpleNodeUsage = (SimpleNodeUsage)nodeUsage).getType() instanceof DomainOpenClass)) continue;
                cellValue = ((String)cellValue).substring(0, simpleNodeUsage.getStart()) + OpenL2TextUtils.openClassToName(((DomainOpenClass)simpleNodeUsage.getType()).getBaseClass()) + ((String)cellValue).substring(simpleNodeUsage.getEnd());
            }
        }
        cellValue = OpenL2TextUtils.resolveProblemsWithParsing((String)cellValue);
        return cellValue;
    }

    private static String formulaToExp(String formula) {
        if ((formula = formula.trim()).startsWith("=")) {
            formula = formula.substring(1);
        }
        if (formula.trim().isEmpty()) {
            formula = "null";
        }
        return formula.trim();
    }

    private static Set<String> findFieldNames(Map<String, Point> fieldsCoordinates, int row, int column) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Map.Entry<String, Point> e : fieldsCoordinates.entrySet()) {
            Point p = e.getValue();
            if (p.getRow() != row || p.getColumn() != column) continue;
            fieldNames.add(e.getKey());
        }
        return fieldNames;
    }

    public static String spreadsheetToString(Spreadsheet spreadsheet, boolean replaceAliasesWithBaseTypes, boolean tableAsCode, boolean onlyMethodCells) {
        int j;
        Function<ICell, String> cellToStr = cell -> OpenL2TextUtils.cellToString(cell, spreadsheet.getSyntaxNode().getMetaInfoReader(), replaceAliasesWithBaseTypes);
        StringBuilder sb = new StringBuilder();
        if (!tableAsCode) {
            sb.append("|");
        }
        sb.append(cellToStr.apply(spreadsheet.getSyntaxNode().getTable().getSource().getCell(0, 0)));
        if (!tableAsCode) {
            sb.append("|".repeat(spreadsheet.getColumnNames().length)).append("\n");
            sb.append("|").append("Steps");
            for (int i = 0; i < spreadsheet.getColumnNames().length; ++i) {
                sb.append("|").append(spreadsheet.getColumnNames()[i]).append("|");
            }
        }
        sb.append("\n");
        if (tableAsCode) {
            for (j = 0; j < spreadsheet.getRowNames().length; ++j) {
                for (int i = 0; i < spreadsheet.getColumnNames().length; ++i) {
                    boolean isString;
                    Set<Object> fieldNames;
                    SpreadsheetCell spreadsheetCell = spreadsheet.getCells()[j][i];
                    if ((!spreadsheetCell.isMethodCell() || NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{spreadsheetCell.getType()})) && onlyMethodCells) continue;
                    if (spreadsheetCell.isMethodCell()) {
                        sb.append(OpenL2TextUtils.openClassToName(spreadsheetCell.getType()));
                    } else {
                        sb.append("var");
                    }
                    Set<Object> set = fieldNames = spreadsheet.getColumnNames().length > 1 ? OpenL2TextUtils.findFieldNames(spreadsheet.getFieldsCoordinates(), j, i) : Collections.singleton("$" + spreadsheet.getRowNames()[j]);
                    if (!fieldNames.isEmpty()) {
                        sb.append(" ").append(String.join((CharSequence)", ", fieldNames));
                    }
                    sb.append(" = ");
                    boolean bl = isString = spreadsheetCell.isValueCell() && JavaOpenClass.STRING.equals((Object)spreadsheetCell.getType());
                    if (isString) {
                        sb.append("\"");
                    }
                    sb.append(OpenL2TextUtils.formulaToExp(cellToStr.apply(spreadsheetCell.getSourceCell())));
                    if (isString) {
                        sb.append("\"");
                    }
                    if (sb.charAt(sb.length() - 1) != ';') {
                        sb.append(";");
                    }
                    sb.append("\n");
                }
            }
        } else {
            for (j = 0; j < spreadsheet.getRowNames().length; ++j) {
                sb.append("|").append(spreadsheet.getRowNames()[j]).append("|");
                for (int i = 0; i < spreadsheet.getColumnNames().length; ++i) {
                    String cellValue = cellToStr.apply(spreadsheet.getCells()[j][i].getSourceCell());
                    sb.append(cellValue).append("|");
                }
                if (j >= spreadsheet.getRowNames().length - 1) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String tableSyntaxNodeToString(TableSyntaxNode tableSyntaxNode, boolean transposeBody, boolean replaceAliasesWithBaseTypes, int maxRows) {
        Function<ICell, String> cellToStr = cell -> OpenL2TextUtils.cellToString(cell, tableSyntaxNode.getMetaInfoReader(), replaceAliasesWithBaseTypes);
        StringBuilder sb = new StringBuilder();
        IGridTable table = tableSyntaxNode.getTable().getSource();
        int height = table.getHeight();
        int width = table.getWidth();
        sb.append("|").append(cellToStr.apply(table.getCell(0, 0)));
        int d = table.getCell(0, 0).getHeight();
        if (d >= height) {
            sb.append("|".repeat(width)).append("\n");
            return sb.toString();
        }
        if (table.getCell(0, d).getStringValue() != null && "properties".equalsIgnoreCase(table.getCell(0, d).getStringValue().trim())) {
            d += table.getCell(0, d).getHeight();
        }
        if ((table = (IGridTable)table.getSubtable(0, d, width, height - d)) == null) {
            sb.append("|".repeat(width)).append("\n");
            return sb.toString();
        }
        height = table.getHeight();
        if (transposeBody) {
            table = (IGridTable)table.transpose();
            height = table.getHeight();
            width = table.getWidth();
        }
        sb.append("|".repeat(width)).append("\n");
        for (int i = 0; i < height; ++i) {
            if (i >= maxRows) {
                sb.append("...").append("\n");
                break;
            }
            sb.append("|");
            for (int j = 0; j < width; ++j) {
                String cellValue = cellToStr.apply(table.getCell(j, i));
                sb.append(cellValue);
                sb.append("|");
            }
            if (i >= height - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String openClassToName(IOpenClass openClass) {
        return openClass.getDisplayName(0);
    }

    public static String openClassToString(IOpenClass openClass, boolean replaceAliasesWithBaseTypes) {
        StringBuilder sb = new StringBuilder();
        if (openClass instanceof DomainOpenClass) {
            if (replaceAliasesWithBaseTypes) {
                return OpenL2TextUtils.openClassToName(((DomainOpenClass)openClass).getBaseClass());
            }
            DomainOpenClass domainOpenClass = (DomainOpenClass)openClass;
            sb.append("vocabulary ").append(OpenL2TextUtils.openClassToName((IOpenClass)domainOpenClass)).append(" : ").append(OpenL2TextUtils.openClassToName(domainOpenClass.getBaseClass())).append(" {").append("\n");
            Iterator itr = domainOpenClass.getDomain().iterator();
            while (itr.hasNext()) {
                sb.append("\t");
                if (JavaOpenClass.STRING.equals((Object)domainOpenClass.getBaseClass())) {
                    sb.append("\"");
                }
                sb.append(itr.next());
                if (JavaOpenClass.STRING.equals((Object)domainOpenClass.getBaseClass())) {
                    sb.append("\"");
                }
                if (itr.hasNext()) {
                    sb.append(", ");
                }
                sb.append("\n");
            }
            sb.append("}");
        } else {
            sb.append("class ").append(OpenL2TextUtils.openClassToName(openClass)).append(" {").append("\n");
            for (IOpenField openField : openClass.getFields()) {
                IOpenClass type = openField.getType();
                if (type instanceof DomainOpenClass) {
                    type = ((DomainOpenClass)type).getBaseClass();
                }
                sb.append("\t").append(OpenL2TextUtils.openClassToName(type)).append(" ").append(openField.getName()).append(";\n");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public static Map<String, Object> dimensionalPropertiesToString(ExecutableRulesMethod rulesMethod) {
        if (rulesMethod.getMethodProperties() != null && !rulesMethod.getMethodProperties().getAllDimensionalProperties().isEmpty()) {
            HashMap<String, Object> props = new HashMap<String, Object>(rulesMethod.getMethodProperties().getAllDimensionalProperties());
            if (props.containsKey("state")) {
                UsStatesEnum[] states = (UsStatesEnum[])props.get("state");
                props.put("state", Arrays.stream(states).map(UsStatesEnum::toString).toArray());
            }
            return props;
        }
        return null;
    }

    public static Set<IOpenMethod> methodRefs(TableSyntaxNode tableSyntaxNode) {
        HashSet<IOpenMethod> methodRefs = new HashSet<IOpenMethod>();
        MetaInfoReader metaInfoReader = tableSyntaxNode.getMetaInfoReader();
        if (metaInfoReader != null) {
            int height = tableSyntaxNode.getTable().getSource().getHeight();
            int width = tableSyntaxNode.getTable().getSource().getWidth();
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    ICell cell = tableSyntaxNode.getTable().getSource().getCell(j, i);
                    CellMetaInfo cellMetaInfo = metaInfoReader.getMetaInfo(cell.getAbsoluteRow(), cell.getAbsoluteColumn());
                    if (cellMetaInfo == null || cellMetaInfo.getUsedNodes() == null) continue;
                    for (NodeUsage nodeUsage : cellMetaInfo.getUsedNodes()) {
                        if (!(nodeUsage instanceof MethodUsage)) continue;
                        methodRefs.add(((MethodUsage)nodeUsage).getMethod());
                    }
                }
            }
        }
        return methodRefs;
    }

    public static Set<IOpenClass> methodTypes(TableSyntaxNode tableSyntaxNode) {
        HashSet<IOpenClass> types = new HashSet<IOpenClass>();
        MetaInfoReader metaInfoReader = tableSyntaxNode.getMetaInfoReader();
        if (metaInfoReader != null) {
            int height = tableSyntaxNode.getTable().getSource().getHeight();
            int width = tableSyntaxNode.getTable().getSource().getWidth();
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    ICell cell = tableSyntaxNode.getTable().getSource().getCell(j, i);
                    CellMetaInfo cellMetaInfo = metaInfoReader.getMetaInfo(cell.getAbsoluteRow(), cell.getAbsoluteColumn());
                    if (cellMetaInfo == null || cellMetaInfo.getUsedNodes() == null) continue;
                    for (NodeUsage nodeUsage : cellMetaInfo.getUsedNodes()) {
                        SimpleNodeUsage simpleNodeUsage;
                        if (!(nodeUsage instanceof SimpleNodeUsage) || (simpleNodeUsage = (SimpleNodeUsage)nodeUsage).getType() == null) continue;
                        types.add(simpleNodeUsage.getType());
                    }
                }
            }
        }
        return types;
    }

    private static String resolveProblemsWithParsing(String cellValue) {
        if (cellValue == null) {
            return "";
        }
        cellValue = cellValue.trim();
        if ((cellValue = cellValue.replaceAll("\n", ";")).startsWith("=")) {
            return cellValue.replaceAll("\\|\\|", "or");
        }
        if (cellValue.contains("|")) {
            return "\"" + cellValue.replaceAll("\"", "\\\\\"");
        }
        return cellValue;
    }

    public static void collectTypes(IOpenClass type, Set<IOpenClass> container, int maxDepth, boolean replaceAliasesWithBaseTypes) {
        OpenL2TextUtils.collectTypes(type, container, 0, maxDepth, replaceAliasesWithBaseTypes);
    }

    private static void collectTypes(IOpenClass type, Set<IOpenClass> container, int depth, int maxDepth, boolean replaceAliasesWithBaseTypes) {
        if (depth > maxDepth) {
            return;
        }
        while (type.isArray()) {
            type = type.getComponentClass();
        }
        if (container.contains(type)) {
            return;
        }
        if (NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{type})) {
            return;
        }
        try {
            type.getFields();
        }
        catch (LinkageError ignored) {
            return;
        }
        if (!(type instanceof DomainOpenClass)) {
            String className;
            if (type.getInstanceClass() != null && type.getInstanceClass().isPrimitive()) {
                return;
            }
            String string = className = type.getInstanceClass() != null ? type.getInstanceClass().getName() : type.getName();
            if (className.startsWith("java.lang.") || className.startsWith("java.util.") || className.startsWith("java.math.")) {
                return;
            }
            if (type.getFields().isEmpty()) {
                return;
            }
        }
        if (type instanceof DomainOpenClass && replaceAliasesWithBaseTypes) {
            return;
        }
        container.add(type);
        for (IOpenField openField : type.getFields()) {
            OpenL2TextUtils.collectTypes(openField.getType(), container, depth + 1, maxDepth, replaceAliasesWithBaseTypes);
        }
    }

    private static String typeToString(IOpenClass openClass, boolean replaceAliasesWithBaseTypes) {
        IOpenClass t = openClass;
        if (replaceAliasesWithBaseTypes && t instanceof DomainOpenClass) {
            t = ((DomainOpenClass)t).getBaseClass();
        }
        return OpenL2TextUtils.openClassToName(t);
    }

    public static String methodHeaderToString(IOpenMethod method, boolean replaceAliasesWithBaseTypes) {
        StringBuilder sb1 = new StringBuilder();
        sb1.append(OpenL2TextUtils.typeToString(method.getType(), replaceAliasesWithBaseTypes)).append(" ");
        MethodUtil.printMethod((IOpenMethodHeader)method, (StringBuilder)sb1, e -> OpenL2TextUtils.typeToString(e, replaceAliasesWithBaseTypes));
        return sb1.toString();
    }
}

