/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.sax;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.SharedFormula;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.openl.excel.parser.sax.SAXFormulaParsingWorkbook;
import org.openl.rules.table.IGridRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class StyleIndexHandler
extends DefaultHandler {
    private final Logger log = LoggerFactory.getLogger(StyleIndexHandler.class);
    private final IGridRegion tableRegion;
    private final int[][] cellIndexes;
    private final Map<CellAddress, String> formulas = new HashMap<CellAddress, String>();
    private final int sheetIndex;
    private CellAddress current;
    private boolean readFormula;
    private final StringBuilder formula = new StringBuilder();
    private final Map<String, SharedFormulaDefinition> sharedFormulas = new HashMap<String, SharedFormulaDefinition>();
    private String sharedFormulaIndex;
    private String sharedFormulaRef;
    private final SAXFormulaParsingWorkbook formulaParsingWorkbook;

    public StyleIndexHandler(IGridRegion tableRegion, int sheetIndex) {
        this.tableRegion = tableRegion;
        this.cellIndexes = new int[IGridRegion.Tool.height(tableRegion)][IGridRegion.Tool.width(tableRegion)];
        this.sheetIndex = sheetIndex;
        this.formulaParsingWorkbook = new SAXFormulaParsingWorkbook();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("c".equals(localName)) {
            String cellRef = attributes.getValue("r");
            this.current = new CellAddress(cellRef);
            if (IGridRegion.Tool.contains(this.tableRegion, this.current.getColumn(), this.current.getRow())) {
                String cellStyleStr = attributes.getValue("s");
                int styleIndex = cellStyleStr != null ? Integer.parseInt(cellStyleStr) : 0;
                int internalRow = this.current.getRow() - this.tableRegion.getTop();
                int internalCol = this.current.getColumn() - this.tableRegion.getLeft();
                this.cellIndexes[internalRow][internalCol] = styleIndex;
            }
        } else if ("f".equals(localName)) {
            this.sharedFormulaIndex = attributes.getValue("si");
            this.sharedFormulaRef = attributes.getValue("ref");
            if (IGridRegion.Tool.contains(this.tableRegion, this.current.getColumn(), this.current.getRow()) || this.sharedFormulaIndex != null && this.sharedFormulaRef != null) {
                this.readFormula = true;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.readFormula) {
            this.formula.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("f".equals(localName)) {
            this.readFormula = false;
            if (this.sharedFormulaIndex != null && this.sharedFormulaRef != null) {
                this.sharedFormulas.put(this.sharedFormulaIndex, new SharedFormulaDefinition(this.formula.toString(), this.sharedFormulaRef));
            }
            if (IGridRegion.Tool.contains(this.tableRegion, this.current.getColumn(), this.current.getRow())) {
                try {
                    String value = this.formula.toString();
                    if (this.sharedFormulaIndex != null && this.sharedFormulaRef == null) {
                        value = this.convertSharedFormula(this.sharedFormulas.get(this.sharedFormulaIndex));
                    }
                    this.formulas.put(this.current, value);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            this.formula.setLength(0);
        }
    }

    public int[][] getCellIndexes() {
        return this.cellIndexes;
    }

    public Map<CellAddress, String> getFormulas() {
        return this.formulas;
    }

    private String convertSharedFormula(SharedFormulaDefinition formulaDefinition) {
        CellRangeAddress ref = CellRangeAddress.valueOf((String)formulaDefinition.getRef());
        SharedFormula sf = new SharedFormula(SpreadsheetVersion.EXCEL2007);
        Ptg[] parsedTokens = FormulaParser.parse((String)formulaDefinition.getValue(), (FormulaParsingWorkbook)this.formulaParsingWorkbook, (FormulaType)FormulaType.CELL, (int)this.sheetIndex, (int)this.current.getRow());
        Ptg[] convertedTokens = sf.convertSharedFormulas(parsedTokens, this.current.getRow() - ref.getFirstRow(), this.current.getColumn() - ref.getFirstColumn());
        return FormulaRenderer.toFormulaString(null, (Ptg[])convertedTokens);
    }

    private static class SharedFormulaDefinition {
        private final String value;
        private final String ref;

        private SharedFormulaDefinition(String value, String ref) {
            this.value = value;
            this.ref = ref;
        }

        public String getValue() {
            return this.value;
        }

        public String getRef() {
            return this.ref;
        }
    }
}

