/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.Objects;
import org.openl.rules.binding.RecursiveSpreadsheetMethodPreBindingException;
import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.IOriginalDeclaredClassesOpenField;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class CustomSpreadsheetResultField
extends ASpreadsheetField
implements IOriginalDeclaredClassesOpenField {
    protected IOpenField field;
    private final IOpenClass[] declaringClasses;

    public CustomSpreadsheetResultField(CustomSpreadsheetResultOpenClass declaringClass, IOpenField field) {
        super((IOpenClass)declaringClass, field.getName(), null);
        this.field = Objects.requireNonNull(field, "field cannot be null");
        this.declaringClasses = new IOpenClass[]{declaringClass};
    }

    public CustomSpreadsheetResultField(IOpenClass declaringClass, String name, IOpenClass type) {
        super(declaringClass, name, type);
        this.declaringClasses = new IOpenClass[]{declaringClass};
    }

    public Object get(Object target, IRuntimeEnv env) {
        if (this.field != null) {
            throw new IllegalStateException("Spreadsheet cell type is not resolved at compile time");
        }
        if (target == null) {
            return this.getType().nullObject();
        }
        Object res = ((SpreadsheetResult)target).getFieldValue(this.getName());
        return this.processResult(res);
    }

    public IOpenClass getType() {
        if (this.field != null) {
            try {
                this.setType(this.field.getType());
                this.field = null;
            }
            catch (RecursiveSpreadsheetMethodPreBindingException e) {
                return JavaOpenClass.OBJECT;
            }
        }
        return super.getType();
    }

    protected Object processResult(Object res) {
        return ((CustomSpreadsheetResultOpenClass)this.getDeclaringClass()).getModule().getObjectToDataOpenCastConvertor().convert(res, this.getType());
    }

    public boolean isWritable() {
        return true;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        if (target != null) {
            ((SpreadsheetResult)target).setFieldValue(this.getName(), value);
        }
    }

    @Override
    public IOpenClass[] getDeclaringClasses() {
        return this.declaringClasses;
    }
}

