/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cloner;

import java.lang.reflect.Array;
import java.util.function.Function;
import org.openl.rules.cloner.ICloner;

class ArrayCloner
implements ICloner<Object> {
    static final ICloner<Object> theInstance = new ArrayCloner();

    ArrayCloner() {
    }

    @Override
    public Object getInstance(Object source) {
        Class<?> componentType = source.getClass().getComponentType();
        int length = Array.getLength(source);
        return Array.newInstance(componentType, length);
    }

    @Override
    public void clone(Object o, Function<Object, Object> cloner, Object target) {
        int length = Array.getLength(target);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(o, i);
            Array.set(target, i, cloner.apply(element));
        }
    }
}

