/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cloner;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.openl.rules.cloner.ICloner;

class BeanCloner<T>
implements ICloner<T> {
    private final Map<String, GetSetter> fields = new HashMap<String, GetSetter>();

    BeanCloner(Class<T> clazz) {
        Field[] allFields;
        for (Field field : allFields = clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            this.fields.put(field.getName(), new FieldGetSetter(field));
        }
        try {
            PropertyDescriptor[] props;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor prop : props = beanInfo.getPropertyDescriptors()) {
                if (this.fields.containsKey(prop.getName())) continue;
                if (prop.getReadMethod() != null && prop.getWriteMethod() != null) {
                    this.fields.put(prop.getName(), new PropertyGetSetter(prop.getReadMethod(), prop.getWriteMethod()));
                    continue;
                }
                if (!"class".equals(prop.getName())) continue;
                try {
                    Method getter = clazz.getMethod("getClass", new Class[0]);
                    Class<?> returnType = getter.getReturnType();
                    if (Class.class.equals(returnType)) continue;
                    Method setter = clazz.getMethod("setClass", returnType);
                    this.fields.put(prop.getName(), new PropertyGetSetter(getter, setter));
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getInstance(Object source) {
        try {
            return source.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(source.getClass().getName() + " bean is non-public or haven't the default constructor.", e);
        }
    }

    @Override
    public void clone(T source, Function<Object, Object> cloner, T target) {
        for (GetSetter field : this.fields.values()) {
            try {
                Object fieldObject = field.get(source);
                Object res = cloner.apply(fieldObject);
                field.set(target, res);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class PropertyGetSetter
    implements GetSetter {
        private final Method getter;
        private final Method setter;

        public PropertyGetSetter(Method getter, Method setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void set(Object target, Object value) throws InvocationTargetException, IllegalAccessException {
            this.setter.invoke(target, value);
        }

        @Override
        public Object get(Object source) throws InvocationTargetException, IllegalAccessException {
            return this.getter.invoke(source, new Object[0]);
        }
    }

    static class FieldGetSetter
    implements GetSetter {
        private final Field field;

        public FieldGetSetter(Field field) {
            this.field = field;
        }

        @Override
        public void set(Object target, Object value) throws IllegalAccessException {
            this.field.set(target, value);
        }

        @Override
        public Object get(Object source) throws IllegalAccessException {
            return this.field.get(source);
        }
    }

    static interface GetSetter {
        public void set(Object var1, Object var2) throws InvocationTargetException, IllegalAccessException;

        public Object get(Object var1) throws InvocationTargetException, IllegalAccessException;
    }
}

