/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.MethodUtil;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.StringValue;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultField;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.data.CollectionElementWithMultiRowField;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.ForeignKeyColumnDescriptor;
import org.openl.rules.data.ITable;
import org.openl.rules.data.IdentifierNodesBucket;
import org.openl.rules.data.PrimaryKeyField;
import org.openl.rules.data.ThisCollectionElementField;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.testmethod.TestMethodOpenClass;
import org.openl.rules.testmethod.UserErrorOpenClass;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.AOpenField;
import org.openl.types.impl.CollectionElementField;
import org.openl.types.impl.CollectionType;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;
import org.openl.util.text.TextInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableBindHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DataTableBindHelper.class);
    private static final char INDEX_ROW_REFERENCE_START_SYMBOL = '>';
    private static final String FPK = "_PK_";
    static final String CONSTRUCTOR_FIELD = "this";
    private static final String CODE_DELIMETERS = ".\n\r";
    private static final String INDEX_ROW_REFERENCE_DELIMITER = " >\n\r";
    private static final String LINK_DELIMETERS = ".";
    public static final Pattern COLLECTION_ACCESS_BY_INDEX_PATTERN = Pattern.compile("\\s*[^\\:\\s\\[\\]]+\\s*\\[\\s*[0-9]+\\s*\\]\\s*(\\:\\s*[^\\:\\s]+|)\\s*$");
    public static final Pattern COLLECTION_ACCESS_BY_KEY_PATTERN = Pattern.compile("\\s*[^\\:\\s\\[\\]]+\\s*\\[\\s*(\\\".*\\\"|[0-9]+)\\s*\\]\\s*(\\:\\s*[^\\:\\s]+|)\\s*$");
    static final Pattern THIS_ARRAY_ACCESS_PATTERN = Pattern.compile("\\s*\\[\\s*[0-9]+\\s*\\]\\s*$");
    static final Pattern THIS_LIST_ACCESS_PATTERN = Pattern.compile("\\s*\\[\\s*[0-9]+\\s*\\]\\s*(\\:\\s*[^\\:]+|)$");
    static final Pattern THIS_MAP_ACCESS_PATTERN = Pattern.compile("\\s*\\[\\s*(\\\".*\\\"|[0-9]+)\\s*\\]\\s*(\\:\\s*[^\\:\\s]+|)\\s*$");
    public static final Pattern PRECISION_PATTERN = Pattern.compile("^\\(\\-?[0-9]+\\)$");
    public static final Pattern SPREADSHEETRESULT_FIELD_PATTERN = Pattern.compile("^\\$.+$");
    private static final Pattern FIELD_WITH_PRECISION_PATTERN = Pattern.compile("^(.*\\S)\\s*(\\(-?[0-9]+\\))$");
    private static final Pattern QUOTED = Pattern.compile("\\\".*\\\"");

    private DataTableBindHelper() {
    }

    public static boolean hasForeignKeysRow(ILogicalTable dataTable) {
        ILogicalTable potentialForeignKeysRow = (ILogicalTable)dataTable.getRows(1, 1);
        int columnsCount = potentialForeignKeysRow.getWidth();
        for (int i = 0; i < columnsCount; ++i) {
            ILogicalTable cell = (ILogicalTable)potentialForeignKeysRow.getColumn(i);
            String value = cell.getSource().getCell(0, 0).getStringValue();
            if (value == null || value.trim().length() == 0) continue;
            return value.charAt(0) == '>';
        }
        return false;
    }

    public static ILogicalTable getTableBody(TableSyntaxNode tsn) {
        int startRow = !tsn.hasPropertiesDefinedInTable() ? 1 : 2;
        return (ILogicalTable)tsn.getTable().getRows(startRow);
    }

    public static boolean isHorizontalTable(ILogicalTable dataTableBody, IOpenClass tableType) {
        if (dataTableBody.getHeight() != 1) {
            int refCount2;
            ILogicalTable dataTableBodyT;
            int fieldsCount2;
            if (ClassUtils.isAssignable((Class)tableType.getInstanceClass(), TableProperties.class)) {
                return false;
            }
            int fieldsCount1 = DataTableBindHelper.countChangeableFields(dataTableBody, tableType);
            if (fieldsCount1 > (fieldsCount2 = DataTableBindHelper.countChangeableFields(dataTableBodyT = (ILogicalTable)dataTableBody.transpose(), tableType))) {
                return true;
            }
            if (fieldsCount1 < fieldsCount2) {
                return false;
            }
            int refCount1 = DataTableBindHelper.countRefs(dataTableBody);
            if (refCount1 < (refCount2 = DataTableBindHelper.countRefs(dataTableBodyT))) {
                return true;
            }
            if (refCount1 > refCount2) {
                return false;
            }
            if (tableType instanceof TestMethodOpenClass) {
                int resCount2;
                int resCount1 = DataTableBindHelper.countResFields(dataTableBody);
                return resCount1 >= (resCount2 = DataTableBindHelper.countResFields(dataTableBodyT));
            }
            return true;
        }
        return false;
    }

    private static int countChangeableFields(ILogicalTable dataTable, IOpenClass tableType) {
        int count = 0;
        int width = dataTable.getWidth();
        HashSet<String> uniqueFieldNames = new HashSet<String>();
        for (int i = 0; i < width; ++i) {
            IOpenField field;
            int brIndex;
            int dotIndex;
            String fieldName = ((ILogicalTable)dataTable.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (fieldName == null || !uniqueFieldNames.add(fieldName = StringUtils.trim((String)fieldName))) continue;
            IOpenClass openClass = tableType;
            while (openClass.isArray() && fieldName.length() > 0 && fieldName.charAt(0) == '[') {
                char ch;
                boolean arrayIndex = false;
                int endIndex = fieldName.indexOf(93);
                for (int j = 1; j < endIndex && (arrayIndex = Character.isDigit(ch = fieldName.charAt(j))); ++j) {
                }
                if (!arrayIndex) break;
                if (!((openClass = openClass.getComponentClass()).isArray() || fieldName.length() > ++endIndex && fieldName.charAt(endIndex) == '.')) {
                    --endIndex;
                }
                fieldName = fieldName.substring(endIndex + 1);
            }
            if ((dotIndex = fieldName.indexOf(46)) > 0) {
                fieldName = fieldName.substring(0, dotIndex);
            }
            if ((brIndex = fieldName.indexOf(91)) > 0) {
                fieldName = fieldName.substring(0, brIndex);
            }
            if ((field = DataTableBindHelper.findField(fieldName, null, openClass)) == null || field.isConst() || !field.isWritable()) continue;
            ++count;
        }
        return count;
    }

    private static int countRefs(ILogicalTable dataTable) {
        int count = 0;
        int width = dataTable.getWidth();
        for (int i = 0; i < width; ++i) {
            String fieldName = ((ILogicalTable)dataTable.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (fieldName == null || !(fieldName = StringUtils.trim((String)fieldName)).startsWith(">")) continue;
            ++count;
        }
        return count;
    }

    private static int countResFields(ILogicalTable dataTable) {
        int count = 0;
        int width = dataTable.getWidth();
        for (int i = 0; i < width; ++i) {
            int brIndex;
            String fieldName = ((ILogicalTable)dataTable.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (fieldName == null) continue;
            int dotIndex = (fieldName = StringUtils.trim((String)fieldName)).indexOf(46);
            if (dotIndex > 0) {
                fieldName = fieldName.substring(0, dotIndex);
            }
            if ((brIndex = fieldName.indexOf(91)) > 0) {
                fieldName = fieldName.substring(0, brIndex);
            }
            if (!"_res_".equals(fieldName)) continue;
            ++count;
        }
        return count;
    }

    public static IOpenField findField(String fieldName, ITable table, IOpenClass tableType) {
        if (FPK.equals(fieldName)) {
            return new PrimaryKeyField(FPK, table);
        }
        return tableType.getField(fieldName, true);
    }

    public static ILogicalTable getHorizontalTable(ILogicalTable tableBody, IOpenClass tableType) {
        ILogicalTable resultTable = null;
        if (tableBody != null) {
            resultTable = tableBody.getWidth() == 1 || DataTableBindHelper.isHorizontalTable(tableBody, tableType) ? tableBody : (ILogicalTable)tableBody.transpose();
        }
        return resultTable;
    }

    public static ILogicalTable getHorizontalDataWithTitle(ILogicalTable horizDataTableBody) {
        int startIndex = DataTableBindHelper.getStartIndexForDataWithTitlesSection(horizDataTableBody);
        return (ILogicalTable)horizDataTableBody.getRows(startIndex);
    }

    public static ILogicalTable getSubTableForBusinessView(ILogicalTable tableBody, IOpenClass tableType) {
        if (DataTableBindHelper.isHorizontalTable(tableBody, tableType)) {
            return DataTableBindHelper.getHorizontalDataWithTitle(tableBody);
        }
        return DataTableBindHelper.getVerticalDataWithTitle(tableBody);
    }

    private static ILogicalTable getVerticalDataWithTitle(ILogicalTable verticalTableBody) {
        ILogicalTable horizDataTableBody = (ILogicalTable)verticalTableBody.transpose();
        int startIndex = DataTableBindHelper.getStartIndexForDataWithTitlesSection(horizDataTableBody);
        return (ILogicalTable)verticalTableBody.getColumns(startIndex);
    }

    private static int getStartIndexForDataWithTitlesSection(ILogicalTable horizDataTableBody) {
        boolean hasForeignKeysRow = DataTableBindHelper.hasForeignKeysRow(horizDataTableBody);
        if (hasForeignKeysRow) {
            return 2;
        }
        return 1;
    }

    public static ILogicalTable getDescriptorRows(ILogicalTable horizDataTableBody) {
        int endRow = DataTableBindHelper.getEndRowForDescriptorSection(horizDataTableBody);
        return (ILogicalTable)horizDataTableBody.getRows(0, endRow);
    }

    private static int getEndRowForDescriptorSection(ILogicalTable horizDataTableBody) {
        boolean hasForeignKeysRow = DataTableBindHelper.hasForeignKeysRow(horizDataTableBody);
        if (hasForeignKeysRow) {
            return 1;
        }
        return 0;
    }

    public static StringValue makeColumnTitle(IBindingContext bindingContext, ILogicalTable dataWithTitleRows, int column, boolean hasColumnTitleRow) {
        String value = "";
        if (hasColumnTitleRow) {
            ILogicalTable titleCell = (ILogicalTable)dataWithTitleRows.getSubtable(column, 0, 1, 1);
            value = titleCell.getSource().getCell(0, 0).getStringValue();
            value = StringUtils.trimToEmpty((String)value);
            return new StringValue(value, value, value, (IOpenSourceCodeModule)new GridCellSourceCodeModule(titleCell.getSource(), bindingContext));
        }
        return new StringValue(value, value, value, null);
    }

    public static ColumnDescriptor[] makeDescriptors(IBindingContext bindingContext, ITable table, IOpenClass type, OpenL openl, ILogicalTable descriptorRows, ILogicalTable dataWithTitleRows, boolean hasForeignKeysRow, boolean hasColumnTitleRow, boolean supportConstructorFields) throws Exception {
        int width = descriptorRows.getWidth();
        ColumnDescriptor[] columnDescriptors = new ColumnDescriptor[width];
        LinkedHashSet<IdentifierNodesBucket> columnIdentifiers = DataTableBindHelper.getColumnIdentifiers(bindingContext, table, descriptorRows);
        int columnNum = 0;
        for (IdentifierNodesBucket node : columnIdentifiers) {
            IdentifierNode[] fieldAccessorChainTokens = node.getNode();
            if (fieldAccessorChainTokens != null) {
                ColumnDescriptor currentColumnDescriptor;
                IOpenField descriptorField = null;
                boolean constructorField = false;
                IdentifierNode foreignKeyTable = null;
                IdentifierNode foreignKey = null;
                Object[] accessorChainTokens = null;
                ICell foreignKeyCell = null;
                if (fieldAccessorChainTokens.length == 1 && !hasForeignKeysRow) {
                    IdentifierNode fieldNameNode = fieldAccessorChainTokens[0];
                    if (supportConstructorFields && CONSTRUCTOR_FIELD.equals(fieldNameNode.getIdentifier())) {
                        constructorField = true;
                    }
                }
                if (!(constructorField || fieldAccessorChainTokens.length == 1 && hasForeignKeysRow && CONSTRUCTOR_FIELD.equals(fieldAccessorChainTokens[0].getIdentifier()))) {
                    descriptorField = DataTableBindHelper.processFieldsChain(bindingContext, table, type, fieldAccessorChainTokens);
                }
                if (hasForeignKeysRow) {
                    IdentifierNode[] foreignKeyTokens = DataTableBindHelper.getForeignKeyTokens(bindingContext, descriptorRows, columnNum);
                    foreignKeyTable = foreignKeyTokens.length > 0 ? foreignKeyTokens[0] : null;
                    foreignKey = foreignKeyTokens.length > 1 ? foreignKeyTokens[1] : null;
                    foreignKeyCell = ((ILogicalTable)descriptorRows.getSubtable(columnNum, 1, 1, 1)).getSource().getCell(0, 0);
                    if (foreignKeyTable != null && !ArrayUtils.isEmpty((Object[])(accessorChainTokens = Tokenizer.tokenize((IOpenSourceCodeModule)foreignKeyTable.getModule(), (String)LINK_DELIMETERS, (ILocation)foreignKeyTable.getLocation())))) {
                        foreignKeyTable = accessorChainTokens.length > 0 ? accessorChainTokens[0] : null;
                    }
                }
                StringValue header = DataTableBindHelper.makeColumnTitle(bindingContext, dataWithTitleRows, columnNum, hasColumnTitleRow);
                columnDescriptors[columnNum] = currentColumnDescriptor = DataTableBindHelper.getColumnDescriptor(openl, descriptorField, constructorField, foreignKeyTable, foreignKey, accessorChainTokens, foreignKeyCell, header, fieldAccessorChainTokens, columnNum);
            }
            ++columnNum;
        }
        boolean hasSupportMultirowsAfter = false;
        for (columnNum = columnIdentifiers.size() - 1; columnNum >= 0; --columnNum) {
            if (columnDescriptors[columnNum] == null) continue;
            if (hasSupportMultirowsAfter) {
                columnDescriptors[columnNum].setSupportMultirows(true);
                continue;
            }
            if (!columnDescriptors[columnNum].isSupportMultirows()) continue;
            hasSupportMultirowsAfter = true;
        }
        return columnDescriptors;
    }

    public static LinkedHashSet<IdentifierNodesBucket> getColumnIdentifiers(IBindingContext bindingContext, ITable table, ILogicalTable descriptorRows) {
        int width = descriptorRows.getWidth();
        LinkedHashSet<IdentifierNodesBucket> identifiers = new LinkedHashSet<IdentifierNodesBucket>();
        for (int columnNum = 0; columnNum < width; ++columnNum) {
            GridCellSourceCodeModule cellSourceModule = DataTableBindHelper.getCellSourceModule(descriptorRows, columnNum);
            cellSourceModule.update(bindingContext);
            String code = cellSourceModule.getCode();
            if (code.length() != 0) {
                SyntaxNodeException error;
                String message;
                IdentifierNode[] fieldAccessorChainTokens = null;
                try {
                    fieldAccessorChainTokens = DataTableBindHelper.trimAndSplitPrecisionToken(Tokenizer.tokenize((IOpenSourceCodeModule)cellSourceModule, (String)CODE_DELIMETERS));
                }
                catch (OpenLCompilationException e) {
                    LOG.debug("Error occurred: ", (Throwable)e);
                    message = String.format("Cannot parse field source '%s'", code);
                    error = SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceModule);
                    bindingContext.addError(error);
                }
                if (identifiers.contains(new IdentifierNodesBucket(fieldAccessorChainTokens))) {
                    String message2 = String.format("Found duplicate of field '%s'", code);
                    SyntaxNodeException error2 = SyntaxNodeExceptionUtils.createError((String)message2, (IOpenSourceCodeModule)cellSourceModule);
                    bindingContext.addError(error2);
                    continue;
                }
                boolean added = identifiers.add(new IdentifierNodesBucket(fieldAccessorChainTokens));
                if (added) continue;
                message = String.format("Found duplicate of field '%s'", code);
                error = SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceModule);
                bindingContext.addError(error);
                continue;
            }
            identifiers.add(new IdentifierNodesBucket(null));
        }
        return identifiers;
    }

    private static IdentifierNode[] trimAndSplitPrecisionToken(IdentifierNode[] chainTokens) {
        if (chainTokens.length == 0) {
            return chainTokens;
        }
        for (int i = 0; i < chainTokens.length; ++i) {
            IdentifierNode token = chainTokens[i];
            String identifier = token.getIdentifier();
            String trimmed = identifier.trim();
            if (trimmed.length() == identifier.length()) continue;
            int tokenStart = token.getLocation().getStart().getAbsolutePosition(null) + identifier.indexOf(trimmed);
            TextInterval fieldInterval = LocationUtils.createTextInterval((int)tokenStart, (int)(tokenStart + trimmed.length()));
            chainTokens[i] = new IdentifierNode(token.getType(), (ILocation)fieldInterval, trimmed, token.getModule());
        }
        IdentifierNode token = chainTokens[chainTokens.length - 1];
        String identifier = token.getIdentifier();
        Matcher matcher = FIELD_WITH_PRECISION_PATTERN.matcher(identifier);
        if (matcher.matches()) {
            String field = matcher.group(1);
            String precision = matcher.group(2);
            int tokenStart = token.getLocation().getStart().getAbsolutePosition(null);
            int fieldStart = identifier.indexOf(field);
            int precisionStart = identifier.lastIndexOf(precision);
            TextInterval fieldInterval = LocationUtils.createTextInterval((int)(tokenStart + fieldStart), (int)(tokenStart + fieldStart + field.length()));
            TextInterval precisionInterval = LocationUtils.createTextInterval((int)(tokenStart + precisionStart), (int)(tokenStart + precisionStart + precision.length()));
            chainTokens[chainTokens.length - 1] = new IdentifierNode(token.getType(), (ILocation)fieldInterval, field, token.getModule());
            chainTokens = (IdentifierNode[])ArrayUtils.add((Object[])chainTokens, (Object)new IdentifierNode(token.getType(), (ILocation)precisionInterval, precision, token.getModule()));
        }
        return chainTokens;
    }

    private static GridCellSourceCodeModule getCellSourceModule(ILogicalTable descriptorRows, int columnNum) {
        IGridTable gridTable = ((ILogicalTable)descriptorRows.getColumn(columnNum)).getSource();
        return new GridCellSourceCodeModule(gridTable);
    }

    private static ColumnDescriptor getColumnDescriptor(OpenL openl, IOpenField descriptorField, boolean constructorField, IdentifierNode foreignKeyTable, IdentifierNode foreignKey, IdentifierNode[] foreignKeyTableAccessorChainTokens, ICell foreignKeyCell, StringValue header, IdentifierNode[] fieldChainTokens, int columnNum) {
        ColumnDescriptor currentColumnDescriptor;
        if (foreignKeyTable != null) {
            currentColumnDescriptor = new ForeignKeyColumnDescriptor(descriptorField, foreignKeyTable, foreignKey, foreignKeyTableAccessorChainTokens, foreignKeyCell, header, openl, constructorField, fieldChainTokens, columnNum);
        } else {
            boolean primaryKey = fieldChainTokens.length > 0 && FPK.equals(fieldChainTokens[fieldChainTokens.length - 1].getIdentifier());
            currentColumnDescriptor = new ColumnDescriptor(descriptorField, header, openl, constructorField, fieldChainTokens, columnNum, primaryKey);
        }
        return currentColumnDescriptor;
    }

    private static IOpenClass getTypeForCollection(IdentifierNode identifierNode, TestMethodOpenClass testMethodOpenClass, IBindingContext bindingContext) {
        int typeSeparatorIndex = identifierNode.getIdentifier().indexOf(58);
        if (typeSeparatorIndex < 0) {
            IOpenClass cType;
            ExecutableRulesMethod executableRulesMethod;
            TableSyntaxNode tableSyntaxNode;
            if (testMethodOpenClass != null && testMethodOpenClass.getTestedMethod() instanceof ExecutableRulesMethod && (tableSyntaxNode = (executableRulesMethod = (ExecutableRulesMethod)testMethodOpenClass.getTestedMethod()).getSyntaxNode()).getHeader().getCollectParameters().length > 0 && (cType = bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[ClassUtils.isAssignable((Class)executableRulesMethod.getType().getInstanceClass(), Map.class) ? 1 : 0])) != null) {
                return cType;
            }
            return JavaOpenClass.OBJECT;
        }
        String typeName = identifierNode.getIdentifier().substring(typeSeparatorIndex + 1);
        IOpenClass type = bindingContext.findType("org.openl.this", typeName = typeName.trim());
        if (type == null) {
            String message = String.format("Cannot bind node: '%s'. Cannot find type: '%s'.", identifierNode, typeName);
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)identifierNode);
            bindingContext.addError(error);
        }
        return type;
    }

    public static IOpenField processFieldsChain(IBindingContext bindingContext, ITable table, IOpenClass type, IdentifierNode[] fieldAccessorChainTokens) {
        FieldChain chainField = null;
        IOpenClass loadedFieldType = type;
        Object[] fieldAccessorChain = new IOpenField[fieldAccessorChainTokens.length];
        boolean hasAccessByArrayId = false;
        StringBuilder partPathFromRoot = new StringBuilder();
        boolean isResult = fieldAccessorChainTokens[0].getIdentifier().startsWith("_res_") || fieldAccessorChainTokens[0].getIdentifier().startsWith("_error_");
        boolean multiRowsArentSupported = type instanceof TestMethodOpenClass && isResult;
        for (int fieldIndex = 0; fieldIndex < fieldAccessorChain.length; ++fieldIndex) {
            IOpenField fieldInChain;
            boolean collectionAccessPattern;
            IdentifierNode fieldNameNode = fieldAccessorChainTokens[fieldIndex];
            String identifier = fieldNameNode.getIdentifier();
            if (fieldIndex > 0 && fieldIndex == fieldAccessorChain.length - 1 && identifier.equals(FPK)) {
                if (!(fieldAccessorChain[fieldIndex - 1] instanceof CollectionElementWithMultiRowField)) {
                    SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Primary key was defined incorrectly.", (ISyntaxNode)fieldNameNode);
                    bindingContext.addError(error);
                    continue;
                }
                CollectionElementWithMultiRowField datatypeCollectionMultiRowElementField = (CollectionElementWithMultiRowField)((Object)fieldAccessorChain[fieldIndex - 1]);
                CollectionElementWithMultiRowField newDatatypeArrayMultiRowElementField = new CollectionElementWithMultiRowField(datatypeCollectionMultiRowElementField.getField(), datatypeCollectionMultiRowElementField.getFieldPathFromRoot(), (IOpenClass)JavaOpenClass.STRING, datatypeCollectionMultiRowElementField.getCollectionType(), true);
                IOpenField[] fieldAccessorChainTmp = new IOpenField[fieldAccessorChainTokens.length - 1];
                System.arraycopy(fieldAccessorChain, 0, fieldAccessorChainTmp, 0, fieldAccessorChainTokens.length - 1);
                fieldAccessorChain = fieldAccessorChainTmp;
                fieldAccessorChain[fieldAccessorChain.length - 1] = newDatatypeArrayMultiRowElementField;
                continue;
            }
            if (fieldIndex == 0 && !(type instanceof TestMethodOpenClass)) {
                ThisCollectionElementField collectionElementField = null;
                IOpenClass collectionElementType = null;
                if (StringUtils.matches((Pattern)THIS_ARRAY_ACCESS_PATTERN, (CharSequence)identifier) && type.isArray()) {
                    collectionElementType = type.getComponentClass();
                    collectionElementField = new ThisCollectionElementField(DataTableBindHelper.getCollectionIndex(fieldNameNode), collectionElementType, CollectionType.ARRAY);
                } else if (StringUtils.matches((Pattern)THIS_LIST_ACCESS_PATTERN, (CharSequence)identifier) && ClassUtils.isAssignable((Class)type.getInstanceClass(), List.class)) {
                    collectionElementType = DataTableBindHelper.getTypeForCollection(fieldNameNode, null, bindingContext);
                    collectionElementField = new ThisCollectionElementField(DataTableBindHelper.getCollectionIndex(fieldNameNode), collectionElementType, CollectionType.LIST);
                } else if (StringUtils.matches((Pattern)THIS_MAP_ACCESS_PATTERN, (CharSequence)identifier) && ClassUtils.isAssignable((Class)type.getInstanceClass(), Map.class)) {
                    collectionElementType = DataTableBindHelper.getTypeForCollection(fieldNameNode, null, bindingContext);
                    collectionElementField = new ThisCollectionElementField(DataTableBindHelper.getCollectionKey(fieldNameNode), collectionElementType);
                }
                if (collectionElementField != null) {
                    if (collectionElementType == null) break;
                    fieldAccessorChain[fieldIndex] = collectionElementField;
                    loadedFieldType = collectionElementType;
                    continue;
                }
            }
            if (isResult && StringUtils.matches((Pattern)PRECISION_PATTERN, (CharSequence)identifier)) {
                fieldAccessorChain = (IOpenField[])ArrayUtils.remove((Object[])fieldAccessorChain, (int)fieldIndex);
                fieldAccessorChainTokens = (IdentifierNode[])ArrayUtils.remove((Object[])fieldAccessorChainTokens, (int)fieldIndex);
                continue;
            }
            boolean bl = collectionAccessPattern = StringUtils.matches((Pattern)COLLECTION_ACCESS_BY_INDEX_PATTERN, (CharSequence)identifier) || StringUtils.matches((Pattern)COLLECTION_ACCESS_BY_KEY_PATTERN, (CharSequence)identifier);
            if (collectionAccessPattern) {
                hasAccessByArrayId = true;
                fieldInChain = DataTableBindHelper.getWritableCollectionElement(bindingContext, fieldNameNode, table, loadedFieldType, partPathFromRoot.toString(), false);
            } else {
                fieldInChain = DataTableBindHelper.getWritableField(bindingContext, fieldNameNode, table, loadedFieldType);
                if (fieldIndex != fieldAccessorChain.length - 1 && fieldInChain != null && fieldInChain.getType() != NullOpenClass.the && (fieldInChain.getType().isArray() || ClassUtils.isAssignable((Class)fieldInChain.getType().getInstanceClass(), List.class))) {
                    fieldInChain = DataTableBindHelper.getWritableCollectionElement(bindingContext, fieldNameNode, table, loadedFieldType, partPathFromRoot.toString(), !multiRowsArentSupported);
                }
            }
            if (fieldIndex > 0 && (fieldAccessorChain[fieldIndex - 1] instanceof CollectionElementField || fieldAccessorChain[fieldIndex - 1] instanceof SpreadsheetResultField) && fieldAccessorChain[fieldIndex - 1].getType().equals(JavaOpenClass.OBJECT) && StringUtils.matches((Pattern)SPREADSHEETRESULT_FIELD_PATTERN, (CharSequence)identifier)) {
                AOpenField aOpenField = (AOpenField)fieldAccessorChain[fieldIndex - 1];
                aOpenField.setType((IOpenClass)JavaOpenClass.getOpenClass(SpreadsheetResult.class));
            }
            if (fieldInChain == null) break;
            loadedFieldType = fieldInChain.getType();
            fieldAccessorChain[fieldIndex] = fieldInChain;
            if (fieldIndex > 0) {
                partPathFromRoot.append('.');
            }
            partPathFromRoot.append(fieldInChain.getName());
        }
        if (!CollectionUtils.hasNull((Object[])fieldAccessorChain)) {
            chainField = new FieldChain(type, (IOpenField[])fieldAccessorChain, fieldAccessorChainTokens, hasAccessByArrayId);
        }
        return chainField;
    }

    public static Integer getPrecisionValue(IdentifierNode fieldNameNode) {
        try {
            String fieldName = fieldNameNode.getIdentifier();
            String txtIndex = fieldName.substring(fieldName.indexOf(40) + 1, fieldName.indexOf(41));
            return Integer.parseInt(txtIndex);
        }
        catch (Exception e) {
            LOG.debug("Ignored error: ", (Throwable)e);
            return null;
        }
    }

    public static int getCollectionIndex(IdentifierNode fieldNameNode) {
        String fieldName = fieldNameNode.getIdentifier();
        String txtIndex = fieldName.substring(fieldName.indexOf(91) + 1, fieldName.indexOf(93)).trim();
        return Integer.parseInt(txtIndex);
    }

    public static String getCollectionName(IdentifierNode fieldNameNode) {
        String fieldName = fieldNameNode.getIdentifier();
        int ind = fieldName.indexOf(91);
        if (ind > 0) {
            return fieldName.substring(0, ind).trim();
        }
        return DataTableBindHelper.getFieldName(fieldName);
    }

    private static IdentifierNode[] getForeignKeyTokens(IBindingContext bindingContext, ILogicalTable descriptorRows, int columnNum) throws OpenLCompilationException {
        ILogicalTable logicalRegion = (ILogicalTable)descriptorRows.getSubtable(columnNum, 1, 1, 1);
        GridCellSourceCodeModule indexRowSourceModule = new GridCellSourceCodeModule(logicalRegion.getSource(), bindingContext);
        return Tokenizer.tokenize((IOpenSourceCodeModule)indexRowSourceModule, (String)INDEX_ROW_REFERENCE_DELIMITER);
    }

    private static IOpenField getWritableField(IBindingContext bindingContext, IdentifierNode currentFieldNameNode, ITable table, IOpenClass loadedFieldType) {
        String fieldName = DataTableBindHelper.getFieldName(currentFieldNameNode.getIdentifier());
        IOpenField field = DataTableBindHelper.findField(fieldName, table, loadedFieldType);
        if (field == null && loadedFieldType.equals(JavaOpenClass.OBJECT)) {
            field = DataTableBindHelper.findField(fieldName, table, (IOpenClass)JavaOpenClass.getOpenClass(SpreadsheetResult.class));
        }
        if (field == null) {
            String errorMessage;
            if (loadedFieldType instanceof TestMethodOpenClass) {
                StringBuilder sb = new StringBuilder();
                MethodUtil.printMethod((IOpenMethodHeader)((TestMethodOpenClass)loadedFieldType).getTestedMethod(), (StringBuilder)sb);
                errorMessage = String.format("Expected one of the parameters from the method '%s', but found '%s'.", sb, fieldName);
            } else {
                errorMessage = String.format("%s '%s' is not found in type '%s'.", loadedFieldType.isStatic() ? "Static field" : "Field", fieldName, loadedFieldType.getName());
            }
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)currentFieldNameNode);
            bindingContext.addError(error);
            return null;
        }
        if (!field.isWritable()) {
            String message = String.format("Field '%s' is not writable in type '%s'.", fieldName, loadedFieldType.getName());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)currentFieldNameNode);
            bindingContext.addError(error);
            return null;
        }
        return field;
    }

    private static String getFieldName(String identifier) {
        String fieldName = identifier.trim();
        int endIndex = fieldName.indexOf(58);
        if (endIndex > 0) {
            fieldName = fieldName.substring(0, endIndex).trim();
        }
        return fieldName;
    }

    private static String buildRootPathForDatatypeArrayMultiRowElementField(String partPathFromRoot, String fieldName) {
        if (StringUtils.isEmpty((CharSequence)partPathFromRoot)) {
            return fieldName + "[]";
        }
        return partPathFromRoot + LINK_DELIMETERS + fieldName + "[]";
    }

    private static IOpenField getWritableCollectionElement(IBindingContext bindingContext, IdentifierNode currentFieldNameNode, ITable table, IOpenClass loadedFieldType, String partPathFromRoot, boolean multiRowElement) {
        CollectionElementWithMultiRowField collectionAccessField;
        IOpenClass elementType;
        String name = DataTableBindHelper.getCollectionName(currentFieldNameNode);
        IOpenField field = DataTableBindHelper.findField(name, table, loadedFieldType);
        if (field == null && loadedFieldType.equals(JavaOpenClass.OBJECT)) {
            field = DataTableBindHelper.findField(name, table, (IOpenClass)JavaOpenClass.getOpenClass(SpreadsheetResult.class));
        }
        if (field == null) {
            String message = String.format("%s '%s' is not found.", loadedFieldType.isStatic() ? "Static field" : "Field", name);
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)currentFieldNameNode);
            bindingContext.addError(error);
            return null;
        }
        if (!(ClassUtils.isAssignable((Class)field.getType().getInstanceClass(), Map.class) || ClassUtils.isAssignable((Class)field.getType().getInstanceClass(), List.class) || field.getType().isArray() || Object.class == field.getType().getInstanceClass())) {
            String message = String.format("Expected a collection type for field '%s', but found type '%s'.", name, field.getType().toString());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)currentFieldNameNode);
            bindingContext.addError(error);
            return null;
        }
        if (multiRowElement) {
            IOpenClass fieldType = field.getType();
            if (ClassUtils.isAssignable((Class)fieldType.getInstanceClass(), List.class)) {
                elementType = DataTableBindHelper.getTypeForCollection(currentFieldNameNode, loadedFieldType instanceof TestMethodOpenClass ? (TestMethodOpenClass)loadedFieldType : null, bindingContext);
                collectionAccessField = new CollectionElementWithMultiRowField(field, DataTableBindHelper.buildRootPathForDatatypeArrayMultiRowElementField(partPathFromRoot, field.getName()), elementType, CollectionType.LIST);
            } else {
                collectionAccessField = fieldType instanceof UserErrorOpenClass ? new CollectionElementWithMultiRowField(field, DataTableBindHelper.buildRootPathForDatatypeArrayMultiRowElementField(partPathFromRoot, field.getName()), (IOpenClass)new UserErrorOpenClass(), CollectionType.ARRAY) : (!fieldType.isArray() && Object.class == fieldType.getInstanceClass() ? new CollectionElementWithMultiRowField(field, DataTableBindHelper.buildRootPathForDatatypeArrayMultiRowElementField(partPathFromRoot, field.getName()), (IOpenClass)JavaOpenClass.OBJECT, CollectionType.ARRAY) : new CollectionElementWithMultiRowField(field, DataTableBindHelper.buildRootPathForDatatypeArrayMultiRowElementField(partPathFromRoot, field.getName()), fieldType.getComponentClass(), CollectionType.ARRAY));
            }
        } else if (ClassUtils.isAssignable((Class)field.getType().getInstanceClass(), Map.class)) {
            Object mapKey;
            try {
                mapKey = DataTableBindHelper.getCollectionKey(currentFieldNameNode, loadedFieldType instanceof TestMethodOpenClass ? (TestMethodOpenClass)loadedFieldType : null, bindingContext);
            }
            catch (SyntaxNodeException e) {
                bindingContext.addError(e);
                return null;
            }
            catch (Exception e) {
                LOG.debug("Error occurred: ", (Throwable)e);
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Failed to parse a map key.", (ISyntaxNode)currentFieldNameNode);
                bindingContext.addError(error);
                return null;
            }
            elementType = DataTableBindHelper.getTypeForCollection(currentFieldNameNode, loadedFieldType instanceof TestMethodOpenClass ? (TestMethodOpenClass)loadedFieldType : null, bindingContext);
            collectionAccessField = new CollectionElementField(field, mapKey, elementType);
        } else {
            int index;
            try {
                index = DataTableBindHelper.getCollectionIndex(currentFieldNameNode);
            }
            catch (Exception e) {
                LOG.debug("Error occurred: ", (Throwable)e);
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Failed to parse an array index.", (ISyntaxNode)currentFieldNameNode);
                bindingContext.addError(error);
                return null;
            }
            IOpenClass fieldType = field.getType();
            if (ClassUtils.isAssignable((Class)fieldType.getInstanceClass(), List.class)) {
                IOpenClass elementType2 = DataTableBindHelper.getTypeForCollection(currentFieldNameNode, loadedFieldType instanceof TestMethodOpenClass ? (TestMethodOpenClass)loadedFieldType : null, bindingContext);
                collectionAccessField = new CollectionElementField(field, index, elementType2, CollectionType.LIST);
            } else {
                collectionAccessField = fieldType instanceof UserErrorOpenClass ? new CollectionElementField(field, index, (IOpenClass)new UserErrorOpenClass(), CollectionType.ARRAY) : (!fieldType.isArray() && Object.class == fieldType.getInstanceClass() ? new CollectionElementField(field, index, (IOpenClass)JavaOpenClass.OBJECT, CollectionType.ARRAY) : new CollectionElementField(field, index, fieldType.getComponentClass(), CollectionType.ARRAY));
            }
        }
        if (!collectionAccessField.isWritable()) {
            String message = String.format("Field '%s' is not writable in %s.", name, loadedFieldType.getName());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)currentFieldNameNode);
            bindingContext.addError(error);
            return null;
        }
        return collectionAccessField;
    }

    private static Object getCollectionKey(IdentifierNode currentFieldNameNode, TestMethodOpenClass testMethodOpenClass, IBindingContext bindingContext) throws SyntaxNodeException {
        IOpenClass keyOpenClass;
        ExecutableRulesMethod executableRulesMethod;
        TableSyntaxNode tableSyntaxNode;
        String s = currentFieldNameNode.getIdentifier();
        s = s.substring(s.indexOf(91) + 1, s.lastIndexOf(93)).trim();
        if (testMethodOpenClass != null && testMethodOpenClass.getTestedMethod() instanceof ExecutableRulesMethod && (tableSyntaxNode = (executableRulesMethod = (ExecutableRulesMethod)testMethodOpenClass.getTestedMethod()).getSyntaxNode()).getHeader().getCollectParameters().length > 1 && (keyOpenClass = bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[0])) != null) {
            if (keyOpenClass.getInstanceClass() == String.class && StringUtils.matches((Pattern)QUOTED, (CharSequence)s)) {
                s = s.substring(1, s.length() - 1);
            }
            try {
                IString2DataConvertor converter = String2DataConvertorFactory.getConvertor(keyOpenClass.getInstanceClass());
                return converter.parse(s, null);
            }
            catch (Exception e) {
                LOG.debug("Error occurred: ", (Throwable)e);
                throw SyntaxNodeExceptionUtils.createError((String)String.format("Cannot convert a key value '%s' to type '%s'.", s, keyOpenClass.getName()), (ISyntaxNode)currentFieldNameNode);
            }
        }
        return DataTableBindHelper.getCollectionKey(currentFieldNameNode);
    }

    public static Object getCollectionKey(IdentifierNode currentFieldNameNode) {
        String s = currentFieldNameNode.getIdentifier();
        if (StringUtils.matches((Pattern)QUOTED, (CharSequence)(s = s.substring(s.indexOf(91) + 1, s.lastIndexOf(93)).trim()))) {
            return s.substring(1, s.length() - 1);
        }
        return Integer.valueOf(s);
    }

    static boolean isPrecisionNode(IdentifierNode node) {
        return StringUtils.matches((Pattern)PRECISION_PATTERN, (CharSequence)node.getIdentifier());
    }
}

