/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openl.gen.FieldDescription;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;

public class FieldDescriptionBuilder {
    private static final Map<String, Class<?>> CLASSMAP;
    private final String typeName;
    private String defaultValueAsString;
    private Object defaultValue;
    private String contextPropertyName;
    private boolean isTransient;

    private FieldDescriptionBuilder(String typeName) {
        this.typeName = typeName;
    }

    public static FieldDescriptionBuilder create(String typeName) {
        return new FieldDescriptionBuilder(typeName);
    }

    public FieldDescriptionBuilder setDefaultValueAsString(String defaultValueAsString) {
        this.defaultValueAsString = defaultValueAsString;
        return this;
    }

    public FieldDescriptionBuilder setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public FieldDescriptionBuilder setContextPropertyName(String contextPropertyName) {
        this.contextPropertyName = contextPropertyName;
        return this;
    }

    public FieldDescriptionBuilder setTransient(boolean isTransient) {
        this.isTransient = isTransient;
        return this;
    }

    public FieldDescription build() {
        return new FieldDescription(this.typeName, this.getDefaultValue(), this.defaultValueAsString, this.contextPropertyName, this.isTransient);
    }

    private Class<?> getType() {
        Class<?> cl = CLASSMAP.get(this.typeName);
        if (cl != null) {
            return cl;
        }
        try {
            return Class.forName(this.typeName);
        }
        catch (ClassNotFoundException e) {
            return Object.class;
        }
    }

    private Object getDefaultValue() {
        if (this.defaultValue == null && this.defaultValueAsString != null) {
            if ("_DEFAULT_".equals(this.defaultValueAsString)) {
                this.defaultValue = "_DEFAULT_";
            } else {
                if (this.typeName.startsWith("[[")) {
                    throw new IllegalStateException("Multi-dimensional arrays are not supported.");
                }
                IString2DataConvertor<?> convertor = String2DataConvertorFactory.getConvertor(this.getType());
                this.defaultValue = convertor.parse(this.defaultValueAsString, null);
            }
        }
        return this.defaultValue;
    }

    static {
        HashMap<String, Class<Serializable>> classMap = new HashMap<String, Class<Serializable>>();
        classMap.put("int", Integer.TYPE);
        classMap.put("long", Long.TYPE);
        classMap.put("char", Character.TYPE);
        classMap.put("short", Short.TYPE);
        classMap.put("byte", Byte.TYPE);
        classMap.put("double", Double.TYPE);
        classMap.put("float", Float.TYPE);
        classMap.put("boolean", Boolean.TYPE);
        CLASSMAP = Collections.unmodifiableMap(classMap);
    }
}

