/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.dt.DTInfo;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DTUnmatchedCompilationException;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.dt.DecisionTableLookupConvertor;
import org.openl.rules.dt.IBaseAction;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.element.Action;
import org.openl.rules.dt.element.ActionType;
import org.openl.rules.dt.element.Condition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DecisionTableMetaInfoReader;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.xls.XlsUrlParser;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.ParserUtils;

public class DecisionTableLoader {
    static final String EMPTY_BODY = "Decision table must contain body section.";
    private static final int MAX_COLUMNS_IN_DT = 100;

    private DTScale.RowScale getConditionScale(TableStructure tableStructure, String name) {
        if (DecisionTableHelper.isValidHConditionHeader(name.toUpperCase())) {
            return tableStructure.info.getScale().getHScale();
        }
        return tableStructure.info.getScale().getVScale();
    }

    private void addRule(int row, ILogicalTable table, TableStructure tableStructure, IBindingContext bindingContext) throws SyntaxNodeException {
        if (tableStructure.ruleRow != null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Only one rule row/column allowed.", (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
        tableStructure.ruleRow = new RuleRow(row, table);
    }

    public void loadAndBind(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, OpenL openl, ModuleOpenClass module, boolean transpose, IBindingContext bindingContext) throws Exception {
        TableStructure tableStructure = this.loadTableStructure(tableSyntaxNode, decisionTable, transpose, (XlsModuleOpenClass)module, bindingContext);
        IBaseCondition[] conditionsArray = tableStructure.conditions.toArray(IBaseCondition.EMPTY);
        IBaseAction[] actionsArray = tableStructure.actions.toArray(IBaseAction.EMPTY);
        decisionTable.bindTable(conditionsArray, actionsArray, tableStructure.ruleRow, openl, module, bindingContext, tableStructure.columnsNumber);
    }

    private boolean isLookupByHConditions(ILogicalTable tableBody, boolean isSmart) {
        int firstColumnHeight;
        int numberOfHCondition = DecisionTableHelper.getNumberOfHConditions(tableBody);
        int firstColumnForHCondition = (Integer)DecisionTableHelper.getFirstColumnForHCondition(tableBody, numberOfHCondition, firstColumnHeight = tableBody.getSource().getCell(0, 0).getHeight(), isSmart).getLeft();
        if (firstColumnForHCondition > 0 && firstColumnHeight != tableBody.getSource().getCell(firstColumnForHCondition, 0).getHeight()) {
            DecisionTableHelper.NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter = new DecisionTableHelper.NumberOfColumnsUnderTitleCounter(tableBody, firstColumnHeight);
            for (int i = firstColumnForHCondition; i < tableBody.getSource().getWidth(); i += tableBody.getSource().getCell(i, 0).getWidth()) {
                int c = numberOfColumnsUnderTitleCounter.get(i);
                if (c <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private Direction detectTableDirection(TableSyntaxNode tableSyntaxNode) {
        ILogicalTable tableBody;
        Direction direction = Direction.UNKNOWN;
        if (DecisionTableHelper.isLookup(tableSyntaxNode)) {
            boolean isSmart = DecisionTableHelper.isSmart(tableSyntaxNode);
            ILogicalTable tableBody2 = tableSyntaxNode.getTableBody();
            if (tableBody2 != null) {
                if (isSmart && DecisionTableHelper.isSmartLookupAndResultTitleInFirstRow(tableSyntaxNode, tableBody2)) {
                    if (this.isLookupByHConditions(DecisionTableHelper.cutResultTitleInFirstRow(tableBody2), true)) {
                        direction = Direction.NORMAL;
                    }
                } else if (this.isLookupByHConditions(tableBody2, isSmart)) {
                    direction = Direction.NORMAL;
                }
                if (isSmart && DecisionTableHelper.isSmartLookupAndResultTitleInFirstRow(tableSyntaxNode, (ILogicalTable)tableBody2.transpose())) {
                    if (this.isLookupByHConditions(DecisionTableHelper.cutResultTitleInFirstRow((ILogicalTable)tableBody2.transpose()), true)) {
                        direction = Direction.UNKNOWN.equals((Object)direction) ? Direction.TRANSPOSED : Direction.UNKNOWN;
                    }
                } else if (this.isLookupByHConditions((ILogicalTable)tableBody2.transpose(), isSmart)) {
                    direction = Direction.UNKNOWN.equals((Object)direction) ? Direction.TRANSPOSED : Direction.UNKNOWN;
                }
            }
        } else if (DecisionTableHelper.isRulesTable(tableSyntaxNode) && (tableBody = tableSyntaxNode.getTableBody()) != null) {
            Pair<Integer, Integer> tableBodyCounts = DecisionTableHelper.countAllHeaderTypes(tableBody);
            int originalHeadersCnt = (Integer)tableBodyCounts.getLeft();
            int originalNonHeadersCnt = (Integer)tableBodyCounts.getRight();
            if (originalNonHeadersCnt == 0) {
                return Direction.NORMAL;
            }
            ILogicalTable tableBodyT = (ILogicalTable)tableBody.transpose();
            Pair<Integer, Integer> transposedTableBodyCounts = DecisionTableHelper.countAllHeaderTypes(tableBodyT);
            int transposedHeadersCnt = (Integer)transposedTableBodyCounts.getLeft();
            int transposedNonHeadersCnt = (Integer)transposedTableBodyCounts.getRight();
            if (transposedNonHeadersCnt == 0 || originalNonHeadersCnt > transposedNonHeadersCnt) {
                return Direction.TRANSPOSED;
            }
            if (originalNonHeadersCnt < transposedNonHeadersCnt) {
                return Direction.NORMAL;
            }
            if (originalHeadersCnt > transposedHeadersCnt) {
                return Direction.NORMAL;
            }
            if (originalHeadersCnt < transposedHeadersCnt) {
                return Direction.TRANSPOSED;
            }
            return Direction.UNKNOWN;
        }
        return direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndBind(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, OpenL openl, ModuleOpenClass module, IBindingContext bindingContext) throws Exception {
        boolean f;
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        int height = tableBody == null ? 0 : tableBody.getHeight();
        int width = tableBody == null ? 0 : tableBody.getWidth();
        Direction direction = this.detectTableDirection(tableSyntaxNode);
        boolean bl = f = width > height && width >= 100;
        if (Direction.TRANSPOSED.equals((Object)direction)) {
            f = true;
        } else if (Direction.NORMAL.equals((Object)direction)) {
            f = false;
        }
        boolean firstTransposedThenNormal = f;
        try {
            CompilationErrors loadAndBindErrors = this.compileAndRevertIfFails(tableSyntaxNode, decisionTable, () -> this.loadAndBind(tableSyntaxNode, decisionTable, openl, module, firstTransposedThenNormal, bindingContext), bindingContext);
            DTInfo dtInfo = decisionTable.getDtInfo();
            if (loadAndBindErrors != null) {
                if (Direction.UNKNOWN.equals((Object)direction) && (tableBody == null || DecisionTableHelper.isLookup(tableSyntaxNode) || (firstTransposedThenNormal ? width : height) <= 100)) {
                    CompilationErrors altLoadAndBindErrors = this.compileAndRevertIfFails(tableSyntaxNode, decisionTable, () -> this.loadAndBind(tableSyntaxNode, decisionTable, openl, module, !firstTransposedThenNormal, bindingContext), bindingContext);
                    if (altLoadAndBindErrors == null) {
                        return;
                    }
                    if (tableBody == null || DecisionTableHelper.isSmart(tableSyntaxNode) || DecisionTableHelper.isSimple(tableSyntaxNode)) {
                        if (this.isNotUnmatchedTableError(altLoadAndBindErrors) && loadAndBindErrors.getBindingSyntaxNodeException().size() > altLoadAndBindErrors.getBindingSyntaxNodeException().size() && this.isExceptionIsNotWorse(loadAndBindErrors, altLoadAndBindErrors)) {
                            this.putTableForBusinessView(tableSyntaxNode, !firstTransposedThenNormal);
                            altLoadAndBindErrors.apply(tableSyntaxNode, decisionTable, bindingContext);
                            if (altLoadAndBindErrors.getEx() != null) {
                                throw altLoadAndBindErrors.getEx();
                            }
                            return;
                        }
                    } else if (!firstTransposedThenNormal && DecisionTableLoader.looksLikeVertical(tableBody) || firstTransposedThenNormal && DecisionTableLoader.looksLikeHorizontal(tableBody)) {
                        this.putTableForBusinessView(tableSyntaxNode, !firstTransposedThenNormal);
                        altLoadAndBindErrors.apply(tableSyntaxNode, decisionTable, bindingContext);
                        if (altLoadAndBindErrors.getEx() != null) {
                            throw altLoadAndBindErrors.getEx();
                        }
                        return;
                    }
                    decisionTable.setDtInfo(dtInfo);
                }
                this.putTableForBusinessView(tableSyntaxNode, firstTransposedThenNormal);
                loadAndBindErrors.apply(tableSyntaxNode, decisionTable, bindingContext);
                if (loadAndBindErrors.getEx() != null) {
                    throw loadAndBindErrors.getEx();
                }
            }
        }
        finally {
            decisionTable.getDeferredChanges().forEach(DecisionTable.DeferredChange::apply);
        }
    }

    private boolean isExceptionIsNotWorse(CompilationErrors loadAndBindErrors, CompilationErrors altLoadAndBindErrors) {
        boolean alt = altLoadAndBindErrors.getEx() != null && !(altLoadAndBindErrors.getEx() instanceof OpenLCompilationException);
        boolean orig = loadAndBindErrors.getEx() != null && !(loadAndBindErrors.getEx() instanceof OpenLCompilationException);
        return orig || !alt;
    }

    private boolean isNotUnmatchedTableError(CompilationErrors altLoadAndBindErrors) {
        Throwable ex = altLoadAndBindErrors.getEx();
        if (ex != null) {
            if (ex instanceof SyntaxNodeException) {
                ex = ex.getCause();
            }
            return !(ex instanceof DTUnmatchedCompilationException);
        }
        return true;
    }

    private static boolean looksLikeHorizontal(ILogicalTable table) {
        int invalidCnt2;
        if (table.getWidth() < 4) {
            return true;
        }
        if (table.getHeight() < 4) {
            return false;
        }
        int validCnt1 = DecisionTableLoader.countValidHeaders(table);
        int validCnt2 = DecisionTableLoader.countValidHeaders((ILogicalTable)table.transpose());
        int invalidCnt1 = table.getWidth() - validCnt1 - DecisionTableLoader.countEmptyHeaders(table);
        if (invalidCnt1 == (invalidCnt2 = table.getHeight() - validCnt2 - DecisionTableLoader.countEmptyHeaders((ILogicalTable)table.transpose()))) {
            if (validCnt1 != validCnt2) {
                return validCnt1 > validCnt2;
            }
            return table.getWidth() <= 4;
        }
        return invalidCnt1 < invalidCnt2;
    }

    private static boolean looksLikeVertical(ILogicalTable table) {
        int invalidCnt2;
        if (table.getHeight() < 4) {
            return true;
        }
        if (table.getWidth() < 4) {
            return false;
        }
        int validCnt1 = DecisionTableLoader.countValidHeaders(table);
        int validCnt2 = DecisionTableLoader.countValidHeaders((ILogicalTable)table.transpose());
        int invalidCnt1 = table.getWidth() - validCnt1 - DecisionTableLoader.countEmptyHeaders(table);
        if (invalidCnt1 == (invalidCnt2 = table.getHeight() - validCnt2 - DecisionTableLoader.countEmptyHeaders((ILogicalTable)table.transpose()))) {
            if (validCnt1 != validCnt2) {
                return validCnt1 < validCnt2;
            }
            return table.getHeight() <= 4;
        }
        return invalidCnt1 > invalidCnt2;
    }

    private static int countValidHeaders(ILogicalTable table) {
        int width = table.getWidth();
        int count = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null) continue;
            count += DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase()) || DecisionTableHelper.isValidActionHeader(value) || DecisionTableHelper.isValidRetHeader(value) || DecisionTableHelper.isValidCRetHeader(value) || DecisionTableHelper.isValidKeyHeader(value) ? 1 : 0;
        }
        return count;
    }

    private static int countEmptyHeaders(ILogicalTable table) {
        int width = table.getWidth();
        int count = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (!StringUtils.isBlank((CharSequence)value)) continue;
            ++count;
        }
        return count;
    }

    private static void validateCollectSyntaxNode(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, IBindingContext bindingContext) throws SyntaxNodeException {
        int parametersCount = tableSyntaxNode.getHeader().getCollectParameters().length;
        IOpenClass type = decisionTable.getType();
        if (NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{type})) {
            return;
        }
        if ((type.isArray() || ClassUtils.isAssignable((Class)type.getInstanceClass(), Collection.class)) && parametersCount > 1) {
            throw SyntaxNodeExceptionUtils.createError((String)String.format("Expected exactly one parameter for return type '%s'.", type.getComponentClass().getDisplayName(0)), (IOpenSourceCodeModule)tableSyntaxNode.getHeader().getCellSource());
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Map.class) && parametersCount != 2) {
            throw SyntaxNodeExceptionUtils.createError((String)String.format("Expected two parameters for return type '%s'.", type.getComponentClass().getDisplayName(0)), (IOpenSourceCodeModule)tableSyntaxNode.getHeader().getCellSource());
        }
        for (String parameterType : tableSyntaxNode.getHeader().getCollectParameters()) {
            IOpenClass t = bindingContext.findType("org.openl.this", parameterType);
            if (t == null) {
                throw SyntaxNodeExceptionUtils.createError((String)String.format("Type '%s' is not found.", parameterType), (IOpenSourceCodeModule)tableSyntaxNode.getHeader().getCellSource());
            }
            if (!type.isArray() || bindingContext.getCast(t, type.getComponentClass()) != null) continue;
            throw SyntaxNodeExceptionUtils.createError((String)String.format("Incompatible types: '%s' and '%s'.", type.getComponentClass().getDisplayName(0), t.getDisplayName(0)), (IOpenSourceCodeModule)tableSyntaxNode.getHeader().getCellSource());
        }
    }

    private TableStructure loadTableStructure(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, boolean transpose, XlsModuleOpenClass module, IBindingContext bindingContext) throws SyntaxNodeException {
        int height;
        ILogicalTable tableBody;
        if (DecisionTableHelper.isCollect(tableSyntaxNode)) {
            DecisionTableLoader.validateCollectSyntaxNode(tableSyntaxNode, decisionTable, bindingContext);
        }
        if ((tableBody = tableSyntaxNode.getTableBody()) == null) {
            throw SyntaxNodeExceptionUtils.createError((String)EMPTY_BODY, (ISyntaxNode)tableSyntaxNode);
        }
        if (transpose) {
            tableBody = (ILogicalTable)tableBody.transpose();
        }
        if (DecisionTableHelper.isSmartDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode)) {
            try {
                tableBody = DecisionTableHelper.preprocessDecisionTableWithoutHeaders(tableSyntaxNode, decisionTable, tableBody, module, bindingContext);
            }
            catch (OpenLCompilationException e) {
                throw SyntaxNodeExceptionUtils.createError((String)"Cannot create a header for a Simple Rules, Lookup Table or Smart Table.", (Throwable)e, (ISyntaxNode)tableSyntaxNode);
            }
        }
        if ((height = tableBody.getHeight()) < 4) {
            throw SyntaxNodeExceptionUtils.createError((String)"Invalid structure of decision table.", (ISyntaxNode)tableSyntaxNode);
        }
        if (height == 4) {
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)"There are no rule rows in the table.", (ISyntaxNode)tableSyntaxNode));
        }
        ILogicalTable toParse = tableBody;
        int nHConditions = DecisionTableHelper.countHConditionsByHeaders(toParse);
        int nVConditions = DecisionTableHelper.countVConditionsByHeaders(toParse);
        TableStructure tableStructure = new TableStructure();
        if (nHConditions > 0 && height > 4) {
            try {
                DecisionTableLookupConvertor dtlc = new DecisionTableLookupConvertor();
                IGridTable convertedTable = dtlc.convertTable(toParse);
                toParse = LogicalTableHelper.logicalTable(convertedTable);
                tableStructure.info = new DTInfo(nHConditions, nVConditions, dtlc.getScale(), transpose);
            }
            catch (OpenLCompilationException e) {
                throw SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)tableSyntaxNode);
            }
            catch (Exception e) {
                throw SyntaxNodeExceptionUtils.createError((String)"Cannot convert table.", (Throwable)e, (ISyntaxNode)tableSyntaxNode);
            }
        }
        if (this.needToUnmergeFirstRow(toParse = (ILogicalTable)toParse.transpose())) {
            toParse = this.unmergeFirstRow(toParse);
        }
        if (tableStructure.info == null) {
            tableStructure.info = new DTInfo(nHConditions, nVConditions, transpose);
        }
        decisionTable.setDtInfo(tableStructure.info);
        tableStructure.columnsNumber = toParse.getWidth() - 4;
        this.putTableForBusinessView(tableSyntaxNode, transpose);
        for (int i = 0; i < toParse.getHeight(); ++i) {
            this.loadRow(decisionTable, tableStructure, toParse, i, bindingContext);
        }
        this.validateReturnType(tableSyntaxNode, decisionTable, tableStructure);
        return tableStructure;
    }

    private CompilationErrors compileAndRevertIfFails(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, Supplier supplier, IBindingContext bindingContext) {
        DecisionTableMetaInfoReader decisionTableMetaInfoReader = null;
        if (!bindingContext.isExecutionMode()) {
            decisionTableMetaInfoReader = (DecisionTableMetaInfoReader)tableSyntaxNode.getMetaInfoReader();
            decisionTableMetaInfoReader.pushMetaInfos();
        }
        bindingContext.pushErrors();
        bindingContext.pushMessages();
        Exception ex = null;
        try {
            supplier.get();
        }
        catch (Exception e) {
            ex = e;
        }
        List errors = bindingContext.popErrors();
        Collection messages = bindingContext.popMessages();
        this.filterErrorsAndMessagesNotRelatedToThisTable(tableSyntaxNode, errors, messages, bindingContext);
        DecisionTableMetaInfoReader.MetaInfoHolder metaInfos = null;
        if (decisionTableMetaInfoReader != null) {
            metaInfos = decisionTableMetaInfoReader.popMetaInfos();
        }
        if (errors.isEmpty() && ex == null) {
            messages.forEach(arg_0 -> ((IBindingContext)bindingContext).addMessage(arg_0));
            if (decisionTableMetaInfoReader != null) {
                decisionTableMetaInfoReader.getMetaInfos().merge(metaInfos);
            }
            return null;
        }
        CompilationErrors compilationErrors = new CompilationErrors(errors, messages, metaInfos, ex, new ArrayList<DecisionTable.DeferredChange>(decisionTable.getDeferredChanges()));
        decisionTable.getDeferredChanges().clear();
        return compilationErrors;
    }

    private void filterErrorsAndMessagesNotRelatedToThisTable(TableSyntaxNode tableSyntaxNode, List<SyntaxNodeException> errors, Collection<OpenLMessage> messages, IBindingContext bindingContext) {
        Iterator<SyntaxNodeException> errorItr = errors.iterator();
        while (errorItr.hasNext()) {
            SyntaxNodeException error = errorItr.next();
            try {
                XlsUrlParser xlsUrlParser = new XlsUrlParser(error.getSourceLocation());
                if (tableSyntaxNode.getUriParser().intersects(xlsUrlParser)) continue;
                bindingContext.addError(error);
                errorItr.remove();
            }
            catch (Exception xlsUrlParser) {}
        }
        Iterator<OpenLMessage> messagesItr = messages.iterator();
        while (messagesItr.hasNext()) {
            OpenLMessage message = messagesItr.next();
            try {
                XlsUrlParser xlsUrlParser = new XlsUrlParser(message.getSourceLocation());
                if (tableSyntaxNode.getUriParser().intersects(xlsUrlParser)) continue;
                bindingContext.addMessage(message);
                messagesItr.remove();
            }
            catch (Exception exception) {}
        }
    }

    private void validateReturnType(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, TableStructure tableStructure) throws SyntaxNodeException {
        if (tableStructure.actions.isEmpty()) {
            throw SyntaxNodeExceptionUtils.createError((String)"Invalid Decision Table headers: At least one return column header is required.", (ISyntaxNode)tableSyntaxNode);
        }
        if (NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{decisionTable.getType()})) {
            return;
        }
        if (ClassUtils.isAssignable((Class)decisionTable.getType().getInstanceClass(), Map.class)) {
            if (tableStructure.hasCollectReturnAction && !tableStructure.hasCollectReturnKeyAction) {
                throw SyntaxNodeExceptionUtils.createError((String)"Invalid Decision Table headers: At least one KEY header is required.", (ISyntaxNode)tableSyntaxNode);
            }
            if (tableStructure.hasCollectReturnKeyAction && !tableStructure.hasCollectReturnAction) {
                throw SyntaxNodeExceptionUtils.createError((String)"Invalid Decision Table headers: At least one CRET header is required.", (ISyntaxNode)tableSyntaxNode);
            }
        }
    }

    private ILogicalTable unmergeFirstRow(ILogicalTable toParse) {
        return LogicalTableHelper.unmergeColumns(toParse, 4, toParse.getWidth());
    }

    private boolean needToUnmergeFirstRow(ILogicalTable toParse) {
        String header = this.getHeaderStr(0, toParse);
        return DecisionTableHelper.isConditionHeader(header) && !DecisionTableHelper.isValidMergedConditionHeader(header);
    }

    private void putTableForBusinessView(TableSyntaxNode tableSyntaxNode, boolean transpose) {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (tableBody == null) {
            return;
        }
        if (!(DecisionTableHelper.isSmartDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode))) {
            tableBody = transpose ? (ILogicalTable)tableBody.getColumns(3) : (ILogicalTable)tableBody.getRows(3);
        }
        tableSyntaxNode.getSubTables().put("business", tableBody);
    }

    private String getHeaderStr(int row, ILogicalTable table) {
        String headerStr = ((ILogicalTable)table.getRow(row)).getSource().getCell(0, 0).getStringValue();
        if (headerStr == null) {
            return "";
        }
        return headerStr.toUpperCase();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadRow(DecisionTable decisionTable, TableStructure tableStructure, ILogicalTable table, int row, IBindingContext bindingContext) throws SyntaxNodeException {
        String header = this.getHeaderStr(row, table);
        if (DecisionTableHelper.isConditionHeader(header)) {
            tableStructure.conditions.add(new Condition(header, row, table, this.getConditionScale(tableStructure, header)));
            return;
        }
        if (DecisionTableHelper.isValidActionHeader(header)) {
            tableStructure.actions.add(new Action(header, row, table, ActionType.ACTION, DTScale.getStandardScale(), decisionTable));
            return;
        }
        if (DecisionTableHelper.isValidRuleHeader(header)) {
            this.addRule(row, table, tableStructure, bindingContext);
            return;
        }
        if (DecisionTableHelper.isValidKeyHeader(header)) {
            tableStructure.actions.add(new Action(header, row, table, ActionType.COLLECT_RETURN_KEY, DTScale.getStandardScale(), decisionTable));
            tableStructure.hasCollectReturnKeyAction = true;
            return;
        }
        if (DecisionTableHelper.isValidRetHeader(header)) {
            if (tableStructure.hasCollectReturnAction) {
                throw SyntaxNodeExceptionUtils.createError((String)String.format("Invalid Decision Table header '%s'. Headers '%s' and '%s' cannot be used together.", header, tableStructure.firstUsedReturnActionHeader, header), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
            }
            tableStructure.actions.add(new Action(header, row, table, ActionType.RETURN, DTScale.getStandardScale(), decisionTable));
            if (tableStructure.firstUsedReturnActionHeader == null) {
                tableStructure.firstUsedReturnActionHeader = header;
            }
            tableStructure.hasReturnAction = true;
            return;
        }
        if (!DecisionTableHelper.isValidCRetHeader(header)) {
            if (ParserUtils.isBlankOrCommented((String)header)) return;
            throw SyntaxNodeExceptionUtils.createError((String)String.format("Invalid Decision Table header '%s'.", header), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
        if (tableStructure.hasReturnAction) {
            throw SyntaxNodeExceptionUtils.createError((String)String.format("Invalid Decision Table header '%s'. Headers '%s' and '%s' cannot be used together.", header, tableStructure.firstUsedReturnActionHeader, header), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
        tableStructure.hasCollectReturnAction = true;
        if (tableStructure.firstUsedReturnActionHeader == null) {
            tableStructure.firstUsedReturnActionHeader = header;
        }
        if (this.validateCollectReturnType(decisionTable)) {
            tableStructure.actions.add(new Action(header, row, table, ActionType.COLLECT_RETURN, DTScale.getStandardScale(), decisionTable));
            return;
        }
        if (!DecisionTableHelper.isSmart(decisionTable.getSyntaxNode()) && !DecisionTableHelper.isSimple(decisionTable.getSyntaxNode())) {
            throw SyntaxNodeExceptionUtils.createError((String)String.format("Decision table return type '%s' is incompatible with column header '%s'.", decisionTable.getType().getName(), header), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
        boolean isMap = decisionTable.getSyntaxNode().getHeader().getCollectParameters().length > 0;
        String errorMsg = String.format("Decision table return type '%s' is incompatible with keyword 'Collect' in the table header, expected %s.", decisionTable.getType().getName(), isMap ? "a map" : "an array or a collection");
        throw SyntaxNodeExceptionUtils.createError((String)errorMsg, (ISyntaxNode)decisionTable.getSyntaxNode());
    }

    private boolean validateCollectReturnType(DecisionTable decisionTable) {
        IOpenClass type = decisionTable.getType();
        if (type.isArray()) {
            return true;
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Collection.class)) {
            return true;
        }
        return ClassUtils.isAssignable((Class)type.getInstanceClass(), Map.class);
    }

    @FunctionalInterface
    private static interface Supplier {
        public void get() throws Exception;
    }

    private static class CompilationErrors {
        private final List<SyntaxNodeException> bindingSyntaxNodeException;
        private final Collection<OpenLMessage> openLMessages;
        private final Exception ex;
        private final DecisionTableMetaInfoReader.MetaInfoHolder metaInfos;
        private final List<DecisionTable.DeferredChange> deferredChanges;

        private CompilationErrors(List<SyntaxNodeException> bindingSyntaxNodeException, Collection<OpenLMessage> openLMessages, DecisionTableMetaInfoReader.MetaInfoHolder metaInfos, Exception ex, List<DecisionTable.DeferredChange> deferredChanges) {
            this.bindingSyntaxNodeException = Objects.requireNonNull(bindingSyntaxNodeException, "bindingSyntaxNodeException cannot be null");
            this.openLMessages = Objects.requireNonNull(openLMessages, "openLMessages cannot be null");
            this.metaInfos = metaInfos;
            this.ex = ex;
            this.deferredChanges = deferredChanges;
        }

        private void apply(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, IBindingContext bindingContext) {
            this.bindingSyntaxNodeException.forEach(arg_0 -> ((IBindingContext)bindingContext).addError(arg_0));
            this.openLMessages.forEach(arg_0 -> ((IBindingContext)bindingContext).addMessage(arg_0));
            if (!bindingContext.isExecutionMode()) {
                DecisionTableMetaInfoReader decisionTableMetaInfoReader = (DecisionTableMetaInfoReader)tableSyntaxNode.getMetaInfoReader();
                decisionTableMetaInfoReader.getMetaInfos().merge(this.metaInfos);
            }
            decisionTable.getDeferredChanges().clear();
            decisionTable.getDeferredChanges().addAll(this.deferredChanges);
        }

        public Exception getEx() {
            return this.ex;
        }

        public List<SyntaxNodeException> getBindingSyntaxNodeException() {
            return this.bindingSyntaxNodeException;
        }
    }

    private static enum Direction {
        UNKNOWN,
        TRANSPOSED,
        NORMAL;

    }

    private static class TableStructure {
        private final List<IBaseCondition> conditions = new ArrayList<IBaseCondition>();
        private final List<IBaseAction> actions = new ArrayList<IBaseAction>();
        private boolean hasReturnAction = false;
        private boolean hasCollectReturnAction = false;
        private boolean hasCollectReturnKeyAction = false;
        private String firstUsedReturnActionHeader = null;
        private RuleRow ruleRow;
        private DTInfo info;
        private int columnsNumber;

        private TableStructure() {
        }
    }
}

