/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.util.Date;
import org.openl.rules.lang.xls.OverloadedMethodsDictionary;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.formatters.Formats;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenMethod;
import org.openl.util.StringUtils;

public final class TableSyntaxNodeUtils {
    private TableSyntaxNodeUtils() {
    }

    public static String[] getTableDisplayValue(TableSyntaxNode tableSyntaxNode, int i, Formats formats) {
        return TableSyntaxNodeUtils.getTableDisplayValue(tableSyntaxNode, i, null, formats);
    }

    public static String[] getTableDisplayValue(TableSyntaxNode tableSyntaxNode, int i, OverloadedMethodsDictionary dictionary, Formats formats) {
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        String display = null;
        String name = null;
        if (tableProperties != null) {
            display = name = tableProperties.getName();
        }
        if (name == null) {
            name = TableSyntaxNodeUtils.str2name(tableSyntaxNode.getGridTable().getCell(0, 0).getStringValue(), tableSyntaxNode.getNodeType());
        }
        if (display == null) {
            display = tableSyntaxNode.getGridTable().getCell(0, 0).getStringValue();
        }
        Object sfx = i < 2 ? "" : " (" + i + ")";
        Object dimensionInfo = "";
        if (dictionary != null && tableProperties != null && tableSyntaxNode.getMember() instanceof IOpenMethod && dictionary.contains((IOpenMethod)tableSyntaxNode.getMember()) && dictionary.getAllMethodOverloads((IOpenMethod)tableSyntaxNode.getMember()).size() > 1) {
            String[] dimensionalPropertyNames;
            for (String dimensionalPropertyName : dimensionalPropertyNames = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames()) {
                Object propertyValue = tableProperties.getPropertyValue(dimensionalPropertyName);
                String value = formats != null && propertyValue instanceof Date ? formats.formatDateOrDateTime((Date)propertyValue) : tableProperties.getPropertyValueAsString(dimensionalPropertyName);
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                String propertyInfo = dimensionalPropertyName + "=" + value;
                dimensionInfo = (String)dimensionInfo + (StringUtils.isEmpty((CharSequence)dimensionInfo) ? "" : ", ") + propertyInfo;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)dimensionInfo)) {
            sfx = (String)sfx + " [" + (String)dimensionInfo + "]";
        }
        return new String[]{name + (String)sfx, display + (String)sfx, display + (String)sfx};
    }

    public static String str2name(String methodHeader, XlsNodeTypes tableType) {
        Object resultName = methodHeader;
        if (StringUtils.isBlank((CharSequence)resultName)) {
            resultName = "NO NAME";
        } else if (tableType.equals((Object)XlsNodeTypes.XLS_OTHER)) {
            if (((String)resultName).length() > 57) {
                resultName = ((String)resultName).substring(0, 57) + "...";
            }
        } else if (tableType.equals((Object)XlsNodeTypes.XLS_DATATYPE)) {
            int first = StringUtils.firstNonSpace((CharSequence)resultName, (int)0, (int)((String)resultName).length());
            first = StringUtils.first((CharSequence)resultName, (int)first, (int)((String)resultName).length(), StringUtils::isSpaceOrControl);
            int last = StringUtils.first((CharSequence)resultName, (int)(first = StringUtils.firstNonSpace((CharSequence)resultName, (int)first, (int)((String)resultName).length())), (int)((String)resultName).length(), StringUtils::isSpaceOrControl);
            if (last < 0) {
                last = ((String)resultName).length();
            }
            if (first > 0) {
                resultName = ((String)resultName).substring(first, last);
            }
        } else {
            int last = StringUtils.first((CharSequence)resultName, (int)0, (int)((String)resultName).length(), x -> x == 40);
            if (last < 0) {
                last = ((String)resultName).length();
            }
            last = StringUtils.lastNonSpace((CharSequence)resultName, (int)0, (int)last) + 1;
            int first = StringUtils.last((CharSequence)resultName, (int)0, (int)last, StringUtils::isSpaceOrControl);
            resultName = ((String)resultName).substring(first + 1, last);
        }
        return ((String)resultName).trim();
    }

    public static String getTestName(IOpenMethod testMethod) {
        IMemberMetaInfo mi = testMethod.getInfo();
        TableSyntaxNode tnode = (TableSyntaxNode)mi.getSyntaxNode();
        return TableSyntaxNodeUtils.getTableDisplayValue(tnode, 0, null)[0];
    }
}

